. code
bounce 	START	0

		LDA		NUM_B
		MUL		D_SIZE
		STA		MAXIDX


LOOP 	LDX		INDEX

		LDA		ballX,X
		COMP	maxX
		JEQ		X_WALL		. hits right wall

		COMP	ZERO
		JEQ		X_WALL 		. hits left wall

cmpY	LDA		ballY,X
		COMP	maxY
		JEQ		Y_WALL		. hits bottom

		COMP	ZERO
		JEQ		Y_WALL 		. hits top

endCOMP	LDA		bColour,X
		STA		colour

		LDA		ballX,X
		LDB		ballY,X
		LDT		HEIGHT
		MULR	T, B		.flatten
		ADDR	B, A

		STX		INDEX
		RMO		A, X		. copy flattened old coordinates to X

		LDCH	BLACK		. clear screen
		+STCH	SCREEN,X
		LDX	INDEX	

		LDA		ballX,X		.//calculae new X
		LDT		bSpeedX,X
		ADDR	T, A
		STA		ballX,X

		LDB		ballY,X		. calculate new Y
		LDT		bSpeedY, X
		ADDR	T, B
		STB		ballY,X

		LDT		HEIGHT
		MULR	T, B		. flatten
		ADDR	B, A

		STX		INDEX
		RMO		A, X		. copy flattened old coordinates to X

		LDA		colour
		+STCH	SCREEN,X	. update screen
		LDX		INDEX	

		. reset
		LDA   	#3
    	ADDR 	A,X          
    	STX   	INDEX        

    	LDA   	MAXIDX       
   		COMPR 	X,A          
    	JLT   	LOOP         . while X < A -> keep looping balls

    	LDX   	#0           . wrap
    	STX   	INDEX
    	J     	LOOP
	

halt	J		halt

		END		bounce

. functions
X_WALL	LDB		bSpeedX,X
		LDT		MINUS1
		MULR	B, T
		STT		bSpeedX,X
		J		cmpY

Y_WALL	LDB		bSpeedY,X
		LDT		MINUS1
		MULR	B, T
		STT		bSpeedY,X
		J		endCOMP	


. data
ZERO	WORD	0
MINUS1	WORD	-1

D_SIZE	WORD	3
INDEX	WORD	0
MAXIDX	RESW	1

NUM_B	WORD	3

colour 	RESW	1

. ball data
ballX	WORD	60
		WORD	32
		WORD	32

ballY	WORD	32
		WORD	32
		WORD	32

bSpeedX	WORD	1
		WORD	0
		WORD	1
	
bSpeedY	WORD	1
		WORD	1
		WORD	0

bColour	WORD	195		. blue
		WORD	204 	. green
		WORD	240		. red

maxX	WORD	63
maxY	WORD	63
WIDTH	WORD	64
HEIGHT	WORD	64

. colors
BLACK	BYTE	0

. screen
		ORG		0xA000 
SCREEN	RESB	4096
