import unittest

class Test(unittest.TestCase):
    pravokotniki = [(0, 1, 4, 3),
                    (0, 6, 1, 8),
                    (2, 2, 7, 6),
                    (3, 4, 6, 5),
                    (5, 1, 9, 7),
                    (8, 0, 10, 2),
                    (8, 3, 10, 5),
                    (8, 6, 11, 8)]

    def test_01_preberi_pravokotnike(self):
        self.assertEqual(preberi_pravokotnike("pravokotniki.txt"), self.pravokotniki)

    def test_02_nepokritih(self):
        self.assertEqual(nepokrito(self.pravokotniki, 11, 8), 34)

    def test_03_odstrani_zgresene(self):
        streli = [(0.55, 0.4), (0.1, 5), (5.1, 3.2), (7.1, 7.1), (8.5, 3.5)]
        self.assertIsNone(odstrani_zgresene(streli, self.pravokotniki))
        self.assertEqual(streli, [(5.1, 3.2), (8.5, 3.5)])

    def test_04_je_zlata(self):
        prekritja = {3: (4, 5), 5: (1, ), 4: (6, 7, 8), 2: (), 1: (), 6: (), 7: (), 8: ()}
        barve = {1: "zlata", 2: "zlata", 3: "modra", 4: "rdeca", 5: "rumena",
                 6: "zelena", 7: "rumena", 8: "modra", 9: "zelena"}

        self.assertTrue(je_zlata(1, barve, prekritja))
        self.assertTrue(je_zlata(2, barve, prekritja))
        self.assertTrue(je_zlata(3, barve, prekritja))
        self.assertFalse(je_zlata(4, barve, prekritja))
        self.assertTrue(je_zlata(5, barve, prekritja))
        self.assertFalse(je_zlata(6, barve, prekritja))
        self.assertFalse(je_zlata(7, barve, prekritja))
        self.assertFalse(je_zlata(8, barve, prekritja))

        prekritja[3] = (5, 4)
        self.assertTrue(je_zlata(3, barve, prekritja))

        barve[8] = "zlata"
        barve[3] = "rumena"
        self.assertTrue(je_zlata(3, barve, prekritja))

        barve[8] = "modra"
        barve[6] = "zlata"
        self.assertTrue(je_zlata(3, barve, prekritja))

    def test_05_pravokotnik(self):
        pravokotnik = Pravokotnik(3, 2, 7, 6)
        self.assertEqual(pravokotnik.vseh_zadetkov(), 0)
        self.assertEqual(pravokotnik.vseh_strelcev(), 0)

        pravokotnik.strel(1, 1, "Ana")
        pravokotnik.strel(1, 2, "Ana")
        pravokotnik.strel(3.5, 1.5, "Ana")
        pravokotnik.strel(3.5, 7, "Ana")
        self.assertEqual(pravokotnik.vseh_zadetkov(), 0)
        self.assertEqual(pravokotnik.vseh_strelcev(), 1)
        self.assertEqual(pravokotnik.zadetkov("Ana"), 0)

        pravokotnik.strel(3.5, 4, "Ana")
        pravokotnik.strel(3.5, 4, "Ana")
        pravokotnik.strel(3.5, 4, "Berta")
        self.assertEqual(pravokotnik.vseh_zadetkov(), 3)
        self.assertEqual(pravokotnik.vseh_strelcev(), 2)
        self.assertEqual(pravokotnik.zadetkov("Ana"), 2)


if __name__ == "__main__":
    unittest.main()
