#include "Main.h"
#include "AT91SAM9260.h"        

/* Zaradi napake v prevajalniku mora biti definirana ta spremenljivka */
int dummy = 1;

#define PORT  AT91C_BASE_PIOC           // PIN PORTC1
#define PIN   1                         // PIN PORTC1

//------------------------------------------------------------------------------
/// Configure Timer Counter 0 to generate an interrupt every 250ms.
//------------------------------------------------------------------------------




int find_length(char *input)
{
    int length = 0;
    while(input[length] != '\0') 
    {
        length++;
    }
	return length;
}


void XMCHAR(char c)
{
	if(c == '.')
	{
		LED_On(PORT);
        Delay(150);
	}
	if(c == '-')
	{
		LED_On(PORT);
        Delay(300);
	}	
	LED_Off(PORT);
	Delay(150);

}

void XMCODE(char c[])
{
	int i;
	for(i = 0; i < find_length(c); i++)
	{
		XMCHAR(c[i]);
	}
	Delay(150);
}

char * GETMCODE(char c)
{
	switch(c)
  {
  case 'A':
    return ".-";
    break;
    
  case 'B':
    return "-...";
    break;
    
  case 'C':
    return "-.-.";
    break;  
    
  case 'D':
    return "-..";
    break;
        
  case 'E':
    return ".";
    break;
        
  case 'F':
    return "..-.";
    break;
        
  case 'G':
    return "--.";
    break;
        
  case 'H':
    return "....";
    break;
        
  case 'I':
    return "..";
    break;  
    
  case 'J':
    return ".---";
    break;
            
  case 'K':
    return "-.-";
    break;
            
  case 'L':
    return ".-..";
    break;
            
  case 'M':
    return "--";
    break;
            
  case 'N':
    return "-.";
    break;
            
  case 'O':
    return "---";
    break;
            
  case 'P':
    return ".--.";
    break;
            
  case 'Q':
    return "--.-";
    break;
            
  case 'R':
    return ".-.";
    break;
            
  case 'S':
    return "...";
    break;
            
  case 'T':
    return "-";
    break;
            
  case 'U':
    return "..-";
    break;
            
  case 'V':
    return "...-";
    break;
            
  case 'W':
    return ".--";
    break;
            
  case 'X':
    return "-..-";
    break;
            
  case 'Y':
    return "-.--";
    break;
            
  case 'Z':
    return "--..";
    break;
      
  default:
    return ".-";
    break;
    
  }
}

void XWORD(char c[])
{
	int i;
	for(i = 0; i < find_length(c); i++)
	{
		char *mc = GETMCODE(c[i]);
    if(mc >= 'a' && mc <= 'z')
      XMCODE(mc - 32);  
    else
	    XMCODE(mc);
	}
	Delay(1000);
}





void Init_Timer_Tc0(void)
{
    unsigned int div;
    unsigned int tcclks;

    // Enable peripheral clock
    AT91C_BASE_PMC->PMC_PCER = 1 << AT91C_ID_TC0;
                          
                          
//    AT91C_BASE_TC0->CMR = (0b110 << 13) | 0b011 ;
    // Configure TC for a 1ms and trigger on RC compare   |  Clock selected: TIMER_DIV4_CLOCK
    AT91C_BASE_TC0->TC_CMR =  AT91C_TC_WAVESEL_UP_AUTO | AT91C_TC_WAVE | AT91C_TC_CLKS_TIMER_DIV4_CLOCK ;

    AT91C_BASE_TC0->TC_RC = 375;
      
    // Enable TC clock
    AT91C_BASE_TC0->TC_CCR = AT91C_TC_CLKEN | AT91C_TC_SWTRG ;


}


//void initPIO_Port(const AT91PS_PIO port)
void initPIO_Port(AT91S_PIO *port)
{
    port->PIO_PER=1<<PIN;
    port->PIO_OER=1<<PIN;
}   // initPIO_Port

void LED_On(AT91PS_PIO port)
{
    port->PIO_CODR=1<<PIN;
}   

void LED_Off(AT91PS_PIO port)
{
    port->PIO_SODR=1<<PIN;
}   

void Delay(unsigned int Counter) {
  volatile unsigned int i;

  for (i=0;i<Counter;i++) {
    while ( (AT91C_BASE_TC0->TC_SR & AT91C_TC_CPCS ) == 0);
  };
}



int main(void)
{         
  initPIO_Port(PORT);
  Init_Timer_Tc0();
  
  LED_Off(PORT);
  
  /* Loop for ever */
  while (1) {
      // Deluje za male in velike zacetnice
      XWORD("sos"); 
      XWORD("SOS"); 
  };      
}
