var EcDiagnostics;!function(EcDiagnostics){!function(Commons){Commons.extensionName="TcHmiEcDiagnostics",Commons.customElementsPrefix="beckhoff-ec-diagnostics-"}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class ColorRGBA{constructor(r,g=r,b=r,a=1){this.__r=r,this.__g=g,this.__b=b,this.__a=a}getRGBAString(a=1){return`rgba(${this.__r}, ${this.__g}, ${this.__b}, ${a*this.__a})`}getHexString(includeOpacity=!1){let hexString="";return includeOpacity&&(hexString+=`${this.__a.toString(16).padStart(2,"0")}`),hexString+=`#${this.__r.toString(16).padStart(2,"0")}${this.__g.toString(16).padStart(2,"0")}${this.__b.toString(16).padStart(2,"0")}`,hexString}static resolveSolidColorAsCssValue(colorObject){return"none"===colorObject.color.toLowerCase()?"transparent":colorObject.color}static resolveSolidColorAsRGBA(colorObject){const canvas=document.createElement("canvas");canvas.width=canvas.height=1;const ctx=canvas.getContext("2d");ctx.clearRect(0,0,1,1),ctx.fillStyle=ColorRGBA.resolveSolidColorAsCssValue(colorObject),ctx.fillRect(0,0,1,1);const rgba=ctx.getImageData(0,0,1,1).data;return new ColorRGBA(rgba[0],rgba[1],rgba[2],rgba[3]/255)}}Commons.ColorRGBA=ColorRGBA,Commons.ColorRGBA_Black=new ColorRGBA(0),Commons.ColorRGBA_White=new ColorRGBA(255),Commons.ColorRGBA_Red=new ColorRGBA(255,0,0),Commons.ColorRGBA_Orange=new ColorRGBA(255,165,0),Commons.ColorRGBA_DimGray=new ColorRGBA(105),Commons.ColorRGBA_Success=new ColorRGBA(111,153,87),Commons.ColorRGBA_SuccessLight=new ColorRGBA(25,187,22),Commons.ColorRGBA_Warning=Commons.ColorRGBA_Orange,Commons.ColorRGBA_WarningLight=Commons.ColorRGBA_Orange,Commons.ColorRGBA_Error=new ColorRGBA(255,51,51),Commons.ColorRGBA_ErrorDark=new ColorRGBA(138,8,8),Commons.ColorRGBA_ErrorLight=new ColorRGBA(250,174,174)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class ElementWithCallback extends HTMLElement{constructor(){super(),this.__fnToCallOnRemove=[]}addFnToCallOnRemove(fn){this.__fnToCallOnRemove.push(fn)}__executeFnToCallOnRemove(){for(;this.__fnToCallOnRemove.length>0;){const fnToCallOnRemove=this.__fnToCallOnRemove.pop();fnToCallOnRemove&&fnToCallOnRemove()}}disconnectedCallback(){this.__executeFnToCallOnRemove()}remove(){this.__executeFnToCallOnRemove(),super.remove()}}Commons.ElementWithCallback=ElementWithCallback}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class CanvasTooltip extends Commons.ElementWithCallback{constructor(){super(),this.__hoverEventListener=null}connectedCallback(){this.__removeEvents(),this.__hoverEventListener=this.hide.bind(this),this.addEventListener("pointerover",this.__hoverEventListener)}disconnectedCallback(){this.__removeEvents()}__removeEvents(){this.__hoverEventListener&&(this.removeEventListener("pointerover",this.__hoverEventListener),this.__hoverEventListener=null)}hide(){this.style.removeProperty("display")}show(content,x,y){this.innerHTML="",this.append(content),this.style.display="block";const tooltipDimension_width=this.clientWidth,tooltipDimension_height=this.clientHeight;if(!this.parentElement)return;const tooltipPos={x:-0+x+15,y:-0+y+15};window.innerWidth<tooltipPos.x+tooltipDimension_width&&(tooltipPos.x=x-(15+tooltipDimension_width)),window.innerHeight<tooltipPos.y+tooltipDimension_height&&(tooltipPos.y=y-(15+tooltipDimension_height)),this.style.left=`${tooltipPos.x}px`,this.style.top=`${tooltipPos.y}px`}}Commons.CanvasTooltip=CanvasTooltip,customElements.define(Commons.customElementsPrefix+"canvas-tooltip",CanvasTooltip)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class PopUp extends Commons.ElementWithCallback{constructor(){super(),this.__firstAttach=!0,this.__innerFrame=document.createElement("div"),this.__header=document.createElement("div"),this.__title=document.createElement("span"),this.__closeBtn=document.createElement("button"),this.__removeTargets=[this,this.__closeBtn],this.__innerFrame.classList.add("inner-frame"),this.__header.classList.add("header"),this.__closeBtn.classList.add("regular-button","close-btn"),this.__closeBtn.textContent="X",this.__title.classList.add("title")}connectedCallback(){for(;this.firstChild;)this.__innerFrame.append(this.removeChild(this.firstChild));if(this.__header.append(this.__title),this.__header.append(this.__closeBtn),this.__innerFrame.prepend(this.__header),this.append(this.__innerFrame),this.__firstAttach){for(const removeTarget of this.__removeTargets)removeTarget.addEventListener("click",this.__removeTargetFn.bind(this,removeTarget));this.__firstAttach=!1}}setTitle(localization,contentKey){localization.addElement(this.__title,contentKey)}__removeTargetFn(removeTarget,event){event.target&&this.__removeTargets.includes(event.target)&&setTimeout((()=>{this.close()}),10)}close(){this.__header.remove(),this.__title.remove(),this.__closeBtn.remove(),this.__innerFrame.remove(),this.remove()}}Commons.PopUp=PopUp,customElements.define(Commons.customElementsPrefix+"pop-up",PopUp)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class ProcessDataView extends HTMLElement{constructor(slave,localization){super(),this.__pdo_types=[{key:"input",label:"Input"},{key:"output",label:"Output"}],this.__slave=slave,this.__localization=localization}connectedCallback(){this.__init(),this.__slave.subscribeToProcessDataValues()}disconnectedCallback(){this.__localization.cleanUp(),this.__slave.unsubscribeProcessValueSubscription()}__createTableHeaders(){const headline=document.createElement("div");headline.classList.add("headline","grid-full-row"),this.append(headline);const pdos=this.__slave.processData;if(pdos){headline.append(this.__localization.createLocalizedElement(`{{Slave_Processdata.bold}} ({{Input}}: ${pdos.input.length}, {{Output}}: ${pdos.output.length})`));const gridHeaderName=document.createElement("div");gridHeaderName.classList.add("entry-cell"),this.__localization.addElement(gridHeaderName,"Slave_Processdata_Name");const gridHeaderType=document.createElement("div");gridHeaderType.classList.add("entry-cell"),this.__localization.addElement(gridHeaderType,"Slave_Processdata_Type");const gridHeaderSize=document.createElement("div");gridHeaderSize.classList.add("entry-cell"),this.__localization.addElement(gridHeaderSize,"Slave_Processdata_Size");const gridHeaderForceStateAndValue=document.createElement("div");gridHeaderForceStateAndValue.classList.add("entry-cell"),gridHeaderForceStateAndValue.innerHTML='<span class="forced-process-data-value-flag-placeholder"></span>';const gridHeaderValue=document.createElement("span");if(gridHeaderValue.classList.add("entry-cell"),this.__localization.addElement(gridHeaderValue,"Slave_Processdata_Value"),gridHeaderForceStateAndValue.append(gridHeaderValue),this.append(gridHeaderName,gridHeaderType,gridHeaderSize,gridHeaderForceStateAndValue),this.__slave.main.getSymbolAccess(`${Commons.extensionName}.SetProcessDataValues`)||this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ForceProcessDataValues`)){const gridHeaderPreparedValue=document.createElement("div");gridHeaderPreparedValue.classList.add("entry-cell"),this.__localization.addElement(gridHeaderPreparedValue,"Slave_Processdata_Prepared_Value"),this.append(gridHeaderPreparedValue)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.SetProcessDataValues`)){const setAllBtn=document.createElement("button");setAllBtn.classList.add("entry-cell-element","regular-button"),setAllBtn.addEventListener("click",this.__setAllValues.bind(this)),this.__localization.addElement(setAllBtn,"Slave_Processdata_Set_All"),this.append(setAllBtn)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ForceProcessDataValues`)){const forceAllBtn=document.createElement("button");forceAllBtn.classList.add("entry-cell-element","regular-button"),this.__localization.addElement(forceAllBtn,"Slave_Processdata_Force_All"),forceAllBtn.addEventListener("click",this.__forceAllValues.bind(this)),this.append(forceAllBtn)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ReleaseProcessDataValues`)){const releaseAllBtn=document.createElement("button");releaseAllBtn.classList.add("entry-cell-element","regular-button"),releaseAllBtn.addEventListener("click",this.__releaseAllValues.bind(this)),this.__localization.addElement(releaseAllBtn,"Slave_Processdata_Release_All"),this.append(releaseAllBtn)}}else headline.append(this.__localization.createLocalizedElement("{{Slave_Processdata.bold}}: {{Slave_Processdata_No_Entries}}"))}__createTableEntries(){const pdos=this.__slave.processData;if(pdos)for(const pdo_type of this.__pdo_types){const pdos_io=pdos[pdo_type.key];if(!pdos_io)continue;const entryGroups={prev:{names:[],wrapper:[]},current:{names:[],wrapper:[]}};for(const processDataObject of pdos_io)for(const entry of processDataObject.entries){entry.value||(entry.value={forced:null,value:null,domElements:new Set,errorElements:new Set}),entryGroups.current.names=[processDataObject.name].concat(entry.name.split("__"));let wrapper=this;for(const[entryLayerIndex,entryLayerName]of entryGroups.current.names.entries())entryLayerIndex===entryGroups.current.names.length-1?this.__createTableEntry(wrapper,pdo_type.key,processDataObject.index,entry,entryLayerIndex,entryLayerName):wrapper=this.__createTableEntryParent(wrapper,pdo_type.key,entryLayerIndex,entryGroups);entryGroups.prev.names=entryGroups.current.names,entryGroups.prev.wrapper=entryGroups.current.wrapper}}}__createTableEntryParent(wrapper,pdo_type,layerIndex,entryGroups){const indent=20*layerIndex,cellEntryName=document.createElement("div");cellEntryName.classList.add("entry-cell"),cellEntryName.style.paddingLeft=`${indent}px`;const arrowMore=document.createElement("div");arrowMore.classList.add("arrow","arrow-right");const icon=document.createElement("span");icon.classList.add("entry-name-icon");const cellEntryLayerName=document.createElement("span");if(cellEntryLayerName.textContent=entryGroups.current.names[layerIndex],cellEntryName.append(arrowMore,icon,cellEntryLayerName),entryGroups.prev.names[layerIndex]===entryGroups.current.names[layerIndex])wrapper=entryGroups.current.wrapper[layerIndex]=entryGroups.prev.wrapper[layerIndex];else{const subGroup=document.createElement("div");subGroup.classList.add("grid-sub-group"),subGroup.style.display="none",entryGroups.current.wrapper[layerIndex]=subGroup,wrapper.append(cellEntryName,subGroup),wrapper=subGroup,entryGroups.prev.names=entryGroups.prev.wrapper=[],cellEntryName.classList.add("grid-full-row"),0===layerIndex?icon.classList.add(`icon-${pdo_type}-channel`):entryGroups.current.names[layerIndex+1].startsWith("ARRAY ")?(entryGroups.current.names[layerIndex+1]=entryGroups.current.names[layerIndex+1].slice("ARRAY ".length),icon.classList.add(`icon-${pdo_type}-array-entry`)):icon.classList.add(`icon-${pdo_type}-struct-entry`);let subOpened=!1;cellEntryName.addEventListener("click",(()=>{arrowMore.classList.toggle("arrow-down",!subOpened),arrowMore.classList.toggle("arrow-right",subOpened),subOpened?subGroup.style.display="none":subGroup.style.removeProperty("display"),subOpened=!subOpened}))}return wrapper}__createTableEntry(wrapper,pdoType,pdoIndex,entry,layerIndex,layerName){let indent=20*layerIndex;const cellEntryName=document.createElement("div");cellEntryName.classList.add("entry-cell"),cellEntryName.style.paddingLeft=`${indent}px`,indent+=20;const arrowMore=document.createElement("div");arrowMore.classList.add("arrow","arrow-right");const icon=document.createElement("span");icon.classList.add("entry-name-icon");const entryLayerName=document.createElement("span");entryLayerName.innerText=layerName,cellEntryName.append(arrowMore,icon,entryLayerName),wrapper.append(cellEntryName),icon.classList.add(`icon-${pdoType}-entry`);const cellEntryType=document.createElement("div");cellEntryType.textContent=entry.type,cellEntryType.classList.add("entry-cell");const cellEntryBitLength=document.createElement("div");cellEntryBitLength.classList.add("entry-cell"),cellEntryBitLength.classList.add("num"),cellEntryBitLength.textContent=entry.bitLength.toString();const cellEntryValue=document.createElement("div");cellEntryValue.classList.add("entry-cell"),cellEntryValue.addEventListener("click",(()=>{entry.showValueAsHex=!entry.showValueAsHex,this.__slave.updateProcessDataValuesOnlineElements(entry)})),cellEntryValue.classList.add("online-value"),cellEntryValue.textContent="-",wrapper.append(cellEntryType,cellEntryBitLength,cellEntryValue);const cellEntryError=document.createElement("div");cellEntryError.classList.add("grid-full-row"),cellEntryError.style.paddingLeft=`${indent}px`,cellEntryError.style.color="red";const entryReadErrorEl=document.createElement("div"),cbErrorEl=document.createElement("div");cbErrorEl.classList.add("entry-cell","hide"),cellEntryError.append(entryReadErrorEl,cbErrorEl),Commons.addDomElement("ExtendedInfoOfSlave",entry.value,cellEntryValue,entryReadErrorEl),this.__slave.updateProcessDataValuesOnlineElements(entry);let preparedValueInput=document.createElement("input");if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.SetProcessDataValues`)||this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ForceProcessDataValues`)){const cellPreparedValue=document.createElement("div");preparedValueInput.classList.add("regular-text-input"),"BIT"===entry.type&&1===entry.bitLength?(preparedValueInput=document.createElement(Commons.customElementsPrefix+"optional-bool-input"),preparedValueInput.mapValue(entry.value)):"BIT"===entry.type||"BYTE"===entry.type||entry.type.endsWith("INT")||entry.type.endsWith("WORD")?preparedValueInput.setAttribute("data-tchmi-input-mode","numeric"):entry.type.endsWith("REAL")&&preparedValueInput.setAttribute("data-tchmi-input-mode","decimal"),entry.preparedValue=preparedValueInput,cellPreparedValue.append(preparedValueInput),cellPreparedValue.classList.add("entry-cell"),wrapper.append(cellPreparedValue)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.SetProcessDataValues`)){const cellSetValueBtn=document.createElement("div"),setValueBtn=document.createElement("button");setValueBtn.classList.add("regular-button"),this.__localization.addElement(setValueBtn,"Slave_Processdata_Set"),setValueBtn.addEventListener("click",(()=>{this.__setValue(preparedValueInput,cbErrorEl,pdoType,pdoIndex,entry.index,entry.subIndex)})),cellSetValueBtn.append(setValueBtn),cellSetValueBtn.classList.add("entry-cell"),wrapper.append(cellSetValueBtn)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ForceProcessDataValues`)){const cellForceValueBtn=document.createElement("div"),forceValueBtn=document.createElement("button");forceValueBtn.classList.add("regular-button"),this.__localization.addElement(forceValueBtn,"Slave_Processdata_Force"),forceValueBtn.addEventListener("click",(e=>{this.__forceValue(preparedValueInput,cbErrorEl,pdoType,pdoIndex,entry.index,entry.subIndex)})),cellForceValueBtn.append(forceValueBtn),cellForceValueBtn.classList.add("entry-cell"),wrapper.append(cellForceValueBtn)}if(this.__slave.main.getSymbolAccess(`${Commons.extensionName}.ReleaseProcessDataValues`)){const cellReleaseValueBtn=document.createElement("div"),releaseValueBtn=document.createElement("button");releaseValueBtn.classList.add("regular-button"),this.__localization.addElement(releaseValueBtn,"Slave_Processdata_Release"),releaseValueBtn.addEventListener("click",(()=>{this.__releaseValue(cbErrorEl,pdoType,pdoIndex,entry.index,entry.subIndex)})),cellReleaseValueBtn.append(releaseValueBtn),cellReleaseValueBtn.classList.add("entry-cell"),wrapper.append(cellReleaseValueBtn)}wrapper.append(cellEntryError);const cellProcessDataChart=document.createElement("div");cellProcessDataChart.style.padding="0px",cellProcessDataChart.style.paddingLeft=`${indent}px`,cellProcessDataChart.setAttribute("colSpan","10"),cellProcessDataChart.classList.add("process-data-chart-wrapper","grid-full-row");const processDataChart_wrapper=document.createElement("div");processDataChart_wrapper.style.position="relative",cellProcessDataChart.append(processDataChart_wrapper),wrapper.append(cellProcessDataChart);let processDataChart_hidden=!0;cellEntryName.addEventListener("click",(()=>{processDataChart_hidden?(arrowMore.classList.remove("arrow-right"),arrowMore.classList.add("arrow-down"),this.__addProcessDataHistoryChart(processDataChart_wrapper,entry),processDataChart_hidden=!1):(arrowMore.classList.remove("arrow-down"),arrowMore.classList.add("arrow-right"),this.__removeProcessDataHistoryChart(processDataChart_wrapper),processDataChart_hidden=!0)}))}__init(){this.textContent="",this.__createTableHeaders(),this.__createTableEntries()}__setAllValues(){const writeValues=[];if(this.__slave.processData){for(const[ioType,ioPdos]of Object.entries(this.__slave.processData))for(const pdo of ioPdos)for(const entry of pdo.entries){if(!entry.preparedValue){TcHmi.Log.error("Prepared value of entry is not defined (yet).");continue}const newValue=entry.preparedValue.value;if(null===newValue||""===newValue)continue;const writeValue={io:ioType,objectIndex:pdo.index,entryIndex:entry.index,entrySubIndex:entry.subIndex,entryValue:entry.preparedValue.value};writeValues.push(writeValue),entry.preparedValue.value=""}this.__slave.setProcessDataValues(writeValues)}}__forceAllValues(){const writeValues=[];if(this.__slave.processData){for(const[ioType,ioPdos]of Object.entries(this.__slave.processData))for(const pdo of ioPdos)for(const entry of pdo.entries){if(!entry.preparedValue){TcHmi.Log.error("Prepared value of entry is not defined (yet).");continue}const newValue=entry.preparedValue.value;if(null===newValue||""===newValue)continue;const writeValue={io:ioType,objectIndex:pdo.index,entryIndex:entry.index,entrySubIndex:entry.subIndex,entryValue:entry.preparedValue.value};writeValues.push(writeValue),entry.preparedValue.value=""}this.__slave.forceProcessDataValues(writeValues)}}__releaseAllValues(){const writeValues=[];if(this.__slave.processData){for(const[ioType,ioPdos]of Object.entries(this.__slave.processData))for(const pdo of ioPdos)for(const entry of pdo.entries){const writeValue={io:ioType,objectIndex:pdo.index,entryIndex:entry.index,entrySubIndex:entry.subIndex};writeValues.push(writeValue)}this.__slave.releaseProcessDataValues(writeValues)}}__setValue(inputElement,cbErrorEl,io,objectIndex,entryIndex,entrySubIndex){const value=inputElement.value;null!==value&&(this.__slave.setProcessDataValues([{io:io,objectIndex:objectIndex,entryIndex:entryIndex,entrySubIndex:entrySubIndex,entryValue:value}],cbErrorEl),inputElement.value="",TcHmi.Log.info(`Value '${value}' applied.`))}__forceValue(inputElement,cbErrorEl,io,objectIndex,entryIndex,entrySubIndex){const value=inputElement.value;null!==value&&(this.__slave.forceProcessDataValues([{io:io,objectIndex:objectIndex,entryIndex:entryIndex,entrySubIndex:entrySubIndex,entryValue:value}],cbErrorEl),inputElement.value="",TcHmi.Log.info(`Value '${value}' forced.`))}__releaseValue(cbErrorEl,io,objectIndex,entryIndex,entrySubIndex){this.__slave.releaseProcessDataValues([{io:io,objectIndex:objectIndex,entryIndex:entryIndex,entrySubIndex:entrySubIndex}],cbErrorEl)}__addProcessDataHistoryChart(wrapper,entry){const infoEl=document.createElement("span"),canvas=document.createElement("canvas"),toggleHex=()=>{entry.showValueAsHex=!entry.showValueAsHex,this.__slave.updateProcessDataValuesOnlineElements(entry)};canvas.addEventListener("click",(()=>{entry.historyChartShowValuesRange=!entry.historyChartShowValuesRange})),wrapper.dataset.height="100";const chartCurrentValue=document.createElement("div");chartCurrentValue.classList.add("current-value"),chartCurrentValue.dataset.valueOnly="true",chartCurrentValue.addEventListener("click",toggleHex);const minMaxMarker={min:document.createElement("div"),max:document.createElement("div")};minMaxMarker.min.classList.add("min-value"),minMaxMarker.max.classList.add("max-value"),minMaxMarker.min.addEventListener("click",toggleHex),minMaxMarker.max.addEventListener("click",toggleHex),minMaxMarker.min.classList.add("hide"),minMaxMarker.max.classList.add("hide"),chartCurrentValue.classList.add("hide"),canvas.classList.add("hide"),infoEl.classList.add("hide"),entry.value?.domElements.add(chartCurrentValue);const historyChartUpdateInterval=setInterval((()=>{this.__drawProcessDataHistoryChart(wrapper,canvas,entry,historyChartUpdateInterval,minMaxMarker,chartCurrentValue,infoEl)}),50);this.__drawProcessDataHistoryChart(wrapper,canvas,entry,historyChartUpdateInterval,minMaxMarker,chartCurrentValue,infoEl),wrapper.append(minMaxMarker.min,minMaxMarker.max,chartCurrentValue,canvas,infoEl),this.__slave.updateProcessDataValuesOnlineElements(entry)}__drawProcessDataHistoryChart(wrapper,canvas,entry,historyChartUpdateInterval,minMaxMarker,currentValueEl,infoEl){const tsNow=Date.now();if(entry.historyChartsVisible||(entry.historyChartsVisible=new Set),0===wrapper.offsetWidth){if(entry.historyChartsVisible.delete(canvas),entry.historyValue?.splice(0,entry.historyValue.length-1),!wrapper.isConnected)return void clearInterval(historyChartUpdateInterval)}else entry.historyChartsVisible.add(canvas);if(!entry.historyValue)return minMaxMarker.min.classList.add("hide"),minMaxMarker.max.classList.add("hide"),currentValueEl.classList.add("hide"),canvas.classList.add("hide"),infoEl.textContent="No value data to display history chart.",void infoEl.classList.remove("hide");for(minMaxMarker.min.classList.remove("hide"),minMaxMarker.max.classList.remove("hide"),currentValueEl.classList.remove("hide"),canvas.classList.remove("hide"),infoEl.classList.add("hide");entry.historyValue.length>1&&entry.historyValue[1].ts+3e4<tsNow;)entry.historyValue.shift();const ctx=canvas.getContext("2d");ctx.imageSmoothingEnabled=!0;const wrapperHeight=parseInt(wrapper.dataset.height??"0",10),canvasSize={width:wrapper.offsetWidth-10,height:wrapperHeight};canvas.width=canvasSize.width,canvas.height=canvasSize.height;const chartSize={width:canvasSize.width,height:canvasSize.height-10};ctx.setTransform(1,0,0,-1,0,chartSize.height+5),ctx.clearRect(0,-5,canvas.width,canvas.height),ctx.strokeStyle=Commons.appearance?.processData.historyChart.grid.lineColor.getHexString()??"black",ctx.lineWidth=Commons.appearance?.processData.historyChart.grid.lineWidth??1;const stepCount={x:Commons.appearance?.processData.historyChart.grid.numOfVerticalLines??1,y:Commons.appearance?.processData.historyChart.grid.numOfHorizontalLines??1},yOffsetBelow=Commons.appearance?.processData.historyChart.grid.yOffsetBelow??0,yOffsetAbove=Commons.appearance?.processData.historyChart.grid.yOffsetAbove??0;stepCount.y+=yOffsetBelow+yOffsetAbove;const stepSize_x=chartSize.width/stepCount.x,stepSize_y=chartSize.height/stepCount.y,secondsPerStep=30/stepCount.x,xOffset=-stepSize_x*(Date.now()/1e3%secondsPerStep/secondsPerStep);for(let i=0;i<=stepCount.x;i++)ctx.moveTo(xOffset+i*stepSize_x,0),ctx.lineTo(xOffset+i*stepSize_x,chartSize.height);for(let i=0;i<=stepCount.y;i++)ctx.moveTo(0,stepSize_y*i),ctx.lineTo(chartSize.width,stepSize_y*i);ctx.stroke();const drawingChartSize={width:chartSize.width,height:chartSize.height-stepSize_y*(yOffsetBelow+yOffsetAbove)};ctx.save(),ctx.translate(0,yOffsetBelow*stepSize_y),ctx.beginPath(),ctx.strokeStyle=Commons.appearance?.processData.historyChart.grid.minValue.lineColor.getHexString()??"black",ctx.lineWidth=Commons.appearance?.processData.historyChart.grid.minValue.lineWidth??1,ctx.moveTo(0,0),ctx.lineTo(chartSize.width,0),ctx.stroke(),ctx.beginPath(),ctx.strokeStyle=Commons.appearance?.processData.historyChart.grid.maxValue.lineColor.getHexString()??"black",ctx.lineWidth=Commons.appearance?.processData.historyChart.grid.maxValue.lineWidth??1,ctx.moveTo(0,drawingChartSize.height),ctx.lineTo(chartSize.width,drawingChartSize.height),ctx.stroke();let limit=null;let datatypeRange=null;if(["BIT","BIT2","UINT","USINT"].includes(entry.type)&&entry.bitLength?datatypeRange={min:0,max:Math.pow(2,entry.bitLength)-1}:["INT","DINT"].includes(entry.type)&&entry.bitLength&&(datatypeRange={min:-Math.pow(2,entry.bitLength)/2,max:Math.pow(2,entry.bitLength)/2-1}),!entry.historyChartShowValuesRange&&null!==datatypeRange||1===entry.bitLength)datatypeRange&&(limit={min:datatypeRange.min,max:datatypeRange.max});else for(const tsValue of entry.historyValue)null===limit?limit={min:tsValue.value,max:tsValue.value}:(limit.min=Math.min(limit.min,tsValue.value),limit.max=Math.max(limit.max,tsValue.value));if(null===limit)return void TcHmi.Log.error("Limit not set.");limit.min===limit.max&&(datatypeRange?.min!==limit.min&&(limit.min+=-1),datatypeRange?.max===limit.max&&limit.max!==limit.min||(limit.max+=1)),1===entry.bitLength?(minMaxMarker.min.textContent="false",minMaxMarker.max.textContent="true"):entry.showValueAsHex?(minMaxMarker.min.textContent=Commons.Utility.toHexString(limit.min),minMaxMarker.max.textContent=Commons.Utility.toHexString(limit.max),entry.historyChartShowValuesRange&&datatypeRange&&(minMaxMarker.min.textContent+=` (${Commons.Utility.toHexString(datatypeRange.min)})`,minMaxMarker.max.textContent+=` (${Commons.Utility.toHexString(datatypeRange.max)})`)):(minMaxMarker.min.textContent=limit.min.toString(10),minMaxMarker.max.textContent=limit.max.toString(10),entry.historyChartShowValuesRange&&datatypeRange&&(minMaxMarker.min.textContent+=` (${datatypeRange.min})`,minMaxMarker.max.textContent+=` (${datatypeRange.max})`));const yRange=Math.abs(limit.max-limit.min);if(limit.max>0&&limit.min<0&&1!==entry.bitLength){const zeroRelativeYValue=(0-limit.min)/yRange*drawingChartSize.height;ctx.beginPath(),ctx.strokeStyle=Commons.appearance?.processData.historyChart.grid.zeroValue.lineColor.getHexString()??"black",ctx.lineWidth=Commons.appearance?.processData.historyChart.grid.zeroValue.lineWidth??1,ctx.moveTo(0,zeroRelativeYValue),ctx.lineTo(drawingChartSize.width,zeroRelativeYValue),ctx.stroke()}let oldYValue=null;ctx.beginPath();let point=null,preForced=null;for(const tsValue of entry.historyValue){const tsDiff=(tsNow-tsValue.ts)/1e3,xValue=Math.max(drawingChartSize.width/30*(30-tsDiff),-1),relativeYValue=(tsValue.value-limit.min)/yRange;if(null!==oldYValue&&(ctx.lineTo(xValue,oldYValue),ctx.stroke()),point={x:xValue,y:relativeYValue*drawingChartSize.height},preForced!==tsValue.forced){let color=Commons.appearance?.processData.historyChart.releasedValue.color.getHexString(),lineWidth=Commons.appearance?.processData.historyChart.releasedValue.width;tsValue.forced&&(color=Commons.appearance?.processData.historyChart.forcedValue.color.getHexString(),lineWidth=Commons.appearance?.processData.historyChart.forcedValue.width,ctx.stroke(),ctx.beginPath(),ctx.strokeStyle=color??"black",ctx.lineWidth=lineWidth??1),null!==oldYValue&&ctx.moveTo(xValue,oldYValue),ctx.lineTo(xValue,point.y),tsValue.forced||(ctx.stroke(),ctx.beginPath()),null!==point&&ctx.moveTo(point.x,point.y),ctx.strokeStyle=color??"black",ctx.lineWidth=lineWidth??1}else ctx.lineTo(xValue,point.y);oldYValue=relativeYValue*drawingChartSize.height,preForced=tsValue.forced}null!==oldYValue&&ctx.lineTo(drawingChartSize.width,oldYValue),ctx.stroke(),ctx.restore()}__removeProcessDataHistoryChart(wrapper){wrapper.innerHTML=""}}Commons.ProcessDataView=ProcessDataView,customElements.define(Commons.customElementsPrefix+"process-data-view",ProcessDataView)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class SlaveListView extends HTMLElement{constructor(master,localization){super(),this.__forcedStateWrappers=new Map,this.__forceStateInfo=document.createElement("div"),this.__releaseAllProcessDataBtn=document.createElement("button"),this.__listViewWrapper=document.createElement("div"),this.updateForcedStates=data=>{const el=this.__forcedStateWrappers.get("master");el&&(el.innerHTML=this.__master.hasForcedProcessData?'<span class="forced-process-data-value-flag">F</span>':"");let slaveCounterWithForcedProcessData=0;for(const[addr,slave]of this.__master.slaves){const el=this.__forcedStateWrappers.get(addr);slave.hasForcedProcessData?(slaveCounterWithForcedProcessData++,el&&(el.innerHTML='<span class="forced-process-data-value-flag">F</span>')):el&&(el.innerHTML="")}this.__master.hasForcedProcessData?(this.__localization.addElement(this.__forceStateInfo,"Msg_Process_Data_Forced_At_N_Slaves",[slaveCounterWithForcedProcessData]),this.__releaseAllProcessDataBtn.removeAttribute("disabled")):(this.__localization.addElement(this.__forceStateInfo,"Msg_Process_Data_Nothing_Forced",[slaveCounterWithForcedProcessData]),this.__releaseAllProcessDataBtn.setAttribute("disabled","true"))},this.__master=master,this.__localization=localization,master&&localization?this.__preInit():TcHmi.Log.warnEx("The constructor is probably called by document.createElement() or the html tag and therefore no parameters were passed.")}connectedCallback(){this.__master.forcedProcessDataCbs.add(this.updateForcedStates),this.__init()}disconnectedCallback(){this.__master.forcedProcessDataCbs.delete(this.updateForcedStates),this.__localization.cleanUp()}__preInit(){this.__listViewWrapper.classList.add("list-view-wrapper"),this.__releaseAllProcessDataBtn.classList.add("regular-button"),this.__localization.addElement(this.__releaseAllProcessDataBtn,"Slave_Processdata_Release_All"),this.append(this.__releaseAllProcessDataBtn,this.__forceStateInfo,this.__listViewWrapper)}__init(){this.__releaseAllProcessDataBtn.addEventListener("click",(()=>{this.__master.target.main.comObj?.writeSymbol(`${Commons.extensionName}.ReleaseProcessDataValues`,this.__master.main.config.device,(()=>{}))})),this.__addSlaveList()}__addSlaveList(){this.__listViewWrapper.textContent="",this.__forcedStateWrappers=new Map;const cellSlaveForcedStateHeader=document.createElement("div");cellSlaveForcedStateHeader.classList.add("entry-cell","first","forced-process-data-value-flag-placeholder");const cellSlaveNameHeader=document.createElement("div");this.__localization.addElement(cellSlaveNameHeader,"Name"),cellSlaveNameHeader.classList.add("entry-cell","bold");const cellSlaveTypeHeader=document.createElement("div");this.__localization.addElement(cellSlaveTypeHeader,"Type"),cellSlaveTypeHeader.classList.add("entry-cell","bold");const cellSlavePhyAddrHeader=document.createElement("div");this.__localization.addElement(cellSlavePhyAddrHeader,"Slave_View_EtherCAT_General_EtherCAT_Addr"),cellSlavePhyAddrHeader.classList.add("entry-cell","bold"),this.__listViewWrapper.append(cellSlaveForcedStateHeader,cellSlaveNameHeader,cellSlaveTypeHeader,cellSlavePhyAddrHeader);const masterTopologySlaves=this.__master.topology?.componentOrder;if(masterTopologySlaves)for(const component of masterTopologySlaves)this.__insertComponentEntry(component);const hcTopologies=this.__master.network.getHotConnectTopologies();if(hcTopologies.length>0){const cellNotConnectHCGroupHeader=document.createElement("div");this.__localization.addElement(cellNotConnectHCGroupHeader,"Not_Connected_Hot_Connect_Groups"),cellNotConnectHCGroupHeader.classList.add("entry-cell","grid-full-row","bold"),this.__listViewWrapper.append(cellNotConnectHCGroupHeader);for(const topology of hcTopologies){topology.calcNetwork();for(const component of topology.componentOrder)this.__insertComponentEntry(component)}}const disabledTopologies=this.__master.network.getDisabledSlaves();if(disabledTopologies.length>0){const cellDisabledSlavesHeader=document.createElement("div");this.__localization.addElement(cellDisabledSlavesHeader,"Disabled_Slaves"),cellDisabledSlavesHeader.classList.add("entry-cell","grid-full-row","bold"),this.__listViewWrapper.append(cellDisabledSlavesHeader);for(const topology of disabledTopologies){topology.calcNetwork();for(const component of topology.componentOrder)this.__insertComponentEntry(component)}}this.updateForcedStates([])}__insertComponentEntry(component){const cellForcedState=document.createElement("div");if(cellForcedState.classList.add("entry-cell","first"),this.__listViewWrapper.append(cellForcedState),component instanceof Commons.Master){this.__forcedStateWrappers.set("master",cellForcedState);const cellMasterName=document.createElement("div");cellMasterName.classList.add("entry-cell","grid-second-col-till-end","bold"),cellMasterName.textContent=component.name,this.__listViewWrapper.append(cellMasterName)}else if(component instanceof Commons.Slave){this.__forcedStateWrappers.set(component.addr,cellForcedState);const cellSlaveName=document.createElement("div");cellSlaveName.textContent=component.identity.name.value,cellSlaveName.classList.add("entry-cell","navigation-link"),cellSlaveName.addEventListener("click",(()=>{this.__master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(component))}));const cellSlaveType=document.createElement("div");cellSlaveType.textContent=component.identity.type.value??"",cellSlaveType.classList.add("entry-cell");const cellSlavePhysAddr=document.createElement("div");cellSlavePhysAddr.textContent=component.identity.addrs.phys.toString(),cellSlavePhysAddr.classList.add("entry-cell"),this.__listViewWrapper.append(cellSlaveName,cellSlaveType,cellSlavePhysAddr)}}}Commons.SlaveListView=SlaveListView,customElements.define(Commons.customElementsPrefix+"slave-list-view",SlaveListView)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class OptionalBoolInput extends HTMLElement{constructor(){super(),this.__state=null,this.__stateOrder=0}get value(){return this.__state}set value(value){this.__state=null,this.__updateDom()}connectedCallback(){this.__updateDom(),this.addEventListener("click",(()=>{this.__goToNextState(),this.__updateDom()}))}mapValue(mappedValue){this.__mappedValue=mappedValue}__updateDom(){this.classList.toggle("true",!0===this.__state),this.classList.toggle("false",!1===this.__state),null===this.__state?this.textContent="":!0===this.__state?this.textContent="true":!1===this.__state&&(this.textContent="false")}__goToNextState(){switch(null===this.__state&&(this.__mappedValue&&!0===this.__mappedValue.value?this.__stateOrder=1:this.__stateOrder=0),this.__stateOrder){case 0:switch(this.__state){case null:this.__state=!0;break;case!0:this.__state=!1;break;case!1:this.__state=null;break;default:TcHmi.Log.error("Invalid state of OptionalBoolInputValue.")}break;case 1:switch(this.__state){case null:this.__state=!1;break;case!1:this.__state=!0;break;case!0:this.__state=null;break;default:TcHmi.Log.errorEx("Invalid state of OptionalBoolInputValue.")}break;default:TcHmi.Log.error("Unknown stateOrder of OptionalBoolInput.")}}}Commons.OptionalBoolInput=OptionalBoolInput,customElements.define(Commons.customElementsPrefix+"optional-bool-input",OptionalBoolInput)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){function processThemingDeepMerge(mergedObject,objectToMerge){for(const[keyOfObjectToMerge,subObjectToMerge]of Object.entries(objectToMerge)){let insertMergeValue=!0;if("object"!=typeof subObjectToMerge||subObjectToMerge instanceof Commons.ColorRGBA||(insertMergeValue=!1),keyOfObjectToMerge in mergedObject){if(insertMergeValue){TcHmi.Log.warn("Merge value already exists in merge object. Refusing to overwrite the value.");continue}processThemingDeepMerge(mergedObject[keyOfObjectToMerge],subObjectToMerge)}else{if(insertMergeValue){mergedObject[keyOfObjectToMerge]=subObjectToMerge;continue}mergedObject[keyOfObjectToMerge]={},processThemingDeepMerge(mergedObject[keyOfObjectToMerge],subObjectToMerge)}}}Commons.visualConfig={topology:{marginRows:{above:100,below:100}},statusFlag:{height:25},master:{frame:{dimension:{width:500,height:400}},interior:{width:100}},slave:{frame:{dimension:{width:100,height:400}},label:{height:60}},slaveTerminalGroup:{dimension:{width:100,height:400}},slaveCouplerGroup:{dimension:{width:100,height:400}},port:{PHY:{dimension:{width:40,height:40}}}},Commons.processTheming=function(theming){Commons.appearance=JSON.parse(JSON.stringify(Commons.visualConfig)),processThemingDeepMerge(Commons.appearance,theming)},Commons.processThemingDeepMerge=processThemingDeepMerge,Commons.appearance=null}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics_1){!function(Commons){function setOnlineData(entry,value){if(void 0===entry)return;void 0!==value&&(entry.value=value);let valueLabel=entry.value;for(const el of entry.domElements)if(el.textContent!==valueLabel&&!(valueLabel instanceof Set)){null===valueLabel?void 0!==el.dataset.noPlaceholder?valueLabel="":(el.classList.add("no-value"),valueLabel="-"):el.classList.remove("no-value");const valueString=valueLabel.toString();if(el.textContent!==valueString){if("-"!==el.textContent&&""!==el.textContent){const highlightDuration=2e3;el.classList.add("change-highlight"),el.dataset.highlightTimeout&&clearTimeout(parseInt(el.dataset.highlightTimeout,10)),el.dataset.highlightTimeout=setTimeout((()=>{el.classList.remove("change-highlight"),el.dataset.highlightTimeout=void 0}),highlightDuration).toString()}el.textContent=valueString}}}let PortOrientation,NotificationLevel,NotificationCategory,StateMachineStateType,StateMachineStateName,TopologyView,PortName,SymbolAccess;Commons.EcDiagnostics=class{constructor(elementRoot,localization,commonPath,config){this.__commonPath=null,this.__customAddTopMostLayerFunction=null,this.__customRemoveTopMostLayerFunction=null,this.__targets=new Map,this.__selectedDevice=null,this.__view={name:TopologyView.None},this.__comObj=null,this.__configDevicesSubscription=null,this.__currentUserSubscription=null,this.__targetSubscription=null,this.__initialized=!1,this.__symbolAccess=new Map,this.__symbolAccessSubscription=null,this.__templates=new Map,elementRoot.classList.add("beckhoff-ec-diagnostics"),this.__elementRoot=elementRoot,this.__localization=localization,this.__localConfig=config,this.__contentWrapper=this.__elementRoot,this.__notification=new Commons.Notifications(this.__elementRoot),this.__commonPath=commonPath}getLocalization(){return this.__localization}setCustomTopMostLayerFunction(addFn,removeFn){this.__customAddTopMostLayerFunction=addFn,this.__customRemoveTopMostLayerFunction=removeFn}setThemedResource(){}clearAllNotifications(){this.__notification.clearAllNotifications()}get notification(){return this.__notification}clearNotification(category,level){this.__notification.clearNotifications(category,level)}setNotification(text,level,category,displayTime){this.__notification.setNotification(text,level,category,displayTime)}createNotification(key,params){this.__notification.create(key,this.__localization,params)}getSelectedDevice(){return this.__selectedDevice}get config(){return this.__localConfig}getElementRoot(){return this.__elementRoot}set comObj(comObj){this.__comObj=comObj}get comObj(){return this.__comObj}displayView(){}get view(){return this.__view}updateConfigDevice(device,executeInitOnSuccess){this.__localConfig.device=device,this.__initialized&&this.preInit(executeInitOnSuccess)}updateConfigAllowZoomAndPan(allowZoomAndPan,executeInitOnSuccess){this.__localConfig.allowZoomAndPan=allowZoomAndPan,this.__initialized&&this.preInit(executeInitOnSuccess)}updateConfigToolboxResetView(toolboxResetView,executeInitOnSuccess){this.__localConfig.toolboxResetView=toolboxResetView,this.__initialized&&this.preInit(executeInitOnSuccess)}updateConfigInitTopology(initTopology,executeInitOnSuccess){this.__localConfig.initTopologyViewPosX=initTopology.pos.x,this.__localConfig.initTopologyViewPosY=initTopology.pos.y,this.__localConfig.initTopologyViewZoom=initTopology.zoom,this.__initialized&&this.preInit(executeInitOnSuccess)}preInit(executeInitOnSuccess=!1){if(this.cleanUp(),this.__comObj){if(this.__initialized=!0,executeInitOnSuccess)if(this.__localConfig.device)if(executeInitOnSuccess)this.__notification.clearNotifications(NotificationCategory.task),this.__configDevicesSubscription=this.__comObj.subscribe({symbol:`${Commons.extensionName}.ListConfiguredDevices`},1e3,(devices=>{if(this.__localConfig.device)if(this.__comObj){if(devices&&this.__localConfig.device in devices)this.__notification.clearNotifications(NotificationCategory.task),this.__configDevicesSubscription&&this.__comObj.unsubscribe(this.__configDevicesSubscription);else{const notificationEl=document.createElement("div");notificationEl.classList.add("flex-col");const msgElDeviceNotConfigured=document.createElement("span");if(this.__localization.addElement(msgElDeviceNotConfigured,"Msg_Device_Not_Configured",[this.__localConfig.device]),notificationEl.append(msgElDeviceNotConfigured),devices&&Object.keys(devices).length>0){const msgElDeviceList=document.createElement("div"),deviceList=document.createElement("ul");for(const[deviceName,deviceConfig]of Object.entries(devices)){const device=this.__localization.createLocalizedElement(`${deviceName} ({{Enabled}}: ${deviceConfig.enabled}, {{Target}}: ${deviceConfig.targetNetId}, {{Master}}: ${deviceConfig.masterNetId})`,"li");deviceList.append(device)}this.__localization.addElement(msgElDeviceList,"Msg_Device_List",[deviceList]),notificationEl.append(msgElDeviceList)}else{const msgElNoDeviceConfigured=document.createElement("div");this.__localization.addElement(msgElNoDeviceConfigured,"Msg_No_Device_Configured"),notificationEl.append(msgElNoDeviceConfigured)}this.__notification.setNotification(notificationEl,executeInitOnSuccess?NotificationLevel.error:NotificationLevel.info,NotificationCategory.task)}this.__checkSymbolAccess(this.init.bind(this))}else TcHmi.Log.error("Please initialize WebSocket Object first.");else TcHmi.Log.error("Device attribute is not defined.")}));else{const notification=this.__localization.createLocalizedElement(`{{Device}}: ${this.__localConfig.device}`);this.__notification.setNotification(notification,NotificationLevel.info,NotificationCategory.task)}else this.__configDevicesSubscription=this.__comObj.subscribe({symbol:`${Commons.extensionName}.ListConfiguredDevices`},1e3,(devices=>{const notificationEl=document.createElement("div");notificationEl.classList.add("flex-col");const msgElDeviceAttributeNotSet=document.createElement("span");if(this.__localization.addElement(msgElDeviceAttributeNotSet,"Msg_Device_Attribute_Is_Not_Set"),notificationEl.append(msgElDeviceAttributeNotSet),devices&&Object.keys(devices).length>0){const msgElDeviceList=document.createElement("div"),deviceList=document.createElement("ul");for(const[deviceName,deviceConfig]of Object.entries(devices)){const device=document.createElement("li");device.textContent=`${deviceName} (Enabled: ${deviceConfig.enabled}, Target: ${deviceConfig.targetNetId}, Master: ${deviceConfig.masterNetId})`,deviceList.append(device)}this.__localization.addElement(msgElDeviceList,"Msg_Device_List",[deviceList]),notificationEl.append(msgElDeviceList)}else{const msgElNoDeviceConfigured=document.createElement("div");this.__localization.addElement(msgElNoDeviceConfigured,"Msg_No_Device_Configured"),notificationEl.append(msgElNoDeviceConfigured)}this.__notification.setNotification(notificationEl,executeInitOnSuccess?NotificationLevel.error:NotificationLevel.info,NotificationCategory.task)}))}else TcHmi.Log.error("Please initialize WebSocket Object first.")}init(){this.__comObj?(this.cleanUp(!0),this.__targetSubscription=this.__comObj.subscribe({symbol:`${Commons.extensionName}.GetTarget`,writeValue:this.__localConfig.device},1e3,this.__updateTarget.bind(this),(data=>{TcHmi.Log.info(`${Commons.extensionName}.GetTarget was subscribed successfully.`)}))):TcHmi.Log.error("Please initialize WebSocket Object first.")}getSymbolAccess(symbol){return this.__symbolAccess.get(symbol)??!1}__checkSymbolAccess(callback){if(!this.__comObj)return void TcHmi.Log.error("Please initialize WebSocket Object first.");const symbols=[`${Commons.extensionName}.ListConfiguredDevices`,`${Commons.extensionName}.Config`,`${Commons.extensionName}.GetTarget`,`${Commons.extensionName}.GetMaster`,`${Commons.extensionName}.GetSlaves`,`${Commons.extensionName}.GetMasterOnlineInfo`,`${Commons.extensionName}.GetSlavesOnlineInfo`,`${Commons.extensionName}.GetSlavesScanned`,`${Commons.extensionName}.SendSlavesScanCmd`,`${Commons.extensionName}.SetProcessDataValues`,`${Commons.extensionName}.ForceProcessDataValues`,`${Commons.extensionName}.ReleaseProcessDataValues`],cmds=[];for(const symbol of symbols)cmds.push({symbol:"GetSymbolAccess",writeValue:symbol});this.__comObj.subscribe(cmds,1e3,((values,firstTick)=>{for(const value of values)"GetSymbolAccess"===value.symbol&&this.__symbolAccess.set(value.writeValue,value.readValue===SymbolAccess.ReadWrite);callback();const notificationEl=document.createElement("span"),localization=this.getLocalization();firstTick||(this.notification.clearAllNotifications(),localization.addElement(notificationEl,"Msg_Change_Of_User_Rights"),this.notification.setNotification(notificationEl,NotificationLevel.success,NotificationCategory.ws,3e3))}))}destroy(){this.__localization.destroy(),this.cleanUp()}cleanUp(cleanOnlyFromInit=!1){if(this.__comObj){cleanOnlyFromInit||(this.__configDevicesSubscription&&this.__comObj.unsubscribe(this.__configDevicesSubscription),null!==!this.__currentUserSubscription&&(this.__comObj.unsubscribe(this.__currentUserSubscription),this.__currentUserSubscription=null)),null!==this.__targetSubscription&&(this.__comObj.unsubscribe(this.__targetSubscription),this.__targetSubscription=null),this.__comObj.unsubscribe(this.__symbolAccessSubscription);for(const target of this.__targets.values())target.destroy();this.__targets.clear()}else TcHmi.Log.error("Please initialize WebSocket Object first.")}__updateTarget(target){if(target){const selectedDeviceChanged=this.__selectedDevice?.targetNetId!==target.netId||this.__selectedDevice?.masterNetId!==target.config.masterNetId;selectedDeviceChanged&&(this.__selectedDevice={targetNetId:target.netId,masterNetId:target.config.masterNetId}),this.__addOrUpdateTarget(target.netId,target.name,target.available,target.sysServiceAdsState,selectedDeviceChanged)}else{if(!this.__selectedDevice)return;const targetToRemove=this.__targets.get(this.__selectedDevice.targetNetId);targetToRemove&&(targetToRemove.destroy(),this.__targets.delete(this.__selectedDevice.targetNetId))}}setViewMaster(master){this.__view.master=master}updateView(target,master){if(this.__view.name===TopologyView.None&&this.__view.target===target)if(this.__selectedDevice?.masterNetId){if(!master)return;master.netId===this.__selectedDevice.masterNetId&&(master.displayView(),this.__view.master=master)}else target.displayView()}reload(){this.__view.master?.reload()}resetView(){this.__view.master?.resetView()}setView(view,target,masterNetId){switch(view){case TopologyView.None:case TopologyView.Target:break;case TopologyView.Master:if(!target)return;target.setView(TopologyView.Master);break;case TopologyView.Network:if(!target)return;target.setView(TopologyView.Network,masterNetId);break;default:TcHmi.Log.error(`Invalid view '${view}' for EcDiagnostics.`)}}__clearTargets(){for(const target of this.__targets.values())target.destroy()}__addOrUpdateTarget(targetNetId,targetName,available,sysServiceAdsState,selectedDeviceChanged){const existingTarget=this.__targets.get(targetNetId);if(existingTarget)existingTarget.update(targetName,available,sysServiceAdsState,selectedDeviceChanged);else{const newTarget=new Commons.Target(this,targetNetId,targetName,available,sysServiceAdsState);this.__targets.set(targetNetId,newTarget),this.__view.target=newTarget}}loadTemplates(){return fetch(`${this.__commonPath}/Templates/PopUp.html`).then((response=>response.ok?response.text():Promise.reject())).then((data=>{const tempDiv=document.createElement("div");tempDiv.innerHTML=data,this.__localization.addAllLocalizedElements(tempDiv);const templateElements=tempDiv.querySelectorAll("[template]");for(const templateElement of templateElements){const templateName=templateElement.getAttribute("template");templateName?(this.__templates.set(templateName,templateElement),templateElement.remove()):TcHmi.Log.warn("Template has no name.")}}))}getTemplate(name){const template=this.__templates.get(name);return template?template.cloneNode(!0):null}get contentWrapper(){return this.__contentWrapper}addTopMostLayer(element){if(this.__customAddTopMostLayerFunction){this.__customAddTopMostLayerFunction(element);const parent=element.parentElement;parent&&parent.classList.add("beckhoff-ec-diagnostics"),element.addFnToCallOnRemove((()=>{this.__customRemoveTopMostLayerFunction&&this.__customRemoveTopMostLayerFunction(element)}))}else{let topMostLayerWrapper=document.querySelector("beckhoff-ec-diagnostics-topmostlayer-wrapper");topMostLayerWrapper||(topMostLayerWrapper=document.createElement("beckhoff-ec-diagnostics-topmostlayer-wrapper"),topMostLayerWrapper.classList.add("beckhoff-ec-diagnostics"),document.body.append(topMostLayerWrapper)),topMostLayerWrapper.append(element)}}addPopUp(popup){this.addTopMostLayer(popup)}},Commons.domElementsCache=new Map,Commons.removeGarbageElements=function(ctx){const elementsOfContext=Commons.domElementsCache.get(ctx);if(elementsOfContext){for(const[entry,cacheElements]of elementsOfContext){for(const cacheElement of cacheElements)cacheElement.isConnected||(entry.domElements.delete(cacheElement),cacheElements.delete(cacheElement));0===cacheElements.size&&elementsOfContext.delete(entry)}0===elementsOfContext.size&&Commons.domElementsCache.delete(ctx)}},Commons.addDomElement=function(ctx,entry,valueEl,errorEl){if(!entry)return void TcHmi.Log.warn("You have tried to add an online element to an entry, that do not exist.");if(!valueEl&&!errorEl)return void TcHmi.Log.warn("You have tried to add an element, that do not exist.");let elementsOfContext=Commons.domElementsCache.get(ctx);elementsOfContext||(elementsOfContext=new Map,Commons.domElementsCache.set(ctx,elementsOfContext));let domElementsOfEntry=elementsOfContext.get(entry);domElementsOfEntry||(domElementsOfEntry=new Set,elementsOfContext.set(entry,domElementsOfEntry)),valueEl&&(entry.domElements.add(valueEl),domElementsOfEntry.add(valueEl)),errorEl&&(entry.errorElements?.add(errorEl),domElementsOfEntry.add(errorEl)),setOnlineData(entry)},Commons.setOnlineData=setOnlineData,function(PortOrientation){PortOrientation[PortOrientation.nirvana=0]="nirvana",PortOrientation[PortOrientation.left=1]="left",PortOrientation[PortOrientation.right=2]="right",PortOrientation[PortOrientation.up=3]="up",PortOrientation[PortOrientation.down=4]="down"}(PortOrientation=Commons.PortOrientation||(Commons.PortOrientation={})),function(NotificationLevel){NotificationLevel[NotificationLevel.info=0]="info",NotificationLevel[NotificationLevel.success=1]="success",NotificationLevel[NotificationLevel.warning=2]="warning",NotificationLevel[NotificationLevel.error=3]="error"}(NotificationLevel=Commons.NotificationLevel||(Commons.NotificationLevel={})),function(NotificationCategory){NotificationCategory[NotificationCategory.task=0]="task",NotificationCategory[NotificationCategory.ws=1]="ws"}(NotificationCategory=Commons.NotificationCategory||(Commons.NotificationCategory={})),function(StateMachineStateType){StateMachineStateType[StateMachineStateType.init=1]="init",StateMachineStateType[StateMachineStateType.preOp=2]="preOp",StateMachineStateType[StateMachineStateType.boot=3]="boot",StateMachineStateType[StateMachineStateType.safeOp=4]="safeOp",StateMachineStateType[StateMachineStateType.operational=8]="operational"}(StateMachineStateType=Commons.StateMachineStateType||(Commons.StateMachineStateType={})),function(StateMachineStateName){StateMachineStateName[StateMachineStateName.Init=1]="Init",StateMachineStateName[StateMachineStateName.PreOp=2]="PreOp",StateMachineStateName[StateMachineStateName.Boot=3]="Boot",StateMachineStateName[StateMachineStateName.SafeOp=4]="SafeOp",StateMachineStateName[StateMachineStateName.Operational=8]="Operational",StateMachineStateName[StateMachineStateName.Invalid=9]="Invalid"}(StateMachineStateName=Commons.StateMachineStateName||(Commons.StateMachineStateName={})),Commons.StateMachineStateNameReverse={Init:1,PreOp:2,Boot:3,SafeOp:4,Operational:8,Invalid:9},Commons.SlaveMachineStates_Color=new Map([[StateMachineStateName.Init,"#c33e37"],[StateMachineStateName.PreOp,"#FFCE00"],[StateMachineStateName.Boot,"blue"],[StateMachineStateName.SafeOp,"#ffce00"],[StateMachineStateName.Operational,"#19BB16"],[StateMachineStateName.Invalid,"transparent"]]),function(TopologyView){TopologyView[TopologyView.None=-1]="None",TopologyView[TopologyView.Target=0]="Target",TopologyView[TopologyView.Master=1]="Master",TopologyView[TopologyView.Network=2]="Network",TopologyView[TopologyView.Trace=3]="Trace",TopologyView[TopologyView.Slave=4]="Slave"}(TopologyView=Commons.TopologyView||(Commons.TopologyView={})),function(PortName){PortName[PortName.A=0]="A",PortName[PortName.D=1]="D",PortName[PortName.B=2]="B",PortName[PortName.C=3]="C"}(PortName=Commons.PortName||(Commons.PortName={})),function(SymbolAccess){SymbolAccess[SymbolAccess.None=0]="None",SymbolAccess[SymbolAccess.Read=1]="Read",SymbolAccess[SymbolAccess.Write=2]="Write",SymbolAccess[SymbolAccess.ReadWrite=3]="ReadWrite"}(SymbolAccess=Commons.SymbolAccess||(Commons.SymbolAccess={}))}(EcDiagnostics_1.Commons||(EcDiagnostics_1.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){let ServerDef;!function(ServerDef){let ServerErrors,FrameworkErrors,ACCESS;!function(ServerErrors){ServerErrors[ServerErrors.HMI_E_SYMBOL_NOT_MAPPED=513]="HMI_E_SYMBOL_NOT_MAPPED",ServerErrors[ServerErrors.HMI_E_INVALID_DOMAIN=2050]="HMI_E_INVALID_DOMAIN",ServerErrors[ServerErrors.HMI_E_INSUFFICIENT_ACCESS=4101]="HMI_E_INSUFFICIENT_ACCESS",ServerErrors[ServerErrors.HMI_EC_DIAGNOSTICS_E_NOT_READY_YET=2097190]="HMI_EC_DIAGNOSTICS_E_NOT_READY_YET"}(ServerErrors=ServerDef.ServerErrors||(ServerDef.ServerErrors={})),function(FrameworkErrors){FrameworkErrors[FrameworkErrors.NONE=0]="NONE",FrameworkErrors[FrameworkErrors.ERROR=1]="ERROR",FrameworkErrors[FrameworkErrors.E_PARAMETER_INVALID=2]="E_PARAMETER_INVALID",FrameworkErrors[FrameworkErrors.E_TIMEOUT=3]="E_TIMEOUT",FrameworkErrors[FrameworkErrors.E_EXCEPTION=4]="E_EXCEPTION",FrameworkErrors[FrameworkErrors.E_INVALID=5]="E_INVALID",FrameworkErrors[FrameworkErrors.E_NOT_UNIQUE=6]="E_NOT_UNIQUE",FrameworkErrors[FrameworkErrors.E_NOT_SUPPORTED=100]="E_NOT_SUPPORTED",FrameworkErrors[FrameworkErrors.E_SYSTEM_NOT_READY=105]="E_SYSTEM_NOT_READY",FrameworkErrors[FrameworkErrors.E_NOT_ALLOWED=110]="E_NOT_ALLOWED",FrameworkErrors[FrameworkErrors.E_UNKNOWN=115]="E_UNKNOWN",FrameworkErrors[FrameworkErrors.E_UNKNOWN_TYPE=120]="E_UNKNOWN_TYPE",FrameworkErrors[FrameworkErrors.E_KEY_NOT_FOUND=130]="E_KEY_NOT_FOUND",FrameworkErrors[FrameworkErrors.E_TYPE_INVALID=150]="E_TYPE_INVALID",FrameworkErrors[FrameworkErrors.E_VALUE_INVALID=160]="E_VALUE_INVALID",FrameworkErrors[FrameworkErrors.E_REGISTRATION_MISSING=180]="E_REGISTRATION_MISSING",FrameworkErrors[FrameworkErrors.E_REGISTRATION_ERROR=190]="E_REGISTRATION_ERROR",FrameworkErrors[FrameworkErrors.E_MODULE_MISSING=200]="E_MODULE_MISSING",FrameworkErrors[FrameworkErrors.E_MODULE_ERROR=210]="E_MODULE_ERROR",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_NOT_READY=1e3]="E_WEBSOCKET_NOT_READY",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_CLOSED=1001]="E_WEBSOCKET_CLOSED",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_NOT_SUPPORTED=1404]="E_WEBSOCKET_NOT_SUPPORTED",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_OPEN_SERVER_LICENSE_CHECK_FAILED=1500]="E_WEBSOCKET_OPEN_SERVER_LICENSE_CHECK_FAILED",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_OPEN_SERVER_LICENSE_MISSING=1501]="E_WEBSOCKET_OPEN_SERVER_LICENSE_MISSING",FrameworkErrors[FrameworkErrors.E_WEBSOCKET_OPEN_SERVER_NO_ACCESS=1502]="E_WEBSOCKET_OPEN_SERVER_NO_ACCESS",FrameworkErrors[FrameworkErrors.E_SYMBOL_STATE_INVALID=2e3]="E_SYMBOL_STATE_INVALID",FrameworkErrors[FrameworkErrors.E_SYMBOL_VALUE_INVALID=2001]="E_SYMBOL_VALUE_INVALID",FrameworkErrors[FrameworkErrors.E_SYMBOL_RESOLVE_SCHEMA=2002]="E_SYMBOL_RESOLVE_SCHEMA",FrameworkErrors[FrameworkErrors.E_SYMBOL_READONLY=2003]="E_SYMBOL_READONLY",FrameworkErrors[FrameworkErrors.E_SYMBOL_UNKNOWN=2010]="E_SYMBOL_UNKNOWN",FrameworkErrors[FrameworkErrors.E_SYMBOL_INVALID_DATA_PROVIDER_ENTRY=2020]="E_SYMBOL_INVALID_DATA_PROVIDER_ENTRY",FrameworkErrors[FrameworkErrors.E_SYMBOL_INVALID_PATH=2030]="E_SYMBOL_INVALID_PATH",FrameworkErrors[FrameworkErrors.E_SYMBOL_SUBSYMBOL_ERROR=2040]="E_SYMBOL_SUBSYMBOL_ERROR",FrameworkErrors[FrameworkErrors.E_SYMBOL_OBJECT_RESOLVE=2050]="E_SYMBOL_OBJECT_RESOLVE",FrameworkErrors[FrameworkErrors.E_SYMBOL_UNKNOWN_ATTRIBUTE=2100]="E_SYMBOL_UNKNOWN_ATTRIBUTE",FrameworkErrors[FrameworkErrors.E_SERVER_RESPONSE_ERROR=3e3]="E_SERVER_RESPONSE_ERROR",FrameworkErrors[FrameworkErrors.E_SERVER_COMMAND_ERROR=3005]="E_SERVER_COMMAND_ERROR",FrameworkErrors[FrameworkErrors.E_SERVER_INVALID_RESPONSE=3010]="E_SERVER_INVALID_RESPONSE",FrameworkErrors[FrameworkErrors.E_SERVER_COMMANDS_MISSING=3015]="E_SERVER_COMMANDS_MISSING",FrameworkErrors[FrameworkErrors.E_SERVER_COMMAND_MISSING=3016]="E_SERVER_COMMAND_MISSING",FrameworkErrors[FrameworkErrors.E_SERVER_READVALUE_MISSING=3020]="E_SERVER_READVALUE_MISSING",FrameworkErrors[FrameworkErrors.E_SERVER_WRITEVALUE_MISSING=3025]="E_SERVER_WRITEVALUE_MISSING",FrameworkErrors[FrameworkErrors.E_SERVER_RESPONSE_MISSING=3030]="E_SERVER_RESPONSE_MISSING",FrameworkErrors[FrameworkErrors.E_SERVER_DOMAIN_UNKNOWN=3100]="E_SERVER_DOMAIN_UNKNOWN",FrameworkErrors[FrameworkErrors.E_SERVER_HANDSHAKE=3200]="E_SERVER_HANDSHAKE",FrameworkErrors[FrameworkErrors.E_FUNCTION_MISSING_FUNCTION_REFERENCE=4e3]="E_FUNCTION_MISSING_FUNCTION_REFERENCE",FrameworkErrors[FrameworkErrors.E_FUNCTION_MISSING_FUNCTION_DESCRIPTION=4005]="E_FUNCTION_MISSING_FUNCTION_DESCRIPTION",FrameworkErrors[FrameworkErrors.E_FUNCTION_INVALID_CONFIGURATION=4010]="E_FUNCTION_INVALID_CONFIGURATION",FrameworkErrors[FrameworkErrors.E_FUNCTION_EXCEPTION=4020]="E_FUNCTION_EXCEPTION",FrameworkErrors[FrameworkErrors.E_FUNCTION_UNKNOWN=4030]="E_FUNCTION_UNKNOWN",FrameworkErrors[FrameworkErrors.E_FUNCTION_RESTPARAMETER_DEFINITION_MISSING=4040]="E_FUNCTION_RESTPARAMETER_DEFINITION_MISSING",FrameworkErrors[FrameworkErrors.E_FUNCTION_RESOLVING_PARAMETER_FAILED=4050]="E_FUNCTION_RESOLVING_PARAMETER_FAILED",FrameworkErrors[FrameworkErrors.E_FUNCTION_HANDLED_VIA_RETURN_VALUE=4060]="E_FUNCTION_HANDLED_VIA_RETURN_VALUE",FrameworkErrors[FrameworkErrors.E_FUNCTION_EXPRESSION_PARSER_ERROR=4100]="E_FUNCTION_EXPRESSION_PARSER_ERROR",FrameworkErrors[FrameworkErrors.E_FUNCTION_EXPRESSION_EXCEPTION=4120]="E_FUNCTION_EXPRESSION_EXCEPTION",FrameworkErrors[FrameworkErrors.E_FUNCTION_CALL_ABORTED=4130]="E_FUNCTION_CALL_ABORTED",FrameworkErrors[FrameworkErrors.E_FUNCTION_DESTROYED=4140]="E_FUNCTION_DESTROYED",FrameworkErrors[FrameworkErrors.E_TRIGGER_ACTION_EXCEPTION=5050]="E_TRIGGER_ACTION_EXCEPTION",FrameworkErrors[FrameworkErrors.E_TRIGGER_JAVASCRIPT_EVAL_EXCEPTION=5055]="E_TRIGGER_JAVASCRIPT_EVAL_EXCEPTION",FrameworkErrors[FrameworkErrors.E_TRIGGER_FUNCTION_EXPRESSION_EXCEPTION=5060]="E_TRIGGER_FUNCTION_EXPRESSION_EXCEPTION",FrameworkErrors[FrameworkErrors.E_TRIGGER_RESOLVE_CONDITION_EXPRESSION_EXCEPTION=5065]="E_TRIGGER_RESOLVE_CONDITION_EXPRESSION_EXCEPTION",FrameworkErrors[FrameworkErrors.E_TRIGGER_CONDITION_INVALID=5200]="E_TRIGGER_CONDITION_INVALID",FrameworkErrors[FrameworkErrors.E_CONTROL_INSTANCE_NOT_FOUND=6e3]="E_CONTROL_INSTANCE_NOT_FOUND",FrameworkErrors[FrameworkErrors.E_CONTROL_INVALID_CONFIGURATION=6001]="E_CONTROL_INVALID_CONFIGURATION",FrameworkErrors[FrameworkErrors.E_CONTROL_ATTRIBUTE_NOT_FOUND=6005]="E_CONTROL_ATTRIBUTE_NOT_FOUND",FrameworkErrors[FrameworkErrors.E_CONTROL_ATTRIBUTE_INVALID_CONFIGURATION=6010]="E_CONTROL_ATTRIBUTE_INVALID_CONFIGURATION",FrameworkErrors[FrameworkErrors.E_CONTROL_INSTANCE_NO_LONGER_AVAILABLE=6020]="E_CONTROL_INSTANCE_NO_LONGER_AVAILABLE",FrameworkErrors[FrameworkErrors.E_SCHEMA_INVALID=7e3]="E_SCHEMA_INVALID",FrameworkErrors[FrameworkErrors.E_SCHEMA_INVALID_PATH=7010]="E_SCHEMA_INVALID_PATH",FrameworkErrors[FrameworkErrors.E_SCHEMA_INVALID_REF_ID=7020]="E_SCHEMA_INVALID_REF_ID",FrameworkErrors[FrameworkErrors.E_SCHEMA_UNKNOWN_FILE=7030]="E_SCHEMA_UNKNOWN_FILE",FrameworkErrors[FrameworkErrors.E_SCHEMA_UNKNOWN_SOURCE=7030]="E_SCHEMA_UNKNOWN_SOURCE",FrameworkErrors[FrameworkErrors.E_SCHEMA_UNKNOWN_DEFINITION=7040]="E_SCHEMA_UNKNOWN_DEFINITION",FrameworkErrors[FrameworkErrors.E_SCHEMA_NOT_RESOLVED=7050]="E_SCHEMA_NOT_RESOLVED",FrameworkErrors[FrameworkErrors.E_PACKAGE=8e3]="E_PACKAGE",FrameworkErrors[FrameworkErrors.E_LOCALIZATION_UNKNOWN_KEY=9e3]="E_LOCALIZATION_UNKNOWN_KEY"}(FrameworkErrors=ServerDef.FrameworkErrors||(ServerDef.FrameworkErrors={})),function(ACCESS){ACCESS[ACCESS.NONE=0]="NONE",ACCESS[ACCESS.READ=1]="READ",ACCESS[ACCESS.WRITE=2]="WRITE",ACCESS[ACCESS.READWRITE=3]="READWRITE"}(ACCESS=ServerDef.ACCESS||(ServerDef.ACCESS={}))}(ServerDef=Commons.ServerDef||(Commons.ServerDef={}));Commons.Communication=class{constructor(ecDiagnostics){this.__ecDiagnostics=ecDiagnostics}__evaluateCommandError(command,cbErrorEl){const error=command.error,notification_error_key=command.symbol+"-message";if(!error)return this.__ecDiagnostics.notification.clearNotifications(notification_error_key),!1;TcHmi.Log.error(`The symbol '${command.symbol}' reports an error Code: ${error.code}, Message: ${error.message}, Reason: ${error.reason}`);let notificationLevel=Commons.NotificationLevel.error;const localization=this.__ecDiagnostics.getLocalization(),notification=cbErrorEl??document.createElement("span");if(!cbErrorEl){notification.classList.add("flex-col");const notificationServerReportsError=document.createElement("div");localization.addElement(notificationServerReportsError,"Server_Reports_Error"),notification.append(notificationServerReportsError)}const notificationError=document.createElement("div");switch(error.code){case ServerDef.ServerErrors.HMI_E_INVALID_DOMAIN:localization.addElement(notificationError,"Msg_Extension_Not_Loaded",[Commons.extensionName]);break;case ServerDef.ServerErrors.HMI_E_SYMBOL_NOT_MAPPED:localization.addElement(notificationError,"Msg_Symbol_Not_Mapped",[command.symbol]),notification.append(notificationError);break;case ServerDef.ServerErrors.HMI_E_INSUFFICIENT_ACCESS:localization.addElement(notificationError,"Msg_Unable_To_Access_Topology",[command.symbol]),notification.append(notificationError);break;default:if(error.code===ServerDef.ServerErrors.HMI_EC_DIAGNOSTICS_E_NOT_READY_YET&&(notificationLevel=Commons.NotificationLevel.warning),"Unsubscribe"===command.symbol)return;if(error.reason){const notificationErrorReason=document.createElement("div");localization.addElement(notificationErrorReason,"Server_Error_Reason",[error.reason]),notificationError.append(notificationErrorReason)}if(error.message){const notificationErrorMessage=document.createElement("div");localization.addElement(notificationErrorMessage,"Server_Error_Message",[error.message]),notificationError.append(notificationErrorMessage)}if(error.code){const notificationErrorCode=document.createElement("div");localization.addElement(notificationErrorCode,"Server_Error_Code",[error.code,error.code.toString(16)]),notificationError.append(notificationErrorCode)}}return notification.append(notificationError),cbErrorEl?cbErrorEl.classList.remove("hide"):this.__ecDiagnostics.notification.setNotification(notification,notificationLevel,notification_error_key),!0}processReadValues(subscriptionCallback,response){if(subscriptionCallback.errorEl&&(subscriptionCallback.errorEl.textContent="",subscriptionCallback.errorEl.classList.add("hide")),response.error)return void TcHmi.Log.errorEx(`Server responded with error ${response.error.code.toString()}. Errordetail:`,response.error);const resultCommands=response.commands;if(!resultCommands||0===resultCommands.length)return void TcHmi.Log.error("Server did not respond with any commands.");let values=subscriptionCallback.cmdGroup?[]:null;for(const command of resultCommands){if(this.__evaluateCommandError(command)){if(subscriptionCallback.cmdGroup)continue;return}subscriptionCallback.cmdGroup?values.push({symbol:command.symbol,writeValue:command.writeValue,readValue:command.readValue}):values=command.readValue}!subscriptionCallback.initialized&&subscriptionCallback.initCallback&&subscriptionCallback.initCallback(values),subscriptionCallback.tickCallback(values,!subscriptionCallback.initialized),subscriptionCallback.initialized=!0}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Localization=class{constructor(lang){this.__lang="en",this.__localizedTexts=null,this.__elements=new Map,lang&&(this.__lang=lang)}destroy(){this.cleanUp()}cleanUp(){Commons.Utility.removeNotConnectedDomElements(this.__elements)}createLocalizedElement(content,elType="div"){const element=document.createElement(elType);let localizationMatch,lastStringIndex=0;const regExLocalized=/{{(?<key>[a-zA-Z0-9\_\-]*)(?:\$(?<placeholders>[a-zA-Z0-9\s\_\-\$\(\)]*))*(?:\.(?<classes>[a-zA-Z0-9\-\_]*))*(?:\$([a-zA-Z0-9\s\_\-\$\(\)]*))*}}/g;for(;null!==(localizationMatch=regExLocalized.exec(content));){const preStringWrapper=document.createElement("span");preStringWrapper.innerHTML=content.substring(lastStringIndex,localizationMatch.index),element.append(preStringWrapper);const localizationWrapper=document.createElement("span"),localizationKey=localizationMatch.groups?.key;if(!localizationKey){TcHmi.Log.warn(`Invalid localization key ${localizationMatch[0]}`);break}const localizationPlaceholders=localizationMatch.groups?.placeholders?.split("$"),localizationClasses=localizationMatch.groups?.classes?.split(".");if(localizationClasses)for(const className of localizationClasses)localizationWrapper.classList.add(className);this.addElement(localizationWrapper,localizationKey.trim(),localizationPlaceholders),element.append(localizationWrapper),lastStringIndex=localizationMatch.index+localizationMatch[0].length}const postStringWrapper=document.createElement("span");return postStringWrapper.innerHTML=content.substring(lastStringIndex,content.length),element.append(postStringWrapper),element}addElement(el,contentKey,placeholders){const elementData={contentKey:contentKey,placeholders:placeholders};this.cleanUp(),this.__elements.set(el,elementData),this.__insertLocalizedText(el,contentKey,placeholders)}__insertLocalizedText(el,contentKey,placeholders){el.innerHTML="";let localizedText=this.getLocalizedText(contentKey);const placeholderRegEx=new RegExp("{[^}]*}","g");let placeholderMatch,lastIndex=0;if(localizedText.includes("{")){for(;null!==(placeholderMatch=placeholderRegEx.exec(localizedText));){const placeholderKey=placeholderMatch[0].replace("{","").replace("}","").trim();if(!placeholders||void 0===placeholders[placeholderKey]){TcHmi.Log.warn(`No placeholder value for placeholder key '${placeholderKey}' found.`);continue}const placeholderValue=placeholders[placeholderKey];if("number"==typeof placeholderValue||"string"==typeof placeholderValue){localizedText=localizedText.replace(`{${placeholderKey}}`,placeholderValue.toString());continue}const firstStringWrapper=document.createElement("span");firstStringWrapper.innerHTML=localizedText.substring(lastIndex,placeholderMatch.index),el.append(firstStringWrapper),lastIndex=placeholderRegEx.lastIndex,el.append(placeholderValue)}const lastStringWrapper=document.createElement("span");lastStringWrapper.innerHTML=localizedText.substring(lastIndex),el.append(lastStringWrapper)}else el.innerHTML!==localizedText&&(el.innerHTML=localizedText)}updateAllElements(){this.cleanUp();for(const[el,elData]of this.__elements)this.__insertLocalizedText(el,elData.contentKey,elData.placeholders)}addAllLocalizedElements(parent){const localizedElements=parent.querySelectorAll("[data-localized-content-key]");for(const el of localizedElements){const contentKey=el.dataset.localizedContentKey;void 0!==contentKey&&this.addElement(el,contentKey)}}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Target=class{constructor(main,netId,name,available,sysServiceAdsState){this.__subscriptions=new Map,this.__subscriptionInitialized=!1,this.__masters=new Map,this.__main=main,this.__netId=netId,this.__name=name,this.__available=available,this.__sysServiceAdsState=sysServiceAdsState,this.__init()}__init(){this.__available?(this.__main.createNotification("target-available-now",{target:{netId:this.__netId,name:this.__name}}),this.__getMaster(),this.updateView()):this.__main.createNotification("target-not-available",{target:{netId:this.__netId,name:this.__name}})}getNetIdAndName(){return{netId:this.netId,name:this.name}}update(name,available,sysServiceAdsState,selectedDeviceChanged){let significantChange=selectedDeviceChanged;this.__sysServiceAdsState!==sysServiceAdsState&&(this.__sysServiceAdsState=sysServiceAdsState,significantChange=!0),this.__sysServiceAdsState=sysServiceAdsState,this.__name!==name&&(this.__name=name,significantChange=!0),this.__available!==available&&(this.__available=available,this.__available?(this.__main.createNotification("target-available-now",{target:{netId:this.__netId,name:this.__name}}),this.__getMaster()):(this.__main.createNotification("target-no-longer-available",{target:{netId:this.__netId,name:this.__name}}),this.__clearMasters())),significantChange&&this.__updateView("master")}updateView(master){this.__main.updateView(this,master)}displayView(){}__getMaster(){const comObj=this.__main.comObj;if(!comObj)return;this.__clearMasters();const subscriptionId=comObj.subscribe({symbol:`${Commons.extensionName}.GetMaster`,writeValue:this.__main.config.device},1e3,this.__updateMaster.bind(this),(data=>{TcHmi.Log.info(`${Commons.extensionName}.GetMaster was subscribed successfully.`)}));subscriptionId&&this.__subscriptions.set(`${Commons.extensionName}.GetMaster`,subscriptionId)}__clearMasters(){const comObj=this.__main.comObj;comObj&&(comObj.unsubscribe(this.__subscriptions.get(`${Commons.extensionName}.GetMaster`),(()=>{this.__subscriptionInitialized=!1,this.__subscriptions.delete(`${Commons.extensionName}.GetMaster`),TcHmi.Log.info('Subscription "GetMasters" successfully unsubscribed.')})),this.__deleteAllMasters())}get sysServiceAdsState(){return this.__sysServiceAdsState}get comObj(){return this.main.comObj}get main(){return this.__main}get netId(){return this.__netId}get name(){return null===this.__name?"":this.__name}countMasters(){return this.__masters.size}__addMaster(masterNetId,masterName){this.__masters.set(masterNetId,new Commons.Master(this,masterNetId,masterName))}__deleteAllMasters(){for(const master of this.__masters.values())master.destroy();this.__masters.clear()}__updateMaster(data){this.__subscriptionInitialized=!0,this.__deleteAllMasters(),!1!==data&&void 0!==data&&(this.__addMaster(data.netId,data.name),this.__updateView("master"))}__updateView(type){const view=this.__main.view;if(view.name===Commons.TopologyView.None){if("master"===type){const selectedDevice=this.__main.getSelectedDevice();if(!selectedDevice)return;const master=this.__masters.get(selectedDevice.masterNetId);if(!master)return;this.__main.createNotification("master-found",{target:{name:this.__name,netId:this.__netId},master:{netId:master.netId,name:master.name}}),this.__main.setViewMaster(master),master.displayView()}}else TcHmi.Log.error(`Invalid name of view '${view.name}.'`)}setView(view,masterNetId=null){switch(view){case Commons.TopologyView.None:case Commons.TopologyView.Master:break;case Commons.TopologyView.Network:if(null===this.__available)return void this.__main.createNotification("waiting-for-target-availability",{target:{netId:this.__netId,name:this.__name}});if(null===masterNetId)return;if(!this.__subscriptionInitialized)return;const master=this.__masters.get(masterNetId);if(!master)return void this.__main.createNotification("master-not-found",{target:{netId:this.__netId,name:this.__name},master:{netId:masterNetId}});master.init_networkView();const msgData={target:{netId:this.netId,name:this.name},master:{netId:master.netId,name:master.name}};this.__main.setViewMaster(master),this.__main.createNotification("init-network-view",msgData);break;default:TcHmi.Log.error(`Invalid view for Target '${view}'`)}}destroy(){this.__main.comObj&&this.__clearMasters()}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Component=class{constructor(index){this.__redundancyPort=null,this.__outgoingEBusPort=null,this.__outgoingConfiguredEBusPort=null,this.__cableLinkPorts=[],this.__outgoingConfiguredCableLinkPorts=[],this.__hasOutgoingConfiguredEBusPort=!1,this.__hasIncomingCableLinkPort=!1,this.__numOfOutgoingConfiguredCableLinkPorts=0,this.__numOfCableLinkPorts=0,this.__numOfConfiguredPorts=0,this.__index=index}get main(){return this.master.main}get index(){return this.__index}get redundancyPort(){return this.__redundancyPort}set redundancyPort(port){this.__redundancyPort=port}get outgoingEBusPort(){return this.__outgoingEBusPort}set outgoingEBusPort(port){this.__outgoingEBusPort=port}get outgoingConfiguredEBusPort(){return this.__outgoingConfiguredEBusPort}set outgoingConfiguredEBusPort(port){this.__outgoingConfiguredEBusPort=port}get cableLinkPorts(){return this.__cableLinkPorts}addCableLinkPort(port){const index=this.__cableLinkPorts.length;return this.__cableLinkPorts.push(port),index}get outgoingConfiguredCableLinkPorts(){return this.__outgoingConfiguredCableLinkPorts}addOutgoingConfiguredCableLinkPort(port){const index=this.__outgoingConfiguredCableLinkPorts.length;return this.__outgoingConfiguredCableLinkPorts.push(port),index}get hasOutgoingConfiguredEBusPort(){return this.__hasOutgoingConfiguredEBusPort}get hasIncomingCableLinkPort(){return this.__hasIncomingCableLinkPort}get numOfOutgoingConfiguredCableLinkPorts(){return this.__numOfOutgoingConfiguredCableLinkPorts}get numOfCableLinkPorts(){return this.__numOfCableLinkPorts}get numOfConfiguredPorts(){return this.__numOfConfiguredPorts}get design(){return this.__design}reset(){this.__ports=[],this.__redundancyPort=null,this.__outgoingEBusPort=null,this.__cableLinkPorts=[],this.__outgoingConfiguredCableLinkPorts=[],this.__hasOutgoingConfiguredEBusPort=!1,this.__hasIncomingCableLinkPort=!1,this.__numOfOutgoingConfiguredCableLinkPorts=0,this.__numOfCableLinkPorts=0,this.__numOfConfiguredPorts=0}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){let TopologyType;!function(TopologyType){TopologyType[TopologyType.master=0]="master",TopologyType[TopologyType.hotConnect=1]="hotConnect",TopologyType[TopologyType.disabled=2]="disabled"}(TopologyType=Commons.TopologyType||(Commons.TopologyType={}));Commons.Topology=class{constructor(network,firstData,type){this.__matrixDesign={margin:50,marginRows:{top:150,bottom:75}},this.__matrixComponentOrder=[],this.__matrixRows=[],this.__matrixDimension={width:0,height:0},this.__chronologicalPortList=[],this.__traces=[],this.__network=network,this.__topologyType=type,type===TopologyType.master&&firstData instanceof Commons.Master?this.__firstComponent=firstData:type===TopologyType.hotConnect||type===TopologyType.disabled?this.__firstComponent=new Commons.Slave(firstData,new Commons.Trace(this),null,null,[]):TcHmi.Log.error("Topology and firstData type mismatch.")}get network(){return this.__network}get master(){return this.network.master}get componentOrder(){return this.__matrixComponentOrder}get matrixRows(){return this.__matrixRows}addRow(index,startDimension){const newRow={index:index,height:startDimension.height,width:startDimension.width,yOffset:0};this.__matrixRows.splice(index,0,newRow);for(let rowIndex=newRow.index+1;rowIndex<this.__matrixRows.length;rowIndex++)this.__matrixRows[rowIndex].index++;return newRow}get matrixDimension(){return this.__matrixDimension}get chronologicalPortList(){return this.__chronologicalPortList}addPortToChronologicalPortList(port){this.__chronologicalPortList.push(port)}get traces(){return this.__traces}addTrace(){const trace=new Commons.Trace(this);return this.__traces.push(trace),trace}calcNetwork(){if(!this.__firstComponent)return void TcHmi.Log.error("First component of topology is not defined.");this.__matrixRows=[],this.__matrixComponentOrder=[];const newRow=this.addRow(0,this.__firstComponent.design.dimension),coordinates={col:this.__matrixDesign.margin,row:newRow};this.__firstComponent.startCoordinates=coordinates,this.__topologyType!==TopologyType.disabled?this.__firstComponent.follow(0):this.__matrixComponentOrder.push(this.__firstComponent)}calcMatrix(){this.__matrixDimension={width:0,height:0},this.__matrixDimension.height+=this.__matrixDesign.margin;for(const row of this.__matrixRows)this.__matrixDimension.height+=this.__matrixDesign.marginRows.top,row.yOffset=this.__matrixDimension.height,this.__matrixDimension.height+=row.height,this.__matrixDimension.height+=this.__matrixDesign.marginRows.bottom,this.__matrixDimension.width=Math.max(this.__matrixDimension.width,row.width);this.__matrixDimension.width+=2*this.__matrixDesign.margin,this.__matrixDimension.height+=this.__matrixDesign.margin}groupAllTerminalGroups(){for(const trace of this.__traces)trace.groupSlaveTerminalGroups()}ungroupAllTerminalGroups(){for(const trace of this.__traces)trace.ungroupSlaveTerminalGroups()}hasGroupedSlaves(){for(const trace of this.__traces)if(trace.hasGroupedSlaves())return!0;return!1}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Network=class{constructor(master){this.__updatePixelRatio=evt=>{this.__media=window.matchMedia(`(resolution: ${window.devicePixelRatio}dppx)`),this.__media.addEventListener("change",this.__updatePixelRatio,{once:!0}),evt&&this.__resizeEvent()},this.__hotConnectTopologies=[],this.__disabledSlaveTopologies=[],this.__isExpand=!0,this.__combinedMatrix={matrix:[],componentOrder:[],rows:[],dimension:{width:0,height:0}},this.__master=master;const contentWrapper=this.__master.main.contentWrapper;this.__networkView=new Commons.DrawingNetwork(this,this.drawMatrix.bind(this)),contentWrapper.append(this.__networkView),this.__resizeObserver=new ResizeObserver((entries=>{this.__resizeEvent()})),this.__resizeObserver.observe(contentWrapper),this.__updatePixelRatio()}destroy(){this.__media?.removeEventListener("change",this.__updatePixelRatio),this.__networkView.destroy(),this.__resizeObserver.disconnect()}get master(){return this.__master}get target(){return this.master.target}get main(){return this.target.main}reload(){this.__networkView.reload()}resetView(){this.__networkView.resetView()}update(slavesData){this.master.reset(),this.master.clearSlaves(),this.__hotConnectTopologies=[],this.__disabledSlaveTopologies=[],0!==slavesData.slavesCount&&slavesData.master.configuredSlave?this.__addMasterSlaveTopology(slavesData.master):this.__addMasterTopology();for(const slaveData of slavesData.hotConnectGroups)this.__addHotConnectTopology(slaveData);for(const slaveData of slavesData.disabledSlaves)this.__addDisabledSlave(slaveData);this.recalcNetwork()}get masterTopology(){return this.__master.topology}getHotConnectTopologies(){return this.__hotConnectTopologies}getDisabledSlaves(){return this.__disabledSlaveTopologies}__addMasterTopology(){this.__master.topology=new Commons.Topology(this,this.__master,Commons.TopologyType.master)}__addMasterSlaveTopology(slavesOfMaster){this.__addMasterTopology();const physic=slavesOfMaster.portPhysic;this.__master.setPort(1,new Commons.PortMaster(this.__master,1,physic,null,slavesOfMaster.configuredSlave))}__addHotConnectTopology(slave){const hotConnectTopoology=new Commons.Topology(this,slave,Commons.TopologyType.hotConnect);this.__hotConnectTopologies.push(hotConnectTopoology)}__addDisabledSlave(slave){const disabledSlaveTopology=new Commons.Topology(this,slave,Commons.TopologyType.disabled);this.__disabledSlaveTopologies.push(disabledSlaveTopology)}toggleExpansion(){for(const slave of this.master.slaves.values())slave.numOfOutgoingConfiguredCableLinkPorts>0&&(slave.expansion=!this.__isExpand);this.recalcNetwork(this.master)}get isExpand(){return this.__isExpand}setToNotExpand(){this.__isExpand=!1}recalcNetwork(focusedComponent){if(!this.master.topology)return;const margin_x=0,margin_y=0;this.__isExpand=!0,this.master.topology.calcNetwork(),this.master.topology.calcMatrix(),this.__combinedMatrix.rows=[],this.__combinedMatrix.rows=this.__combinedMatrix.rows.concat(this.master.topology.matrixRows),this.__combinedMatrix.dimension={width:this.master.topology.matrixDimension.width,height:this.master.topology.matrixDimension.height},this.__combinedMatrix.componentOrder=[],this.__combinedMatrix.componentOrder=this.__combinedMatrix.componentOrder.concat(this.master.topology.componentOrder),this.__combinedMatrix.dimension.width+=margin_x,this.__combinedMatrix.dimension.height+=margin_y;let shift={x:0,y:0};for(const component of this.__combinedMatrix.componentOrder){const coordinates=component.coordinates;if(!coordinates){TcHmi.Log.error("Coordinates are not set yet");continue}const componentPos={x:coordinates.col,y:coordinates.row.yOffset};component===focusedComponent&&component.networkPos!==componentPos&&(shift={x:component.networkPos.x-componentPos.x,y:component.networkPos.y-componentPos.y}),component.networkPos=componentPos;for(const port of component.cableLinkPorts){const rel=port.pos.rel;port.pos.network={x:componentPos.x+rel.x,y:componentPos.y+rel.y}}}this.__networkView.calcZoomLevelLimits(),this.__drawMatrix(shift)}__resizeEvent(){this.__networkView.resizeEvent((()=>{this.drawMatrix()}))}drawMatrix(){this.__drawMatrix()}__drawMatrix(shift){if(!this.__networkView)return void TcHmi.Log.error("Network view is not defined");const dimension=this.__combinedMatrix.dimension;this.__networkView.setInitialDimension(dimension),this.__networkView.initDrawing(),shift&&this.__networkView.shiftCanvasRelByZoomLevel(shift);const layers=this.__networkView.focusedLayers;layers.erase(),this.__networkView.clearCanvas();for(const component of this.__combinedMatrix.componentOrder)this.__networkView.drawComponent(component,layers);this.__networkView&&this.master.topology&&this.__networkView.updateHover()}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class Master extends Commons.Component{constructor(target,netId,name){super(target.countMasters()),this.__topology=null,this.__trace=null,this.__subscriptions=new Map,this.__syncUnits=new Commons.SyncUnits,this.__selectedSyncUnit=null,this.__masterWriteValue=null,this.__slaves=new Map,this.__numOfSlaves=0,this.__slavesSorted=[],this.__slavesScanned=null,this.__slavesScanInProgress=!1,this.__extendedInfoOfMaster=null,this.__extendedInfoOfSlave=null,this.__extendedInfoTabName={Slave:null,Master:null},this.__ports=[],this.__state=null,this.__design={dimension:{width:500,height:400},color:{r:249,g:249,b:249},labelColor:"#000",labelHeight:0,interior:{offset:{x:0,y:0},dimension:{width:100,height:300},section:{cols:1,rows:4}}},this.__subscriptionReadValues=new Map,this.__subscriptionOldReadValues=new Map,this.__hasForcedProcessData=!1,this.forcedProcessDataCbs=new Set,this.__target=target,this.__netId=netId,this.__name=name,this.__data={online:{stateMachine:{code:{value:null,domElements:new Set},name:{value:null,domElements:new Set}},stateMachineRequested:{code:{value:null,domElements:new Set},name:{value:null,domElements:new Set}},frames:{total:{cyclic:{value:null,domElements:new Set},acyclic:{value:null,domElements:new Set}},perSec:{cyclic:{value:null,domElements:new Set},acyclic:{value:null,domElements:new Set}},missed:{cyclic:{value:null,domElements:new Set},acyclic:{value:null,domElements:new Set}},damaged:{sent:{value:null,domElements:new Set},received:{value:null,domElements:new Set}}}}},this.__masterWriteValue=this.main.config.device,this.__calculateDesign(),this.__network=new Commons.Network(this);this.__pos={coordinates:{col:0,row:{index:0,yOffset:0,width:0,height:0}},network:{x:-1,y:-1}};const comObj=this.main.comObj;if(!comObj)return;const subscription=comObj.subscribe({symbol:`${Commons.extensionName}.GetMasterOnlineInfo`,writeValue:this.__masterWriteValue},1e3,this.updateMasterOnlineInfo.bind(this),(()=>{this.__subscriptions.set(`${Commons.extensionName}.GetMasterOnlineInfo`,subscription),TcHmi.Log.info(`${Commons.extensionName}.GetMasterOnlineInfo was subscribed successfully.`)}))}reload(){this.__network.reload()}resetView(){this.__network.resetView()}getNetIdAndName(){return{netId:this.netId,name:this.name}}getTargetAndMasterNetIdAndName(){return{target:this.__target.getNetIdAndName(),master:this.getNetIdAndName()}}set startCoordinates(coordinates){this.__pos.coordinates=coordinates}get coordinates(){return this.__pos.coordinates}set networkPos(value){this.__pos.network=value}get networkPos(){return this.__pos.network}follow(){if(null===this.topology)return;this.topology.componentOrder.push(this);const[inPort,outPort]=this.__ports;if(!outPort)return;const nextTrace=outPort.nextTrace;if(!nextTrace)return;const coordinates={col:this.__pos.coordinates.col,row:this.__pos.coordinates.row};coordinates.col+=this.__design.dimension.width,outPort.isCableLink&&(coordinates.col+=200),nextTrace.pos=coordinates,outPort.nextSlave?.follow(0)}get pos(){return this.__pos}get topology(){return this.__topology}set topology(value){this.__topology=value}get network(){return this.__network}get trace(){return this.__trace}get main(){return this.__target.main}displayView(){this.init_networkView(),this.main.createNotification("init-network-view",this.getTargetAndMasterNetIdAndName())}hideView(){}init_networkView(){this.__deleteOldSubscriptions();const comObj=this.main.comObj;comObj&&this.__subscriptions.set(`${Commons.extensionName}.GetSlaves`,comObj.subscribe({symbol:`${Commons.extensionName}.GetSlaves`,writeValue:this.__masterWriteValue},1e3,this.__updateSlaves.bind(this),(()=>{TcHmi.Log.info(`${Commons.extensionName}.GetSlaves was subscribed successfully.`),this.__subscriptions.set(`${Commons.extensionName}.GetSlavesOnlineInfo`,comObj.subscribe({symbol:`${Commons.extensionName}.GetSlavesOnlineInfo`,writeValue:this.__masterWriteValue},500,this.updateSlavesOnlineInfo.bind(this),(()=>{TcHmi.Log.info(`${Commons.extensionName}.GetSlavesOnlineInfo was subscribed successfully.`)}))),this.__subscriptions.set(`${Commons.extensionName}.GetSlavesScanned`,comObj.subscribe({symbol:`${Commons.extensionName}.GetSlavesScanned`,writeValue:this.__masterWriteValue},2e3,this.updateSlavesScanned.bind(this),(()=>{TcHmi.Log.info(`${Commons.extensionName}.GetSlavesScanned was subscribed successfully.`)}))),this.__subscriptions.set(`${Commons.extensionName}.ListSlavesWithForcedProcessData`,comObj.subscribe({symbol:`${Commons.extensionName}.ListSlavesWithForcedProcessData`,writeValue:this.__masterWriteValue},1e3,this.updateSlavesWithForcedProcessData.bind(this),(()=>{TcHmi.Log.info(`${Commons.extensionName}.ListSlavesWithForcedProcessData was subscribed successfully.`)})))})))}__deleteOldSubscriptions(){const comObj=this.main.comObj;if(!comObj)return;const subscriptionNames=[`${Commons.extensionName}.GetSlaves`,`${Commons.extensionName}.GetSlavesOnlineInfo`];for(const subscriptionName of subscriptionNames){const subscriptionId=this.__subscriptions.get(subscriptionName);if(null==subscriptionId)return;comObj.unsubscribe(subscriptionId,(()=>{this.__subscriptions.delete(subscriptionName),TcHmi.Log.info(`Subscription ${subscriptionName} successfully unsubscribed.`)}))}}get syncUnits(){return this.__syncUnits}__clearSyncUnits(){this.__syncUnits.clear()}addSlaveToSyncUnit(slave){const syncUnitIdsOfSlave=slave.syncUnitIds;if(syncUnitIdsOfSlave)for(const id of syncUnitIdsOfSlave)this.__syncUnits.addSlave(id,slave)}set selectedSyncUnit(syncUnitId){this.__selectedSyncUnit=syncUnitId}get selectedSyncUnit(){return this.__selectedSyncUnit}get target(){return this.__target}get netId(){return this.__netId}get name(){return this.__name}get master(){return this}get data(){return this.__data}getSlave(addr){return this.__slaves.get(addr)}addSlave(slave){this.addSlaveToSyncUnit(slave),this.__numOfSlaves++,this.__slaves.set(slave.addr,slave)}get slaves(){return this.__slaves}addSortedSlave(slave){this.__slavesSorted.push(slave)}clearSlaves(){this.__numOfSlaves=0,this.__slaves.clear()}get numOfSlaves(){return this.__numOfSlaves}get slavesScanned(){return this.__slavesScanned}get isSlavesScanInProgress(){return this.__slavesScanInProgress}set slavesScanInProgress(value){this.__slavesScanInProgress=value}setExtendedInfoTabName(component,tabName){void 0!==this.__extendedInfoTabName[component]?this.__extendedInfoTabName[component]=tabName:TcHmi.Log.error(`There is no known component called ${component}`)}getExtendedInfoTabName(component){return void 0!==this.__extendedInfoTabName[component]?this.__extendedInfoTabName[component]:(TcHmi.Log.error(`There is no known component called ${component}`),null)}getExtendedInfoOfMaster(){return this.__extendedInfoOfMaster}getExtendedInfoOfSlave(){return this.__extendedInfoOfSlave}setExtendedInfoOfMaster(extendedInfo){const oldExtendedInfo=this.__extendedInfoOfMaster;this.__extendedInfoOfMaster=extendedInfo,oldExtendedInfo&&oldExtendedInfo.close()}setExtendedInfoOfSlave(extendedInfo){const oldExtendedInfo=this.__extendedInfoOfSlave;this.__extendedInfoOfSlave=extendedInfo,oldExtendedInfo&&oldExtendedInfo.close()}removeExtendedInfoOfMaster(extendedInfo){this.__extendedInfoOfMaster===extendedInfo&&(this.__extendedInfoOfMaster=null)}removeExtendedInfoOfSlave(extendedInfo){this.__extendedInfoOfSlave===extendedInfo&&(this.__extendedInfoOfSlave=null)}get ports(){return this.__ports}setPort(index,port){this.__ports[index]=port}checkPresence(){}get isPresent(){return!0}checkPortState(){}checkIdentity(){}set state(state){this.__state=state}__calculateDesign(){this.__design.interior.offset.x=this.__design.dimension.width-100,this.__design.interior.dimension.height=this.__design.dimension.height-100}destroy(){const comObj=this.main.comObj;comObj&&(comObj.unsubscribe(this.__subscriptions.get(`${Commons.extensionName}.GetSlaves`)),comObj.unsubscribe(this.__subscriptions.get(`${Commons.extensionName}.GetOnlineInfo`)),comObj.unsubscribe(this.__subscriptions.get(`${Commons.extensionName}.GetSlavesScanned`))),this.__extendedInfoOfMaster?.close(),this.__extendedInfoOfSlave?.close(),this.__network.destroy()}hide(){}__updateSlaves(data){data&&(this.__slaves.clear(),this.__slavesSorted=[],this.__syncUnits=new Commons.SyncUnits,this.__extendedInfoOfSlave?.close(),this.__extendedInfoOfSlave=null,this.__extendedInfoOfMaster?.close(),this.__extendedInfoOfMaster=null,this.__network.update(data),0!==data.slavesCount&&this.updateSlavesOnlineInfo(null),this.main.clearNotification(Commons.NotificationCategory.task),this.__subscriptionReadValues.set("GetSlaves",data))}updateMasterOnlineInfo(data){let significantChangeToRedraw=!1;if(void 0===data)return;const symbol="GetMasterOnlineInfo";if(data?this.__subscriptionReadValues.set(symbol,data):this.__subscriptionOldReadValues.set(symbol,{}),!this.__subscriptionReadValues.has(symbol))return;this.__subscriptionOldReadValues.has(symbol)||this.__subscriptionOldReadValues.set(symbol,{});const changes=Commons.Utility.compareObjects(this.__subscriptionOldReadValues.get(symbol),this.__subscriptionReadValues.get(symbol));significantChangeToRedraw||(significantChangeToRedraw="stateMachine"in changes),this.processOnlineChanges(changes),Object.assign(this.__subscriptionOldReadValues.get(symbol)??{},this.__subscriptionReadValues.get(symbol)),significantChangeToRedraw&&this.network.drawMatrix()}updateSlavesScanned(data){if(this.slavesScanInProgress=!1,!1===data);else{this.__slavesScanned=data;let scannedSlaveIndex=0;for(const slave of this.__slavesSorted){if(!slave||slave.isDisabled||slave.isNotPresent){slave.processScannedIdentity(null);continue}const slaveScanned=this.__slavesScanned.slaves[scannedSlaveIndex];if(!slaveScanned){slave.processScannedIdentity(null);break}scannedSlaveIndex++,slave.processScannedIdentity(slaveScanned)}this.updateSlavesOnlineInfo(null)}}set hasForcedProcessData(value){this.__hasForcedProcessData=value}get hasForcedProcessData(){return this.__hasForcedProcessData}updateSlavesWithForcedProcessData(physAddrOfSlavesWithForcedProcessData){this.__hasForcedProcessData=physAddrOfSlavesWithForcedProcessData.length>0;for(const[physAddr,slave]of this.__slaves)slave.hasForcedProcessData=physAddrOfSlavesWithForcedProcessData.includes(physAddr);this.__extendedInfoOfSlave&&this.__extendedInfoOfSlave.updateDrawings();for(const cb of this.forcedProcessDataCbs)cb(physAddrOfSlavesWithForcedProcessData);this.network.drawMatrix()}updateSlavesOnlineInfo(data){if(void 0===data)return void TcHmi.Log.error("SlavesOnlineInfo returned 'undefined'.");const symbol="GetSlavesOnlineInfo";let changes=null;if(this.__subscriptionOldReadValues.has(symbol)||this.__subscriptionOldReadValues.set(symbol,{}),null===data?changes=Commons.Utility.compareObjects({},this.__subscriptionOldReadValues.get(symbol)):(changes=Commons.Utility.compareObjects(this.__subscriptionOldReadValues.get(symbol),data),Object.assign(this.__subscriptionOldReadValues.get(symbol)??{},data)),null===changes)return;const changesSlaves=changes.slaves;if(changesSlaves)for(const[slavePhysAddr,slaveChanges]of Object.entries(changesSlaves)){const addr=parseInt(slavePhysAddr,10),slave=this.getSlave(addr);slave?void 0!==slaveChanges.current?.presence?.notPresent?slave.processOnlineChanges(data?.slaves[slavePhysAddr]??null):slave.processOnlineChanges(slaveChanges):TcHmi.Log.error("Matching slave to process online info not found")}this.__extendedInfoOfSlave&&this.__extendedInfoOfSlave.updateDrawings(),this.network.drawMatrix()}findScannedSlaveByIdentity(vendor,product,revision,onlyIdentityInvalid){if(this.__slavesScanned&&this.__slavesScanned.slaves){let indexOfScannedSlave=null;for(const[i,slaveScanned]of this.__slavesScanned.slaves.entries())if(slaveScanned.vendorId===vendor&&slaveScanned.productCode===product&&slaveScanned.revisionNumber===revision&&(!onlyIdentityInvalid||0===slaveScanned.addr)){indexOfScannedSlave=i;break}if(null===indexOfScannedSlave)return null;let countToIndexOfScannedSlave=0;for(const configuredSlave of this.__slavesSorted)if(configuredSlave&&!configuredSlave.isDisabled&&configuredSlave.isPresent){if(countToIndexOfScannedSlave===indexOfScannedSlave)return configuredSlave;countToIndexOfScannedSlave++}}return null}findSlaveByIdentity(vendor,product,revision,onlyIdentityInvalidOrNotPresent){for(const slave of this.__slavesSorted){const identity=slave.data.EtherCAT.identity;if(vendor===identity.vendor.id.value&&product===identity.product.value&&revision===identity.revision.value&&(!onlyIdentityInvalidOrNotPresent||slave.hasInvalidIdentity||slave.isNotPresent))return slave}return null}findFirstNotPresentSlave(){for(const slave of this.__slavesSorted)if(slave.isNotPresent)return slave;return null}processOnlineChanges(changes){const onlineData=this.data.online;Commons.setOnlineData(onlineData.frames.total.cyclic,changes.frames?.total?.cyclic),Commons.setOnlineData(onlineData.frames.total.acyclic,changes.frames?.total?.acyclic),Commons.setOnlineData(onlineData.frames.missed.cyclic,changes.frames?.missed?.cyclic),Commons.setOnlineData(onlineData.frames.missed.acyclic,changes.frames?.missed?.acyclic),Commons.setOnlineData(onlineData.frames.perSec.cyclic,changes.frames?.perSec?.cyclic),Commons.setOnlineData(onlineData.frames.perSec.acyclic,changes.frames?.perSec?.acyclic),Commons.setOnlineData(onlineData.frames.damaged.sent,changes.frames?.damaged?.sent),Commons.setOnlineData(onlineData.frames.damaged.received,changes.frames?.damaged?.received),Commons.setOnlineData(onlineData.frames.damaged.sent,changes.frames?.damaged?.sent),Commons.setOnlineData(onlineData.frames.damaged.received,changes.frames?.damaged?.received),Commons.setOnlineData(onlineData.stateMachine.code,changes.stateMachine),changes.stateMachine&&Commons.setOnlineData(onlineData.stateMachine.name,Commons.StateMachineStateName[changes.stateMachine]),Commons.setOnlineData(onlineData.stateMachineRequested.code,changes.stateMachineRequested),changes.stateMachineRequested&&Commons.setOnlineData(onlineData.stateMachineRequested.name,Commons.StateMachineStateName[changes.stateMachineRequested])}}Commons.Master=Master}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Trace=class{constructor(topology){this.__slaves=[],this.__pos=null,this.__dimension={width:0,height:0},this.__slaveTerminalGroups=[],this.__topology=topology}get pos(){return this.__pos}set pos(value){this.__pos=value}addWidth(value){if(this.__pos){const col=this.__pos.col;this.__pos.row.width=col+value}else TcHmi.Log.error("You've tried to call Trace.addWith() before the position of the trace was set.")}set height(value){if(this.__pos){const row=this.__pos.row;row.height=Math.max(row.height,value)}}get dimension(){return this.__dimension}get slaves(){return this.__slaves}addSlave(slave){const slaveDimension=slave.design.dimension,xOffset=this.__dimension.width;return this.__dimension.width+=slaveDimension.width,this.__dimension.height=Math.max(this.__dimension.height,slaveDimension.height),this.__slaves.push(slave),xOffset}get topology(){return this.__topology}get network(){return this.topology.network}get master(){return this.network.master}addSlaveTerminalGroup(group){this.__slaveTerminalGroups.push(group)}hasSlaveTerminalGroups(){if(0===this.__slaveTerminalGroups.length)return!1;for(const group of this.__slaveTerminalGroups)if(group.numOfSubSlaves>1)return!0;return!1}hasGroupedSlaves(){if(0===this.__slaveTerminalGroups.length)return null;for(const group of this.__slaveTerminalGroups)if(group.grouped)return!0;return!1}ungroupSlaveTerminalGroups(){for(const group of this.__slaveTerminalGroups)group.ungroup()}groupSlaveTerminalGroups(){for(const group of this.__slaveTerminalGroups)group.group()}toggleSlaveTerminalGroups(){this.hasGroupedSlaves()?this.ungroupSlaveTerminalGroups():this.groupSlaveTerminalGroups()}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class Slave extends Commons.Component{constructor(srSlaveData,trace,connection,slaveTerminalGroup,parentSubSlaves){super(trace.topology.master.numOfSlaves),this.__subSlaves=[],this.__slaveTerminalGroup=null,this.__expansion=!0,this.__processDataSubscription=null,this.__processDataValuesSubscriptionCounter=0,this.__hasForcedProcessData=!1,this.__processDataValues=new Map,this.__errorMessages=new Set,this.__design={dimension:{width:100,height:400},color:{r:249,g:249,b:249},labelHeight:100,labelColor:"#000",interior:{offset:{x:0,y:0},dimension:{width:0,height:0},section:{cols:1,rows:4}}},this.__ports=[],this.__electricalCurrent=null,this.__dependentSlaves=null,this.__remainingCurrent=null,this.__visibility=!1,this.__trace=trace,this.__slaveTerminalGroup=slaveTerminalGroup,this.__data={EtherCAT:{identity:{addrs:{autoInc:srSlaveData.EtherCAT.identity.addrs.autoInc,phys:srSlaveData.EtherCAT.identity.addrs.phys},name:{value:srSlaveData.EtherCAT.identity.name,domElements:new Set},type:{value:srSlaveData.EtherCAT.identity.type,domElements:new Set},vendor:{id:{value:srSlaveData.EtherCAT.identity.vendor.id,domElements:new Set},memberNameLong:{value:srSlaveData.EtherCAT.identity.vendor.memberNameLong,domElements:new Set},memberNameShort:{value:srSlaveData.EtherCAT.identity.vendor.memberNameShort,domElements:new Set}},product:{value:srSlaveData.EtherCAT.identity.product,domElements:new Set},revision:{value:srSlaveData.EtherCAT.identity.revision,domElements:new Set},serial:{value:srSlaveData.EtherCAT.identity.serial,domElements:new Set}},hotConnect:srSlaveData.hotConnect,syncUnitsAssignment:srSlaveData.EtherCAT.syncUnitsAssignment},online:{current:{stateMachine:{code:{value:null,domElements:new Set},name:{value:null,domElements:new Set}},presence:{notPresent:{value:!1,domElements:new Set},notPresentOnPrevSlaves:{value:!1,domElements:new Set}},disabled:{value:!1,domElements:new Set},initError:{value:!1,domElements:new Set},signalsError:{value:!1,domElements:new Set},identity:{isInvalid:{value:!1,domElements:new Set},isInvalidOnPrevSlaves:{value:!1,domElements:new Set}}},requested:{stateMachine:{code:{value:null,domElements:new Set},name:{value:null,domElements:new Set}}},counter:{crc:{sum:{value:null,domElements:new Set},highestWarningLevel:{value:null,domElements:new Set}},abnormalChanges:{value:null,domElements:new Set},connectionLosses:{value:null,domElements:new Set}},labels:[],messages:{value:null,domElements:new Set},syncUnits:new Map},processData:srSlaveData.processData,scannedIdentity:null},this.master.addSlave(this),this.master.addSortedSlave(this);const traceXOffset=trace.addSlave(this);this.__pos={slave:null,networkTraceXOffset:0,traceXOffset:traceXOffset,trace:null,network:{x:-1,y:-1}},this.__calculateDesign();const portsData=[];for(const dataKey of Object.keys(srSlaveData.ports)){const data=srSlaveData.ports[dataKey];portsData.push(data)}const subSlaves=[];this.__initPorts(portsData,connection,subSlaves),this.__subSlaves.push.apply(this.__subSlaves,subSlaves),parentSubSlaves.push.apply(parentSubSlaves,this.__subSlaves),parentSubSlaves.push(this)}static getShortSlaveType(type){return type.length>(type=(type.substr(0,4)+type.substr(4).match(/[a-zA-Z0-9]+/)?.[0]??"").substr(0,7)).length&&(type+=String.fromCharCode(8230)),type}get trace(){return this.__trace}get topology(){return this.trace.topology}get network(){return this.topology.network}get master(){return this.network.master}get main(){return this.master.main}get subSlaves(){return this.__subSlaves}get numOfSubSlaves(){return this.__subSlaves.length}get slaveTerminalGroup(){return this.__slaveTerminalGroup?.isSlaveGroup?this.__slaveTerminalGroup:null}get expansion(){return this.__expansion}set expansion(value){!1===value&&0===this.numOfSubSlaves||(this.__expansion=value)}toggleExpansion(){this.expansion=!this.__expansion}__specialTerminals(){const type=this.__data.EtherCAT.identity.type.value;"EL2904"===type?(this.__design.dimension={width:200,height:400},this.__design.color={r:227,g:179,b:33}):["EL6900","EL1904"].includes(type)?this.__design.color={r:227,g:179,b:33}:type.startsWith("AX")?this.__design.dimension={width:300,height:600}:"EL1012"===type&&(this.__design.dimension={width:100,height:400})}__initPorts(portsData,connection,subSlaves){const[inPortData,...outPortsData]=portsData;this.__numOfConfiguredPorts=0,this.__numOfCableLinkPorts=0,this.__numOfOutgoingConfiguredCableLinkPorts=0,inPortData.physic===Commons.PortPhysic.MII&&(this.__hasIncomingCableLinkPort=!0,this.__numOfCableLinkPorts++),inPortData.configured&&this.__numOfConfiguredPorts++;for(const portData of outPortsData)portData.physic===Commons.PortPhysic.EBUS?portData.configured&&(this.__hasOutgoingConfiguredEBusPort=!0):portData.physic===Commons.PortPhysic.MII&&(this.__numOfCableLinkPorts++,portData.configured&&this.__numOfOutgoingConfiguredCableLinkPorts++),portData.configured&&this.__numOfConfiguredPorts++;this.__numOfCableLinkPorts>0?this.__slaveTerminalGroup=null:null===this.__slaveTerminalGroup?this.__slaveTerminalGroup=new Commons.SlaveTerminalGroup(this):this.__slaveTerminalGroup.addSubSlave(this);let portIndex=0;const inPort=new Commons.PortSlave(this,portIndex++,inPortData,connection,null,[]);this.__ports.push(inPort);for(const portData of outPortsData){const port=new Commons.PortSlave(this,portIndex++,portData,null,this.__slaveTerminalGroup,subSlaves);this.__ports.push(port)}}set networkPos(value){this.__pos.network=value}get networkPos(){return this.__pos.network}get pos(){return this.__pos}get coordinates(){const traceCoordinates=this.trace.pos;return traceCoordinates?{col:traceCoordinates.col+this.__pos.networkTraceXOffset,row:traceCoordinates.row}:null}get syncUnitIds(){return this.__data.EtherCAT.syncUnitsAssignment}get data(){return this.__data}get name(){return this.__data.EtherCAT.identity.name.value}get addr(){return this.__data.EtherCAT.identity.addrs.phys}get autoIncAddr(){return this.__data.EtherCAT.identity.addrs.autoInc}readProcessDataValues(updateForcedState=!1){this.master.main.comObj?.writeSymbol(`${Commons.extensionName}.GetProcessDataValues`,{device:this.master.main.config.device,slaveAddr:this.addr,updateForcedState:updateForcedState},(data=>{this.__processProcessDataValues(data)}))}hasProcessDataObjects(){const pdos=this.processData;return pdos&&(0!==pdos.input.length||0!==pdos.output.length)}subscribeToProcessDataValues(){if(this.hasProcessDataObjects())if(this.__processDataValuesSubscriptionCounter<0)TcHmi.Log.error("Reference counter of process data value subscription < 0. A reference counter should never be a negative value.");else{if(0===this.__processDataValuesSubscriptionCounter){const comObj=this.master.main.comObj;if(!comObj)return void TcHmi.Log.error("WebSocket object is invalid.");this.__processDataSubscription=comObj.subscribe({symbol:`${Commons.extensionName}.GetProcessDataValues`,writeValue:{device:this.master.main.config.device,slaveAddr:this.addr}},100,(data=>{this.__processProcessDataValues(data)}),(()=>{TcHmi.Log.info(`${Commons.extensionName}.GetProcessValues was subscribed on slaveAddr ${this.addr} successfully.`)}))}this.__processDataValuesSubscriptionCounter++}}unsubscribeProcessValueSubscription(){this.hasProcessDataObjects()&&(this.__processDataValuesSubscriptionCounter--,this.__processDataValuesSubscriptionCounter<0?TcHmi.Log.error("Reference counter of process data value subscription < 0. A reference counter should never be a negative value."):0===this.__processDataValuesSubscriptionCounter&&(this.master.main.comObj?this.__processDataSubscription&&(this.master.main.comObj.unsubscribe(this.__processDataSubscription,(()=>{this.__processDataValuesSubscriptionCounter>0||(this.__removeProcessDataValues(),TcHmi.Log.info("Unsubscribed successfully."))})),this.__processDataSubscription=null):TcHmi.Log.error("WebSocket object is invalid.")))}__removeProcessDataValues(){if(this.__data.processData)for(const io of[this.__data.processData.input,this.__data.processData.output])for(const object of io)for(const entry of object.entries)delete entry.historyValue,delete entry.preparedValue,delete entry.value,delete entry.historyChartUpdateInterval}set hasForcedProcessData(value){this.__hasForcedProcessData=value}get hasForcedProcessData(){return this.__hasForcedProcessData}couplerGroupHasForcedProcessData(){if(!this.__expansion)for(const slave of this.subSlaves)if(slave.hasForcedProcessData)return!0;return!1}setProcessDataValues(values,cbErrorEl){this.master.main.comObj?this.master.main.comObj.writeSymbol(`${Commons.extensionName}.SetProcessDataValues`,{device:this.master.main.config.device,slaveAddr:this.addr,values:values},(()=>{this.readProcessDataValues(!0)}),cbErrorEl):TcHmi.Log.error("WebSocket object is invalid.")}forceProcessDataValues(values,cbErrorEl){this.master.main.comObj?this.master.main.comObj.writeSymbol(`${Commons.extensionName}.ForceProcessDataValues`,{device:this.master.main.config.device,slaveAddr:this.addr,values:values},(()=>{this.readProcessDataValues(!0)}),cbErrorEl):TcHmi.Log.error("WebSocket object is invalid.")}releaseProcessDataValues(values,cbErrorEl){this.master.main.comObj?this.master.main.comObj.writeSymbol(`${Commons.extensionName}.ReleaseProcessDataValues`,{device:this.master.main.config.device,slaveAddr:this.addr,values:values},(()=>{this.readProcessDataValues(!0)}),cbErrorEl):TcHmi.Log.error("WebSocket object is invalid.")}getProcessDataObjects(io){if(this.processData)return this.processData[io]}getProcessDataObject(objects,index){for(const object of objects)if(object.index===index)return object;return null}getProcessDataObjectEntry(object,index,subIndex){for(const entry of object.entries)if(entry.index===index&&entry.subIndex===subIndex)return entry;return null}__processProcessDataValues(data){if(void 0!==data)for(const ioType of["input","output"]){const processDataValueObjects=data[ioType],processDataObjects=this.getProcessDataObjects(ioType);if(!processDataObjects)return void TcHmi.Log.error(`No process data objects of io type '${ioType}' found to insert new values.`);for(const valueObject of processDataValueObjects){const processDataObject=this.getProcessDataObject(processDataObjects,valueObject.index);if(!processDataObject)return void TcHmi.Log.error(`No process data objects of io type '${ioType}' and object index '${valueObject.index}' found to insert new values.`);for(const entry of valueObject.entries){const processDataObjectEntry=this.getProcessDataObjectEntry(processDataObject,entry.index,entry.subIndex);if(!processDataObjectEntry)return void TcHmi.Log.error(`No process data object entry of io type '${ioType}', object index '${valueObject.index}', entry index '${entry.index}' and entry subIndex '${entry.subIndex}' found to insert new values.`);if(entry.error&&processDataObjectEntry.value?.errorElements){const errorContent=entry.error.reason??entry.error.message??entry.error.code?.toString()??"";for(const errorEl of processDataObjectEntry.value.errorElements)errorEl.innerHTML!==errorContent&&(errorEl.innerHTML=errorContent);continue}const value=entry.value;processDataObjectEntry.historyValue||(processDataObjectEntry.historyValue=[]),processDataObjectEntry.historyChartsVisible?.size||(processDataObjectEntry.historyValue=[]);let convertedValue=value;"boolean"==typeof convertedValue&&(convertedValue=convertedValue?1:0),processDataObjectEntry.historyValue.push({ts:Date.now(),value:convertedValue,forced:entry.forced});const maxHistoryTime=30,tsNow=Date.now();for(;processDataObjectEntry.historyValue.length>1&&processDataObjectEntry.historyValue[1].ts+1e3*maxHistoryTime<tsNow;)processDataObjectEntry.historyValue.shift();if(!this.setProcessDataValue(processDataObjectEntry,value,entry.forced))return void TcHmi.Log.warn("no element found to apply process data value")}}}else TcHmi.Log.warn(`Process data value of '${this.addr}' returned as undefined. Check other errors of symbol '${Commons.extensionName}.GetProcessDataValues'.`)}getProcessDataValues(pdoType,objectIndex,entryIndex,entrySubIndex){return this.__processDataValues.get(pdoType)?.get(objectIndex)?.get(entryIndex)?.get(entrySubIndex)?.value}setProcessDataValue(entry,value,forced){return null==value?(TcHmi.Log.error("Process data value is invalid."),!1):(entry.value?(entry.value.forced=forced,entry.value.value=value):entry.value={forced:forced,value:value,domElements:new Set,errorElements:new Set},this.updateProcessDataValuesOnlineElements(entry))}updateProcessDataValuesOnlineElements(entry){const onlineEntryValue=entry.value;if(!onlineEntryValue)return!1;const elements=onlineEntryValue.domElements;if(!elements||0===elements.size)return!1;const valueString=onlineEntryValue.value?.toString(),valueStateForcedString=onlineEntryValue.forced?"true":"false";if(!valueString)return!1;for(const el of elements)el.dataset.value===valueString&&el.dataset.valueStateForced===valueStateForcedString&&"true"===el.dataset.showValueAsHex===entry.showValueAsHex||(el.classList.remove("no-value"),el.innerHTML="",el.dataset.valueOnly?entry.showValueAsHex&&"number"==typeof onlineEntryValue.value?(el.insertAdjacentHTML("beforeend",Commons.Utility.toHexString(onlineEntryValue.value)),el.dataset.showValueAsHex="true"):(el.insertAdjacentText("beforeend",valueString),delete el.dataset.showValueAsHex):(onlineEntryValue.forced?el.insertAdjacentHTML("beforeend",'<span class="forced-process-data-value-flag">F</span>'):el.insertAdjacentHTML("beforeend",'<span class="forced-process-data-value-flag-placeholder"></span>'),"boolean"==typeof onlineEntryValue.value?el.insertAdjacentHTML("beforeend",`<span class="boolean-representation ${valueString}">${valueString}</span>`):entry.showValueAsHex&&"number"==typeof onlineEntryValue.value?(el.insertAdjacentHTML("beforeend",Commons.Utility.toHexString(onlineEntryValue.value)),el.dataset.showValueAsHex="true"):(el.insertAdjacentHTML("beforeend",onlineEntryValue.value),delete el.dataset.showValueAsHex),el.classList.add("change-highlight"),el.dataset.highlightTimeout&&clearTimeout(parseInt(el.dataset.highlightTimeout,10)),el.dataset.highlightTimeout=setTimeout((()=>{el.classList.remove("change-highlight"),el.removeAttribute("data-highlight-timeout")}),1e3).toString()),el.dataset.value=valueString,el.dataset.valueStateForced=valueStateForcedString);return!0}addProcessDataValueElement(entry,el){entry.domElements||(entry.domElements=new Set),entry.domElements.add(el)}get onlineData(){return this.__data.online}get processData(){return this.__data.processData}getStateMachineState(hexString){return Commons.Utility.baseConverter(hexString[3],16,10)}processScannedIdentity(scannedIdentity){this.__data.scannedIdentity=scannedIdentity}processOnlineChanges(changes){if(!changes)return;const online=this.__data.online,localization=this.master.target.main.getLocalization();if(changes.current){const statemachine_state_current=changes.current.stateMachine;statemachine_state_current&&(Commons.setOnlineData(online.current.stateMachine.code,statemachine_state_current),Commons.setOnlineData(online.current.stateMachine.name,Commons.StateMachineStateName[statemachine_state_current])),Commons.setOnlineData(online.current.identity.isInvalid,changes.current.identity?.isInvalid),Commons.setOnlineData(online.current.identity.isInvalidOnPrevSlaves,changes.current.identity?.isInvalidOnPrevSlaves),changes.current.presence&&(Commons.setOnlineData(online.current.presence.notPresent,changes.current.presence.notPresent),Commons.setOnlineData(online.current.presence.notPresentOnPrevSlaves,changes.current.presence.notPresentOnPrevSlaves)),Commons.setOnlineData(online.current.disabled,changes.current.disabled),Commons.setOnlineData(online.current.initError,changes.current.initError),Commons.setOnlineData(online.current.signalsError,changes.current.signalsError)}if(changes.requested){const statemachine_state_requested=changes.requested.stateMachine;statemachine_state_requested&&(Commons.setOnlineData(online.requested.stateMachine.code,statemachine_state_requested),Commons.setOnlineData(online.requested.stateMachine.name,Commons.StateMachineStateName[statemachine_state_requested]))}changes.counter&&(this.isPresent&&!this.isDisabled?(Commons.setOnlineData(online.counter.connectionLosses,changes.counter.connectionLosses),Commons.setOnlineData(online.counter.abnormalChanges,changes.counter.abnormalChanges)):(Commons.setOnlineData(online.counter.connectionLosses,null),Commons.setOnlineData(online.counter.abnormalChanges,null)));const portsChanges=changes.ports;if(portsChanges)for(const[portIndex,portChanges]of portsChanges.entries()){if(!portChanges)continue;const port=this.getPortByIndex(portIndex);if(!port)continue;const portOnline=port.online;Commons.setOnlineData(portOnline.current.unexpectedLink,portChanges.current?.unexpectedLink),Commons.setOnlineData(portOnline.current.missingLink,portChanges.current?.missingLink),Commons.setOnlineData(portOnline.current.linkError,portChanges.current?.linkError),this.isPresent&&!this.isDisabled&&port.configured?(Commons.setOnlineData(portOnline.counter.crc.total,portChanges.counter?.crc?.total),Commons.setOnlineData(portOnline.counter.crc.errorOnPrevPort,portChanges.counter?.crc?.errorOnPrevPort)):Commons.setOnlineData(portOnline.counter.crc.total,null)}if(this.__clearErrorMessages(),this.isNotPresent){const slaveNotPresentWrapper=document.createElement("div");this.__addErrorElement(slaveNotPresentWrapper),slaveNotPresentWrapper.classList.add("slave-message");const slaveNotPresentLabel=document.createElement("span");if(slaveNotPresentLabel.classList.add("bold"),localization.addElement(slaveNotPresentLabel,"Msg_Slave_Not_Present"),slaveNotPresentWrapper.append(slaveNotPresentLabel),this.hasNotPresentSlavesBefore){slaveNotPresentWrapper.classList.add("slave-message-warning");const consequentialErrorLabel=document.createElement("div");slaveNotPresentWrapper.append(consequentialErrorLabel),localization.addElement(consequentialErrorLabel,"Msg_Slave_Consequential_Error");const consequentialErrorListEl=document.createElement("ul");slaveNotPresentWrapper.append(consequentialErrorListEl);const consequentialErrorListNotPresentWrapper=document.createElement("li");consequentialErrorListEl.append(consequentialErrorListNotPresentWrapper);const consequentialErrorListNotPresentLabel=document.createElement("span");localization.addElement(consequentialErrorListNotPresentLabel,"Msg_Slave_Consequential_Error_Previous_Slaves_Not_Present");const btnGoToPrevNotPresentSlave=document.createElement("span");btnGoToPrevNotPresentSlave.classList.add("navigation-link"),consequentialErrorListNotPresentWrapper.append(consequentialErrorListNotPresentLabel,btnGoToPrevNotPresentSlave),localization.addElement(btnGoToPrevNotPresentSlave,"Msg_Slave_Consequential_Error_Previous_Slaves_Not_Present_Go_To_Previous_Slave_Btn"),btnGoToPrevNotPresentSlave.addEventListener("click",(()=>{const firstNotPresentSlave=this.master.findFirstNotPresentSlave();firstNotPresentSlave&&this.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(firstNotPresentSlave))}))}else{slaveNotPresentWrapper.classList.add("slave-message-error");const firstOccurrenceLabel=document.createElement("span");firstOccurrenceLabel.classList.add("round-brackets"),localization.addElement(firstOccurrenceLabel,"Msg_First_Occurence"),slaveNotPresentWrapper.append(firstOccurrenceLabel)}}if(this.isDisabled){const slaveDisabledWrapper=document.createElement("div");this.__addErrorElement(slaveDisabledWrapper),slaveDisabledWrapper.classList.add("slave-message-warning"),localization.addElement(slaveDisabledWrapper,"Msg_Slave_Disabled")}const identityError=document.createElement("div");if(identityError.classList.add("slave-message"),this.onlineData.current.identity.isInvalid.value){const msgIdentityError=document.createElement("div");msgIdentityError.classList.add("bold"),localization.addElement(msgIdentityError,"Msg_Slave_Identity_Error");const msgIdentityErrorDesc=document.createElement("div");if(localization.addElement(msgIdentityErrorDesc,"Msg_Slave_Identity_Error_Desc"),identityError.append(msgIdentityError,msgIdentityErrorDesc),this.hasInvalidIdentityBefore||this.hasNotPresentSlavesBefore){identityError.classList.add("slave-message-warning");const msgSlaveConsequentialError=document.createElement("div");localization.addElement(msgSlaveConsequentialError,"Msg_Slave_Consequential_Error");const msgSlaveConsquentialErrorReasons=document.createElement("ul");if(this.hasInvalidIdentityBefore){const msgSlaveConsequentialErrorReason=document.createElement("li");msgSlaveConsquentialErrorReasons.append(msgSlaveConsequentialErrorReason),localization.addElement(msgSlaveConsequentialErrorReason,"Msg_Slave_Consequential_Error_Previous_Slaves_Invalid_Identity")}if(this.hasNotPresentSlavesBefore){const msgSlaveConsequentialErrorReason=document.createElement("li");msgSlaveConsquentialErrorReasons.append(msgSlaveConsequentialErrorReason),localization.addElement(msgSlaveConsequentialErrorReason,"Msg_Slave_Consequential_Error_Previous_Slaves_Not_Present")}identityError.append(msgSlaveConsequentialError,msgSlaveConsquentialErrorReasons)}else identityError.classList.add("slave-message-error");this.__addErrorElement(identityError)}let crc_sum=0,crcHighestWarningLevel=0;online.labels=[];for(const port of this.__ports){port.clearMessages();const portOnline=port.online;let portState=0;(online.current.stateMachine.code.value!==Commons.StateMachineStateName.Operational||this.isNotPresent)&&(portState=Commons.PortStates.notPresent),portOnline.current.unexpectedLink.value?(portState=Commons.PortStates.error,portOnline.current.linkError.value?port.addMessage(localization,["Msg_Port_Unexpected_Connection_Or_Connection_Error"],Commons.NotificationLevel.error):port.addMessage(localization,["Msg_Port_Unexpected_Connection"],Commons.NotificationLevel.error)):portOnline.current.missingLink.value?(portState=Commons.PortStates.error,portOnline.current.linkError.value?port.addMessage(localization,["Msg_Port_Connection_Missing_Or_Connection_Error"],Commons.NotificationLevel.error):port.addMessage(localization,["Msg_Port_Connection_Missing"],Commons.NotificationLevel.error)):portOnline.current.linkError.value&&(portState=Commons.PortStates.error,port.addMessage(localization,["Msg_Port_Connection_Error"],Commons.NotificationLevel.error)),port.state=portState;const crcValue=portOnline.counter.crc.total.value;crcValue&&crcValue>0&&(crc_sum+=crcValue,portOnline.counter.crc.errorOnPrevPort.value?(port.addMessage(localization,["Msg_Port_Crc_Error","Msg_Port_Consquential_Error"],Commons.NotificationLevel.warning),crcHighestWarningLevel=Math.max(crcHighestWarningLevel,Commons.NotificationLevel.warning)):(port.addMessage(localization,["Msg_Port_Crc_Error"],Commons.NotificationLevel.error),crcHighestWarningLevel=Commons.NotificationLevel.error)),port.updateMessages()}if(Commons.setOnlineData(online.counter.crc.sum,crc_sum),Commons.setOnlineData(online.counter.crc.highestWarningLevel,crcHighestWarningLevel),crc_sum>0&&online.labels.push({text:crc_sum.toString(),warningLevel:crcHighestWarningLevel}),this.onlineData.current.identity.isInvalid.value||(online.current.signalsError.value&&!online.current.initError.value?online.labels.push({text:"Statemachine",warningLevel:2}):online.current.initError.value&&!online.current.signalsError.value?online.labels.push({text:"Timeout",warningLevel:2}):online.current.initError.value&&online.current.signalsError.value&&online.labels.push({text:"Statemachine",warningLevel:2})),changes.syncUnits)for(const syncUnitChangeIdStr in changes.syncUnits){const syncUnitChange=changes.syncUnits[syncUnitChangeIdStr],syncUnitChangeId=parseInt(syncUnitChangeIdStr,10);if(!syncUnitChange)continue;let syncUnit=online.syncUnits.get(syncUnitChangeId);syncUnit||(syncUnit={error:{value:!1,domElements:new Set},faultCounter:{value:0,domElements:new Set},framesMissedCount:{value:0,domElements:new Set}},online.syncUnits.set(syncUnitChangeId,syncUnit)),Commons.setOnlineData(syncUnit.faultCounter,syncUnitChange.wcFaultCounter),Commons.setOnlineData(syncUnit.framesMissedCount,syncUnitChange.frameMissedCounter),Commons.setOnlineData(syncUnit.error,syncUnitChange.error)}const comObj=this.master.main.comObj;if(comObj){if(null!==this.__data.scannedIdentity){if(this.main.getSymbolAccess(`${Commons.extensionName}.SendSlavesScanCmd`)){const scanNetworkBtn=document.createElement("button");if(scanNetworkBtn.classList.add("regular-button"),this.master.isSlavesScanInProgress)localization.addElement(scanNetworkBtn,"Slave_Scan_In_Progress");else{const rescanLabel=document.createElement("div");if(localization.addElement(rescanLabel,"Slave_Scan_Rescan"),scanNetworkBtn.append(rescanLabel),this.master.slavesScanned){const lastUpdate=document.createElement("div");lastUpdate.classList.add("italic"),localization.addElement(lastUpdate,"Slave_Scan_Rescan_Last_Update",[this.master.slavesScanned.updated]),scanNetworkBtn.append(lastUpdate)}}scanNetworkBtn.classList.add("slave-message-btn"),scanNetworkBtn.classList.add("slave-message-btn-center"),scanNetworkBtn.addEventListener("click",(()=>{const masterWriteValue=this.main.config.device;comObj.writeSymbol(`${Commons.extensionName}.SendSlavesScanCmd`,masterWriteValue,(()=>{localization.addElement(scanNetworkBtn,"Slave_Scan_In_Progress"),this.master.slavesScanInProgress=!0,TcHmi.Log.info("Rescan cmd sent successfully.")}))})),identityError.append(scanNetworkBtn)}const scannedIdentity=this.__data.scannedIdentity;this.setScannedIdentityCheck(scannedIdentity.vendorId,this.__data.EtherCAT.identity.vendor),this.setScannedIdentityCheck(scannedIdentity.productCode,this.__data.EtherCAT.identity.product),this.setScannedIdentityCheck(scannedIdentity.revisionNumber,this.__data.EtherCAT.identity.revision),this.setScannedIdentityCheck(scannedIdentity.serialNumber,this.__data.EtherCAT.identity.serial),this.setScannedIdentityCheck(this.__data.scannedIdentity.vendorMemberName,this.__data.EtherCAT.identity.vendor.memberNameLong);const vprs={vendor:this.data.EtherCAT.identity.vendor.id.value,product:this.data.EtherCAT.identity.product.value,revision:this.data.EtherCAT.identity.revision.value,serial:this.data.EtherCAT.identity.serial.value};if(this.__data.online.current.identity.isInvalid.value){const configuredIdentityFoundAtSlave=this.master.findScannedSlaveByIdentity(vprs.vendor,vprs.product,vprs.revision,!0),scannedIdentityFoundAtSlave=this.master.findSlaveByIdentity(scannedIdentity.vendorId,scannedIdentity.productCode,scannedIdentity.revisionNumber,!0);if(configuredIdentityFoundAtSlave||scannedIdentityFoundAtSlave){scannedIdentityFoundAtSlave&&(this.setScannedIdentityCheck(scannedIdentityFoundAtSlave.data.EtherCAT.identity.vendor.memberNameLong.value,this.__data.EtherCAT.identity.vendor.memberNameLong),this.setScannedIdentityCheck(scannedIdentityFoundAtSlave.data.EtherCAT.identity.type.value,this.__data.EtherCAT.identity.type),this.setScannedIdentityCheck(scannedIdentityFoundAtSlave.data.EtherCAT.identity.name.value,this.__data.EtherCAT.identity.name));const swappedSlave=configuredIdentityFoundAtSlave===scannedIdentityFoundAtSlave?configuredIdentityFoundAtSlave:null;if(swappedSlave){const msgSwappedSlave=document.createElement("span"),btnSwappedSlave=document.createElement("span");btnSwappedSlave.classList.add("navigation-link"),btnSwappedSlave.textContent=swappedSlave.name,btnSwappedSlave.addEventListener("click",(()=>{this.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(swappedSlave))})),localization.addElement(msgSwappedSlave,"Slave_Scan_VPRS_Error_Swapped_Identity",[btnSwappedSlave]),identityError.append(msgSwappedSlave)}else{if(scannedIdentityFoundAtSlave){const msg=document.createElement("span"),btnScannedIdentityFoundAtSlave=document.createElement("span");btnScannedIdentityFoundAtSlave.classList.add("navigation-link"),btnScannedIdentityFoundAtSlave.textContent=scannedIdentityFoundAtSlave.name,btnScannedIdentityFoundAtSlave.addEventListener("click",(()=>{this.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(scannedIdentityFoundAtSlave))})),localization.addElement(msg,"Slave_Scan_VPRS_Error_Scanned_Identity_Found_In_Configured_Network",[btnScannedIdentityFoundAtSlave]),identityError.append(msg)}else{const msg=document.createElement("span");localization.addElement(msg,"Slave_Scan_VPRS_Error_Scanned_Identity_Missing_In_Configured_Network"),identityError.append(msg)}if(configuredIdentityFoundAtSlave){const msg=document.createElement("span"),btnConfiguredIdentityFoundAtSlave=document.createElement("span");btnConfiguredIdentityFoundAtSlave.classList.add("navigation-link"),btnConfiguredIdentityFoundAtSlave.textContent=configuredIdentityFoundAtSlave.name,btnConfiguredIdentityFoundAtSlave.addEventListener("click",(()=>{this.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(configuredIdentityFoundAtSlave))})),localization.addElement(msg,"Slave_Scan_VPRS_Error_Configured_Identity_Found_In_Scanned_Network",[btnConfiguredIdentityFoundAtSlave]),identityError.append(msg)}else{const msg=document.createElement("span");localization.addElement(msg,"Slave_Scan_VPRS_Error_Configured_Identity_Missing_In_Scanned_Network"),identityError.append(msg)}}}else{const msg=document.createElement("span");localization.addElement(msg,"Slave_Scan_VPRS_Error_Identities_Not_In_Network"),identityError.append(msg)}}}else if(this.main.getSymbolAccess(`${Commons.extensionName}.SendSlavesScanCmd`)){const scanNetworkBtn=document.createElement("button");localization.addElement(scanNetworkBtn,"Slave_Scan_Button"),scanNetworkBtn.classList.add("regular-button"),scanNetworkBtn.classList.add("slave-message-btn"),scanNetworkBtn.classList.add("slave-message-btn-center"),scanNetworkBtn.addEventListener("click",(()=>{const comObj=this.master.main.comObj,masterWriteValue=this.main.config.device;comObj&&comObj.writeSymbol(`${Commons.extensionName}.SendSlavesScanCmd`,masterWriteValue,(()=>{TcHmi.Log.info("Scan slaves command sent successfully.")}))})),identityError.append(scanNetworkBtn)}if(online.messages.domElements)for(const msgEl of online.messages.domElements){let contentChanged=!0;if(msgEl.childElementCount===this.__errorMessages.size){contentChanged=!1;let msgSubEl=msgEl.firstElementChild;for(const errEl of this.__errorMessages){if(msgSubEl?.innerHTML!==errEl.innerHTML){contentChanged=!0;break}msgSubEl=msgSubEl?.nextElementSibling}}if(contentChanged){msgEl.innerHTML="";for(const errEl of this.__errorMessages)msgEl.append(errEl)}}}}setScannedIdentityCheck(valueScanned,target){if(target.domElements){let value=target.value;""!==valueScanned&&target.value!==valueScanned&&(value=`<span class="crossed-out">${target.value}</span> ${valueScanned}`);for(const domElement of target.domElements)if(domElement.innerHTML!==value){let targetValue=value;null===targetValue?(domElement.classList.add("no-value"),targetValue="-"):domElement.classList.remove("no-value"),domElement.innerHTML=targetValue}}}__addErrorElement(el){this.__errorMessages.add(el)}__clearErrorMessages(){this.__errorMessages.clear()}get isPresent(){return!this.isNotPresent}get isNotPresent(){return this.__data.online.current.presence.notPresent.value}get isDisabled(){return this.__data.online.current.disabled.value}get hasNotPresentSlavesBefore(){return this.__data.online.current.presence.notPresentOnPrevSlaves.value}get hasInvalidIdentity(){return this.__data.online.current.identity.isInvalid.value}get hasInvalidIdentityBefore(){return this.__data.online.current.identity.isInvalidOnPrevSlaves.value}get crcSum(){return this.__data.online.counter.crc.sum.value}get crcHighestWarningLevel(){return this.__data.online.counter.crc.highestWarningLevel.value}__calculateDesign(){this.__design.interior.dimension={width:this.__design.dimension.width,height:this.__design.dimension.height-this.__design.labelHeight}}get ports(){return this.__ports}get dependentSlaves(){return this.__dependentSlaves}set dependentSlaves(slaves){this.__dependentSlaves=slaves}set remainingCurrent(remainingCurrent){this.__remainingCurrent=remainingCurrent}get remainingCurrent(){return this.__remainingCurrent}get electricalCurrent(){return this.__electricalCurrent}set electricalCurrent(electricalCurrent){this.__electricalCurrent=electricalCurrent}get identity(){return this.__data.EtherCAT.identity}getPortByIndex(index){return this.__ports[index]}getPortPhysByIndex(index){return this.__ports[index].physic}get staticInfo(){return this.__data.EtherCAT}get visibility(){return this.__visibility}set visibility(value){this.__visibility=value}set startCoordinates(coordinates){this.__trace.pos=coordinates}follow(xOffset){if(this.visibility=!0,this.__expansion||this.network.setToNotExpand(),this.__slaveTerminalGroup&&this.__slaveTerminalGroup.grouped)this.__slaveTerminalGroup.follow(xOffset);else if(this.topology.componentOrder.push(this),this.__trace.height=this.__design.dimension.height,this.__pos.networkTraceXOffset=xOffset,xOffset+=this.__design.dimension.width,this.__trace.addWidth(xOffset),!0===this.__expansion)this.followPorts(xOffset);else for(const subSlave of this.__subSlaves)subSlave.visibility=!1}followPorts(xOffset){const coordinates=this.__trace.pos;if(!coordinates)return;const[inPort,...outPorts]=this.__ports;for(const port of outPorts){let newCol=coordinates.col+xOffset,newRow=coordinates.row;const nextTrace=port.nextTrace;if(!nextTrace)continue;switch(port.isCableLink&&(newCol+=200),port.orientation){case Commons.PortOrientation.right:break;case Commons.PortOrientation.up:newRow=this.topology.addRow(newRow.index,{width:newCol,height:0});break;case Commons.PortOrientation.down:newRow=this.topology.addRow(newRow.index+1,{width:newCol,height:0});break;default:TcHmi.Log.error(`Invalid output-port orientation '${port.orientation}'. Outgoing ports should be orientated to right, up or down. But never to the left (reserved for incoming ports).`)}const newCoordinates={col:newCol,row:newRow};nextTrace.pos=newCoordinates}for(const port of outPorts){if(!port.configured)continue;let nextXOffset=0;port.isEBus&&(nextXOffset=xOffset),port.nextSlave?.follow(nextXOffset)}}}Commons.Slave=Slave}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class Port{constructor(component,index,data,connection,slaveTerminalGroup,subSlaves){if(this.__state=PortStates.notInitialized,this.__isCableLink=!1,this.__isEBus=!1,this.__exists=!1,this.__hotConnectGroupStart=!1,this.__orientation=Commons.PortOrientation.nirvana,this.__pos={rel:{x:0,y:0},slave:null,trace:null,network:{x:0,y:0}},this.__configuredSlaveData=null,this.__configuredComponent=null,this.__nextSlave=null,this.__nextTrace=null,this.__alignment=null,this.__component=component,this.__master=component.master,this.__index=index,this.__configured=data.configured,this.__configured&&(this.__configuredSlaveData=data.configuredSlave),this.__connection=connection,this.__redundancy=data.redundancy,this.__redundancyPath=data.redundancyPath,this.__redundancy){component.redundancyPort=this,this.__redundancy=!0;const redundancyConnection={outPort:this,state:-1,inPort:null},masterRedundancyPort=new PortMaster(this.__master,0,1,redundancyConnection);redundancyConnection.inPort=masterRedundancyPort,this.__connection=redundancyConnection,this.__master.setPort(0,masterRedundancyPort)}if(this.__physic=data.physic,0===index){this.__connection&&(this.__connection.inPort=this),this.__defineIncoming();const topology=this.__component.topology;if(!topology)return;topology.addPortToChronologicalPortList(this)}else this.__defineOutgoing(),this.__configured&&!this.__redundancy&&this.__initNext(slaveTerminalGroup,subSlaves)}get connection(){return this.__connection}get state(){return this.__state}set state(value){this.__state=value}get isCableLink(){return this.__isCableLink}get isEBus(){return this.__isEBus}get exists(){return this.__exists}get hotConnectGroupStart(){return this.__hotConnectGroupStart}get orientation(){return this.__orientation}__defineIncoming(){switch(this.__connection&&(this.__configuredComponent=this.__connection.outPort.component),this.__component instanceof Commons.Slave&&this.__component.data.EtherCAT.hotConnect.isHotConnectHead&&(this.__hotConnectGroupStart=!0),this.__orientation=Commons.PortOrientation.left,this.__physic){case PortPhysic.NONE:break;case PortPhysic.MII:case PortPhysic.FastHotConnect:this.__exists=!0,this.__isCableLink=!0;const cableLinkIndex=this.__component.addCableLinkPort(this);this.__evaluateAlignment(cableLinkIndex);break;case PortPhysic.EBUS:this.__exists=!0,this.__isEBus=!0,this.__pos.rel={x:0,y:200};break;default:TcHmi.Log.error(`Invalid type '${this.__physic}' of incoming port.`)}}__defineOutgoing(){switch(this.__physic){case PortPhysic.NONE:break;case PortPhysic.MII:case PortPhysic.FastHotConnect:this.__exists=!0,this.__isCableLink=!0;const cableLinkIndex=this.__component.addCableLinkPort(this);if(this.__evaluateAlignment(cableLinkIndex),!this.__configured)break;const outgoingConfiguredCableLinkIndex=this.__component.addOutgoingConfiguredCableLinkPort(this);switch(outgoingConfiguredCableLinkIndex){case 0:this.__component.hasIncomingCableLinkPort&&this.__component.hasOutgoingConfiguredEBusPort&&1===this.__component.numOfOutgoingConfiguredCableLinkPorts?this.__orientation=Commons.PortOrientation.down:this.__component.hasOutgoingConfiguredEBusPort||3===this.__component.numOfOutgoingConfiguredCableLinkPorts?this.__orientation=Commons.PortOrientation.up:this.__orientation=Commons.PortOrientation.right;break;case 1:3===this.__component.numOfOutgoingConfiguredCableLinkPorts?this.__orientation=Commons.PortOrientation.right:this.__orientation=Commons.PortOrientation.down;break;case 2:this.__orientation=Commons.PortOrientation.down;break;default:TcHmi.Log.error(`Invalid outgoingConfiguredCableLinkIndex '${outgoingConfiguredCableLinkIndex}' should be between 0 and 2 because maximum number of outgoing ports is 3.`)}break;case PortPhysic.EBUS:this.__exists=!0,this.__isEBus=!0,this.__orientation=Commons.PortOrientation.right,this.__pos.rel={x:this.__component.design.dimension.width,y:200},this.__component.outgoingEBusPort=this,this.__configured&&(this.__component.outgoingConfiguredEBusPort=this);break;default:TcHmi.Log.error(`Invalid type '${this.__physic}' of outgoing port.`)}}__evaluateAlignment(cableLinkIndex){if(!this.__alignment)if(this.__alignment={col:0,row:0,colspan:1,rowspan:1},this.__component.hasIncomingCableLinkPort&&this.__component.hasOutgoingConfiguredEBusPort&&this.__component.numOfOutgoingConfiguredCableLinkPorts>1)switch(cableLinkIndex){case 0:this.__alignment={col:0,row:1,colspan:1,rowspan:1};break;case 1:this.__alignment={col:0,row:0,colspan:1,rowspan:1};break;case 2:this.__alignment={col:0,row:2,colspan:1,rowspan:1};break;case 3:this.__alignment={col:0,row:3,colspan:1,rowspan:1};break;default:TcHmi.Log.error(`Invalid cableLink index '${cableLinkIndex}'. CableLink index should be between 0 and 3 because max number of ports is 4.`)}else switch(cableLinkIndex){case 0:this.__alignment={col:0,row:0,colspan:1,rowspan:1};break;case 1:this.__alignment={col:0,row:1,colspan:1,rowspan:1};break;case 2:this.__alignment={col:0,row:2,colspan:1,rowspan:1};break;case 3:this.__alignment={col:0,row:3,colspan:1,rowspan:1};break;default:TcHmi.Log.error(`Invalid cableLink index '${cableLinkIndex}'. CableLink index should be between 0 and 3 because max number of ports is 4.`)}const interior=this.__component.design.interior,sectionDimension_width=interior.dimension.width/interior.section.cols,sectionDimension_height=interior.dimension.height/interior.section.rows;this.__pos.rel={x:interior.offset.x+sectionDimension_width*this.__alignment.col+sectionDimension_width*this.__alignment.colspan/2,y:interior.offset.y+sectionDimension_height*this.__alignment.row+sectionDimension_height*this.__alignment.rowspan/2}}__initNext(slaveTerminalGroup,subSlaves){const topology=this.__component.topology;if(null===topology)return;let nextTrace=this.__component.trace;(this.__isCableLink||this.__isEBus&&null===nextTrace)&&(nextTrace=topology.addTrace(),this.__nextTrace=nextTrace),null!==nextTrace?(this.__connection={outPort:this,inPort:null,state:PortStates.notInitialized},this.__configuredSlaveData&&(this.__isEBus||(slaveTerminalGroup=null),this.__nextSlave=new Commons.Slave(this.__configuredSlaveData,nextTrace,this.__connection,slaveTerminalGroup,subSlaves),topology.addPortToChronologicalPortList(this),this.__configuredComponent=this.__nextSlave)):TcHmi.Log.error("Unable to find or create trace.")}get pos(){return this.__pos}get configuredComponent(){return this.__configuredComponent}get nextSlave(){return this.__nextSlave}get nextTrace(){return this.__nextTrace}get offsetNextSlave(){const offset={x:0,y:0};return this.isCableLink&&(offset.x+=200),offset}get component(){return this.__component}get index(){return this.__index}get configured(){return this.__configured}get physic(){return this.__physic}get typeName(){return PortPhysic[this.__physic]}get redundancy(){return this.__redundancy}get redundancyPath(){return this.__redundancyPath}}Commons.Port=Port;class PortMaster extends Port{constructor(master,index,physic,connection,configuredSlaveData=null){super(master,index,{autoIncAddr:0,index:index,configured:!0,configuredSlave:configuredSlaveData,redundancy:!1,redundancyPath:!1,physic:physic},connection,null,[])}}Commons.PortMaster=PortMaster;let PortStates,PortPhysic,PortNames;Commons.PortSlave=class extends Port{constructor(slave,index,portData,connection,slaveTerminalGroup,subSlaves){super(slave,index,portData,connection,slaveTerminalGroup,subSlaves),this.__online={current:{unexpectedLink:{value:null,domElements:new Set},missingLink:{value:null,domElements:new Set},linkError:{value:null,domElements:new Set}},counter:{crc:{total:{value:null,domElements:new Set},errorOnPrevPort:{value:null,domElements:new Set}}},messages:{value:new Set,domElements:new Set}}}get online(){return this.__online}addMessage(localization,contentKeys,errorLevel){const el=document.createElement("div");switch(el.classList.add("slave-message"),errorLevel){case Commons.NotificationLevel.info:case Commons.NotificationLevel.success:break;case Commons.NotificationLevel.warning:el.classList.add("slave-message-warning");break;case Commons.NotificationLevel.error:el.classList.add("slave-message-error");break;default:TcHmi.Log.error("Invalid error level.")}for(const contentKey of contentKeys){const subEl=document.createElement("div");localization.addElement(subEl,contentKey),el.append(subEl)}this.__online.messages.value.add(el)}clearMessages(){this.__online.messages.value=new Set}updateMessages(){if(this.__online.messages.domElements?.size)for(const msgEl of this.__online.messages.domElements){msgEl.innerHTML="";for(const errEl of this.__online.messages.value)msgEl.appendChild(errEl)}}},function(PortStates){PortStates[PortStates.notInitialized=-1]="notInitialized",PortStates[PortStates.noError=0]="noError",PortStates[PortStates.notPresent=1]="notPresent",PortStates[PortStates.error=2]="error"}(PortStates=Commons.PortStates||(Commons.PortStates={})),function(PortPhysic){PortPhysic[PortPhysic.NONE=0]="NONE",PortPhysic[PortPhysic.MII=1]="MII",PortPhysic[PortPhysic.EBUS=3]="EBUS",PortPhysic[PortPhysic.FastHotConnect=4]="FastHotConnect"}(PortPhysic=Commons.PortPhysic||(Commons.PortPhysic={})),function(PortNames){PortNames[PortNames.A=0]="A",PortNames[PortNames.D=1]="D",PortNames[PortNames.B=2]="B",PortNames[PortNames.C=3]="C"}(PortNames=Commons.PortNames||(Commons.PortNames={}))}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class SlaveGroup extends Commons.Component{constructor(firstSlave){super(0),this.__grouped=!1,this.__subSlaves=[],this.__pos={networkTraceXOffset:0,network:{x:0,y:0}},this.__ports=[],this.__design={dimension:{width:100,height:400},color:{r:255,g:0,b:0},labelColor:"#000",labelHeight:0,interior:{offset:{x:0,y:0},dimension:{width:0,height:0},section:{cols:1,rows:1}}},this.__trace=firstSlave.trace,this.__subSlaves=[firstSlave]}get grouped(){return this.__grouped}group(){this.__grouped=!0}ungroup(){this.__grouped=!1}get subSlaves(){return this.__subSlaves}get numOfSubSlaves(){return this.__subSlaves.length}addSubSlave(slave){this.__subSlaves.push(slave)}get firstSubSlave(){return this.__subSlaves[0]}get trace(){return this.__trace}get topology(){return this.trace.topology}get network(){return this.topology.network}get master(){return this.network.master}get main(){return this.master.main}get name(){return"SlaveGroup"}set networkPos(value){this.__pos.network=value}get networkPos(){return this.__pos.network}get lastSubSlave(){return this.__subSlaves[this.__subSlaves.length-1]}get pos(){return this.__pos}get coordinates(){const traceCoordinates=this.trace.pos;return traceCoordinates?{col:traceCoordinates.col+this.__pos.networkTraceXOffset,row:traceCoordinates.row}:null}get hasForcedProcessData(){for(const slave of this.__subSlaves)if(slave.hasForcedProcessData)return!0;return!1}set startCoordinates(coordinates){throw new Error("Method not implemented.")}follow(xOffset){this.topology.componentOrder.push(this),this.__trace.height=this.__design.dimension.height,this.__pos.networkTraceXOffset=xOffset,xOffset+=this.__design.dimension.width,this.__trace.addWidth(xOffset),this.lastSubSlave.followPorts(xOffset)}}Commons.SlaveGroup=SlaveGroup;Commons.SlaveTerminalGroup=class extends SlaveGroup{constructor(firstSlave){super(firstSlave),firstSlave.trace.addSlaveTerminalGroup(this)}group(){this.__subSlaves.length>1&&super.group()}isSlaveGroup(){return this.numOfSubSlaves>1}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.SyncUnits=class{constructor(){this.__syncUnits=new Map}add(id,syncUnit){this.__syncUnits.set(id,syncUnit)}getAll(){return this.__syncUnits}get(id){return this.__syncUnits.get(id)}getOrCreate(id){let syncUnit=this.get(id);return syncUnit||(syncUnit={slaves:[],error:!1,faultCounter:0},this.add(id,syncUnit)),syncUnit}remove(id){this.__syncUnits.delete(id)}clear(){this.__syncUnits.clear()}addSlave(id,slave){this.getOrCreate(id).slaves.push(slave)}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class Layers extends HTMLElement{constructor(){super(),this.__translation=[{x:0,y:0}],this.__zoomLevel=1,this.__shift={x:0,y:0},this.__layers=new Map,this.classList.add("layer-wrapper"),this.__addLayer(LayerName.frame),this.__addLayer(LayerName.processData),this.__addLayer(LayerName.syncUnit),this.__addLayer(LayerName.text),this.__addLayer(LayerName.error),this.__addLayer(LayerName.hover)}connectedCallback(){this.resizeEvent()}get translation(){return this.__translation[0]}__addLayer(layerName){const canvas=document.createElement("canvas");this.append(canvas);const ctx=canvas.getContext("2d");ctx?this.__layers.set(layerName,ctx):TcHmi.Log.errorEx("Error while getting context of canvas.")}getCanvas(name){return this.__layers.get(name).canvas}getContext(name){return this.__layers.get(name)}resizeEvent(){const offsetWidth=this.offsetWidth,offsetHeight=this.offsetHeight,width=offsetWidth*window.devicePixelRatio,height=offsetHeight*window.devicePixelRatio;for(const ctx of this.__layers.values()){const canvas=ctx.canvas;canvas.width=width,canvas.height=height,canvas.style.width=`${offsetWidth}px`,canvas.style.height=`${offsetHeight}px`}}translateAll(x,y){this.__translation[0]={x:this.__translation[0].x+x,y:this.__translation[0].y+y};for(const ctx of this.__layers.values())ctx.translate(x,y)}setFocusedZoomAndShift(zoomLevel,shift){this.__zoomLevel=zoomLevel,this.__shift=shift,zoomLevel*=window.devicePixelRatio;for(const ctx of this.__layers.values())ctx.setTransform(zoomLevel,0,0,zoomLevel,shift.x,shift.y)}setFocusedShift(shift){this.setFocusedZoomAndShift(this.__zoomLevel,shift)}setFocusedZoom(zoomLevel){this.setFocusedZoomAndShift(zoomLevel,this.__shift)}setBackgroundZoom(zoomLevel){}showAllLayer(){for(const ctx of this.__layers.values())ctx.canvas.classList.remove("hide")}hideAllLayers(){for(const ctx of this.__layers.values()){const canvas=ctx.canvas;canvas.classList.add("hide"),ctx.save(),ctx.setTransform(1,0,0,1,0,0),ctx.clearRect(0,0,canvas.width,canvas.height),ctx.restore()}}setTransparency(transparency=1){for(const ctx of this.__layers.values())ctx.globalAlpha=transparency}saveContext(){this.__translation.unshift(this.__translation[0]);for(const ctx of this.__layers.values())ctx.save()}restoreContext(){this.__translation.shift();for(const ctx of this.__layers.values())ctx.restore()}erase(name){if(name)this.__eraseContext(this.getContext(name));else{this.__translation=[{x:0,y:0}];for(const ctx of this.__layers.values())this.__eraseContext(ctx)}}__eraseContext(ctx){const canvas=ctx.canvas;ctx.save(),ctx.setTransform(1,0,0,1,0,0),ctx.clearRect(0,0,canvas.width,canvas.height),ctx.restore()}destroy(){for(const ctx of this.__layers.values())ctx.canvas.remove();this.__layers.clear()}}let LayerName;Commons.Layers=Layers,customElements.define(Commons.customElementsPrefix+"drawing-layers",Layers),function(LayerName){LayerName[LayerName.frame=0]="frame",LayerName[LayerName.processData=1]="processData",LayerName[LayerName.text=2]="text",LayerName[LayerName.syncUnit=3]="syncUnit",LayerName[LayerName.error=4]="error",LayerName[LayerName.hover=5]="hover"}(LayerName=Commons.LayerName||(Commons.LayerName={}))}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){function getGlobalOffset(el){const clientRect=el.getBoundingClientRect();return{left:clientRect.left,top:clientRect.top}}Commons.getGlobalOffset=getGlobalOffset,Commons.getGlobalScroll=function(el){const scroll={x:0,y:0};for(;el&&(scroll.x-=el.scrollLeft,scroll.y-=el.scrollTop,"fixed"!==el.style.position);)el=el.parentElement;return scroll};class Drawing extends HTMLElement{constructor(master,view,dimension){super(),this.__tooltip=document.createElement(Commons.customElementsPrefix+"canvas-tooltip"),this.__translation=[{x:0,y:0}],this.__layerWrapper=document.createElement("div"),this.__pointerPos={down:null,move:null,hover:null},this.__lastTouchDistance=-1,this.__eventTargets=[],this.__canvasMargin={x:0,y:0},this.__dimension={initial:{width:0,height:0},zoomed:{width:0,height:0}},this.__shift={x:0,y:0},this.__zoomLevel=1,this.__zoomLevelLimits={max:2,min:0},this.__drawingInfo=document.createElement("div"),this.__absoluteMinZoomLevel=.01,this.__originPosition={x:0,y:0},this.__translatePositionStack=[],this.__master=master,this.__view=view,this.classList.add("drawing-wrapper"),dimension&&(this.style.width=`${dimension.width}px`,this.style.height=`${dimension.height}px`),this.__view===Commons.TopologyView.Network&&this.classList.add("network-view"),this.__focusedLayers=new Commons.Layers,this.append(this.__focusedLayers),this.__master.main.addTopMostLayer(this.__tooltip)}get focusedLayers(){return this.__focusedLayers}setInitialDimension(value){this.__dimension.initial=value,this.__calcZoomedDimension(),this.setZoomLevel(this.__zoomLevel,!1),this.__focusedLayers.setFocusedZoom(this.__zoomLevel)}__calcZoomedDimension(){this.__dimension.zoomed.width=this.__dimension.initial.width*this.__zoomLevel,this.__dimension.zoomed.height=this.__dimension.initial.height*this.__zoomLevel}initDrawing(){this.clearCanvas(),this.__applyZoomedDimension()}update(){this.__focusedLayers.erase(),this.clearCanvas()}__applyZoomedDimension(){this.__calcZoomedDimension()}addZoomLevel(zoomModification,checkLimits=!1){let newZoomLevel=0;void 0!==zoomModification&&(newZoomLevel=Math.max(this.__zoomLevel+zoomModification,this.__absoluteMinZoomLevel)),checkLimits&&(newZoomLevel=this.__zoomLevel<this.__zoomLevelLimits.min?zoomModification&&zoomModification<0?this.__zoomLevel:Math.min(newZoomLevel,this.__zoomLevelLimits.max):zoomModification&&zoomModification>0?this.__zoomLevel:Math.max(newZoomLevel,this.__zoomLevelLimits.min));const appliedRelZoomLevel=newZoomLevel-this.__zoomLevel;return this.setZoomLevel(newZoomLevel,!1),this.__showUpdatedViewInfo(),appliedRelZoomLevel}setZoomLevel(zoomLevel,checkLimits=!0){null===zoomLevel?zoomLevel=this.__zoomLevelLimits.min:(zoomLevel=Math.max(zoomLevel,this.__absoluteMinZoomLevel),checkLimits&&(this.__zoomLevelLimits.min>zoomLevel&&(zoomLevel=this.__zoomLevelLimits.min),this.__zoomLevelLimits.max<zoomLevel&&(zoomLevel=this.__zoomLevelLimits.max))),this.__focusedLayers.setFocusedZoom(zoomLevel),this.__zoomLevel=zoomLevel,this.__calcZoomedDimension()}__showUpdatedViewInfo(){this.__drawingInfo.dataset.timeout&&(this.__drawingInfo.textContent="",clearTimeout(parseInt(this.__drawingInfo.dataset.timeout,10)),delete this.__drawingInfo.dataset.timeout);const localizedInfo=this.__master.main.getLocalization().createLocalizedElement(`{{View_Updated.bold}} X: ${Math.round(this.__shift.x)}, Y: ${Math.round(this.__shift.y)}, {{Zoom}}: ${Math.round(100*this.__zoomLevel)} %`);this.__drawingInfo.append(localizedInfo),this.__drawingInfo.dataset.timeout=setTimeout((()=>{this.__drawingInfo.textContent="",delete this.__drawingInfo.dataset.timeout}),5e3).toString()}destroy(){this.__focusedLayers.destroy(),this.remove()}__findTargetByPosition(pos){const canvasGlobalOffset=getGlobalOffset(this.__focusedLayers.getCanvas(Commons.LayerName.frame)),canvasPos_x=canvasGlobalOffset.left,canvasPos_y=canvasGlobalOffset.top,pointerPos_x=pos.x,pointerPos_y=pos.y,relPos_x=(-this.__shift.x/window.devicePixelRatio+pointerPos_x-canvasPos_x+this.scrollLeft)/this.__zoomLevel,relPos_y=(-this.__shift.y/window.devicePixelRatio+pointerPos_y-canvasPos_y+this.scrollTop)/this.__zoomLevel;for(const eventTarget of this.__eventTargets.reverse())if(relPos_x>=eventTarget.x&&relPos_x<eventTarget.x+eventTarget.w&&relPos_y>=eventTarget.y&&relPos_y<eventTarget.y+eventTarget.h)return eventTarget;return null}__handleClick(e){const eventTarget=this.__findTargetByPosition({x:e.clientX,y:e.clientY});eventTarget&&eventTarget.primaryPointerFn&&eventTarget.primaryPointerFn()}__handleContextMenu(e){const eventTarget=this.__findTargetByPosition({x:e.clientX,y:e.clientY});eventTarget&&(eventTarget.secondaryPointerFn?(eventTarget.secondaryPointerFn(),e.preventDefault()):eventTarget.primaryPointerFn&&(eventTarget.primaryPointerFn(),e.preventDefault()))}__preventEvents(e){e.preventDefault&&e.preventDefault()}drawMaster(master,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const target=master.target,ctx=layers.getContext(Commons.LayerName.text),dimension=master.design.dimension;this.drawFrame(dimension,layers,!0);const availableDimension_height=400;ctx.font=`50px ${Commons.appearance.fontFamily}`,ctx.fillStyle=Commons.appearance.master.textColor.getRGBAString(),ctx.textAlign="left",ctx.textBaseline="top",ctx.fillText(target.name,20,availableDimension_height*(1/3)),this.drawStatusFlag(master,layers),ctx.beginPath();let adsText="Error";switch(target.sysServiceAdsState){case 5:adsText="Run",ctx.fillStyle=Commons.appearance.adsState.run.getRGBAString();break;case 15:adsText="Config",ctx.fillStyle=Commons.appearance.adsState.config.getRGBAString();break;default:ctx.fillStyle=Commons.appearance.adsState.error.getRGBAString(),adsText="Error"}ctx.fillRect(20,availableDimension_height*(2/3),50,50),ctx.fillText(adsText,100,availableDimension_height*(2/3))}drawSlave(slave,layers,drawingDimension){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const design=slave.design,ctxFrame=layers.getContext(Commons.LayerName.frame),slaveIsActive=slave.isPresent&&!slave.isDisabled;if(slaveIsActive){this.drawStatusFlag(slave,layers);const inputPort=slave.getPortByIndex(Commons.PortName.A);if(inputPort.isEBus&&inputPort.state===Commons.PortStates.error){const ctxError=layers.getContext(Commons.LayerName.error);ctxError.strokeStyle=Commons.appearance.port.EBus.error.border.color.getRGBAString(),ctxError.lineWidth=Commons.appearance.port.EBus.error.border.width,ctxError.beginPath(),ctxError.moveTo(0,0),ctxError.lineTo(0,design.dimension.height),ctxError.stroke()}if(slave.outgoingEBusPort&&slave.outgoingEBusPort.state===Commons.PortStates.error){const ctxError=layers.getContext(Commons.LayerName.error);ctxError.strokeStyle=Commons.appearance.port.EBus.error.border.color.getRGBAString(),ctxError.lineWidth=Commons.appearance.port.EBus.error.border.width,ctxError.beginPath(),ctxError.moveTo(design.dimension.width,0),ctxError.lineTo(design.dimension.width,design.dimension.height),ctxError.stroke()}this.drawErrorLabels(slave,layers)}let dimension=design.dimension;void 0!==drawingDimension&&(dimension=drawingDimension),this.drawFrame(dimension,layers,slaveIsActive,design.color);let labelWarningLevel=0;slave.hasInvalidIdentity&&(labelWarningLevel=2,(slave.hasInvalidIdentityBefore||slave.hasNotPresentSlavesBefore)&&(labelWarningLevel=1));const memberNameShort=slave.staticInfo.identity.vendor.memberNameShort.value,type=slave.staticInfo.identity.type.value;if(null===memberNameShort||null===type)return;const labelVendorText=memberNameShort.slice(0,8),labelPos={x:10,y:design.dimension.height-Commons.appearance.slave.label.height};this.drawLabel(labelPos,design,labelVendorText,type,labelWarningLevel,layers,slaveIsActive),ctxFrame.globalAlpha=1;for(const port of slave.cableLinkPorts)this.drawPort(port.pos.rel,!1,port.state,layers)}drawFrame(dimension,layers,componentIsActive,color){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.frame);ctx.beginPath(),ctx.rect(0,0,dimension.width,dimension.height),ctx.fillStyle=componentIsActive?Commons.appearance.slave.frame.bgColor.getRGBAString():Commons.appearance.slave.frame.bgColorDisabled.getRGBAString(),ctx.fill(),ctx.strokeStyle=Commons.appearance.slave.frame.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.slave.frame.border.width,ctx.stroke()}drawLabel(labelPos,design,manufacturer,type,warningLevel=0,layers,componentIsActive){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctxText=layers.getContext(Commons.LayerName.text),shortedType=Commons.Slave.getShortSlaveType(type);ctxText.beginPath(),ctxText.font=`18px ${Commons.appearance.fontFamily}`,ctxText.textAlign="left",ctxText.textBaseline="top",ctxText.fillStyle=(componentIsActive?Commons.appearance.slave.frame.bgColor:Commons.appearance.slave.frame.bgColorDisabled).getRGBAString(.7);switch(ctxText.fillRect(labelPos.x-4,labelPos.y-16,design.dimension.width-16,Commons.appearance.slave.label.height),ctxText.beginPath(),warningLevel){case 0:ctxText.fillStyle=Commons.appearance.slave.label.noError.textColor.getRGBAString();break;case 1:ctxText.fillStyle=Commons.appearance.slave.label.vprsWarning.textColor.getRGBAString();break;case 2:ctxText.fillStyle=Commons.appearance.slave.label.vprsError.textColor.getRGBAString();break;default:ctxText.fillStyle=Commons.appearance.msgLevel.fallback.getRGBAString(),TcHmi.Log.error("Unknown warning level while drawing slave label. For fallback reason we will draw the slave label black.")}ctxText.fillText(shortedType,labelPos.x,labelPos.y),ctxText.fillText(manufacturer,labelPos.x,labelPos.y+25)}drawErrorLabels(slave,layers){const labels=slave.onlineData.labels,dimension=slave.design.dimension,labelPos={x:0,y:dimension.height};for(const label of labels)this.__addEventTarget({relativePos:labelPos,dimension:{width:dimension.width,height:45},hoverText:label.text}),this.drawErrorLabel(label,labelPos,dimension.width,layers)}drawErrorLabel(label,labelPos,labelWidth,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.text);ctx.beginPath();let labelBgColor=Commons.ColorRGBA_Black,labelTextColor=Commons.ColorRGBA_White;switch(label.warningLevel){case 3:labelBgColor=Commons.appearance.slave.attachedLabel.error.bgColor,labelTextColor=Commons.appearance.slave.attachedLabel.error.textColor;break;case 2:labelBgColor=Commons.appearance.slave.attachedLabel.warning.bgColor,labelTextColor=Commons.appearance.slave.attachedLabel.warning.textColor}ctx.fillStyle=labelBgColor.getRGBAString(),ctx.fillRect(labelPos.x,labelPos.y,labelWidth,45);const centerPosOfLabel={x:labelPos.x+labelWidth/2,y:labelPos.y+22.5};ctx.fillStyle=labelTextColor.getRGBAString(),ctx.textBaseline="middle",ctx.textAlign="center";let fontSize=28,textFitIn=!1;for(;!textFitIn;)ctx.font=`${fontSize}px ${Commons.appearance.fontFamily}`,textFitIn=ctx.measureText(label.text).width<labelWidth-30,fontSize-=2;ctx.fillText(label.text,centerPosOfLabel.x,centerPosOfLabel.y),labelPos.y+=45}drawPort(pos,hotConnect=!1,state=0,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.frame);if(layers.saveContext(),layers.translateAll(pos.x,pos.y),ctx.beginPath(),2===state)ctx.strokeStyle=Commons.appearance.port.PHY.error.border.color.getRGBAString(),ctx.fillStyle=Commons.appearance.port.PHY.error.bgColor.getRGBAString(),ctx.lineWidth=Commons.appearance.port.PHY.error.border.width;else ctx.strokeStyle=Commons.appearance.port.PHY.noError.border.color.getRGBAString(),ctx.fillStyle=Commons.appearance.port.PHY.noError.bgColor.getRGBAString(),ctx.lineWidth=Commons.appearance.port.PHY.noError.border.width;ctx.rect(-Commons.appearance.port.PHY.dimension.width/2,-Commons.appearance.port.PHY.dimension.height/2,Commons.appearance.port.PHY.dimension.width,Commons.appearance.port.PHY.dimension.height),ctx.fill(),ctx.stroke(),layers.restoreContext()}__drawCurrentState(component,layers,state){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.text);if(null!=state){let componentWidth=100;component&&(componentWidth=component.design.dimension.width),ctx.beginPath();const stateMachineStateType=Commons.StateMachineStateType[state],stateMachineColor=Commons.appearance.stateMachine[stateMachineStateType]?.bgColor;ctx.fillStyle=stateMachineColor?stateMachineColor.getRGBAString():"black",ctx.strokeStyle=Commons.appearance.statusFlag.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.statusFlag.border.width;const flagPos={x:0,y:-Commons.appearance.statusFlag.height};ctx.rect(flagPos.x,flagPos.y,componentWidth,Commons.appearance.statusFlag.height),ctx.fill(),ctx.stroke(),this.__addEventTarget({relativePos:flagPos,dimension:{width:componentWidth,height:Commons.appearance.statusFlag.height},hoverText:"{{Statemachine}}: "+stateMachineStateType})}}__drawForcedState(component,layers,couplerGroup=!1){if(!couplerGroup&&!component.hasForcedProcessData||component instanceof Commons.Slave&&couplerGroup&&!component.couplerGroupHasForcedProcessData())return;if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const componentWidth=component.design.dimension.width,ctx=layers.getContext(Commons.LayerName.text);ctx.save(),ctx.beginPath();const center={x:componentWidth/2,y:-48};ctx.arc(center.x,center.y,18,0,2*Math.PI),ctx.fillStyle="rgb(230, 115, 0)",ctx.fill(),ctx.beginPath(),ctx.textAlign="center",ctx.textBaseline="middle",ctx.fillStyle="white",ctx.font=`18px ${Commons.appearance.fontFamily}`,ctx.fillText("F",center.x,center.y),ctx.restore();let componentType=component?.constructor.name;couplerGroup&&(componentType="CouplerGroup"),this.__addEventTarget({relativePos:{x:center.x-18,y:center.y-18},dimension:{width:36,height:36},hoverText:`{{Component_At_Least_One_Forced_Process_Data$${componentType}}}`})}drawStatusFlag(component,layers){let state=null;component instanceof Commons.Master?state=component.data.online.stateMachine.code.value:component instanceof Commons.Slave&&(state=component.data.online.current.stateMachine.code.value),null!==state&&this.__drawCurrentState(component,layers,state),this.__drawForcedState(component,layers)}clearCanvas(){this.__eventTargets=[]}__translateOrigin(layers,pos){this.__originPosition={x:this.__originPosition.x+pos.x,y:this.__originPosition.y+pos.y},this.__translatePositionStack.push(pos),layers.translateAll(pos.x,pos.y)}__revertOriginTranslation(layers){const revertPosition=this.__translatePositionStack.pop();revertPosition?(this.__originPosition={x:this.__originPosition.x-revertPosition.x,y:this.__originPosition.y-revertPosition.y},layers.translateAll(-revertPosition.x,-revertPosition.y)):TcHmi.Log.error("No translation to revert.")}__addEventTarget(value){const position={x:this.__originPosition.x,y:this.__originPosition.y};value.relativePos&&(position.x+=value.relativePos.x,position.y+=value.relativePos.y),this.__eventTargets.push({x:position.x,y:position.y,w:value.dimension.width,h:value.dimension.height,target:value.target,hoverText:value.hoverText,primaryPointerFn:value.primaryPointerFn,secondaryPointerFn:value.secondaryPointerFn})}__multilineText(ctx,pos,text,desiredFontSize,maxDimension){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const words=text.split(" ");let fontSize=desiredFontSize,wordMatrix=[];let fillWordsFailed=!1;for(;fontSize>4;){ctx.font=`${fontSize}px ${Commons.appearance.fontFamily}`;let rowWidth=0;fillWordsFailed=!1,wordMatrix=[""];for(const word of words){const wordWidth=ctx.measureText(word).width;if(rowWidth+wordWidth<=maxDimension.width)wordMatrix[wordMatrix.length-1]+=word+" ",rowWidth+=1+wordWidth;else{if((wordMatrix.length+1)*fontSize+30*(wordMatrix.length+1)>maxDimension.height){fillWordsFailed=!0;break}if(!(wordWidth<=maxDimension.width)){fillWordsFailed=!0;break}wordMatrix.push(word+""),rowWidth=wordWidth+1}}if(!fillWordsFailed)break;fontSize-=2}if(fillWordsFailed)return void TcHmi.Log.warn(`Text '${text}' does not fit into space with font size ${fontSize}.`);let rowOffset=0;for(const wordsOfRow of wordMatrix)ctx.fillText(wordsOfRow,pos.x,pos.y+rowOffset),rowOffset+=30}}Commons.Drawing=Drawing}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){let WheelDeltaMode;!function(WheelDeltaMode){WheelDeltaMode[WheelDeltaMode.DOM_DELTA_PIXEL=0]="DOM_DELTA_PIXEL",WheelDeltaMode[WheelDeltaMode.DOM_DELTA_LINE=1]="DOM_DELTA_LINE",WheelDeltaMode[WheelDeltaMode.DOM_DELTA_PAGE=2]="DOM_DELTA_PAGE"}(WheelDeltaMode=Commons.WheelDeltaMode||(Commons.WheelDeltaMode={}));class DrawingInteraction extends Commons.Drawing{constructor(master,view,dimension,redrawFn){super(master,view,dimension),this.__focused=!1,this.__userInteracted=!1,this.__zoomAndPan=!1,this.__activePointers=new Map,this.__obeyClick=!1,this.__handlePointerOver=e=>{this.__focused=!1;for(const path of e.composedPath())if(path===this){this.__focused=!0,this.__handleHover(e);break}},this.__handlePointerDown=e=>{e.preventDefault(),0===e.button&&(0===this.__activePointers.size&&(this.__obeyClick=!0,this.__pointerPos.down={x:e.clientX,y:e.clientY},this.__pointerPos.move={x:e.clientX,y:e.clientY}),this.__zoomAndPan&&!1!==this.__master.target.main.config.allowZoomAndPan&&(this.style.cursor="move"),this.__activePointers.set(e.pointerId,e))},this.__handlePointerMove=e=>{switch(this.__activePointers.size){case 0:this.__handlePointerUpMove(e);break;case 1:if(!this.__zoomAndPan)break;!1!==this.__master.target.main.config.allowZoomAndPan&&e.isPrimary&&(this.__handlePan(e),this.__pointerPos.move={x:e.clientX,y:e.clientY});break;case 2:if(this.__zoomAndPan&&!1!==this.__master.target.main.config.allowZoomAndPan){this.__obeyClick=!1;let movedPointer=null,staticPointer=null;for(const[activePointerId,activePointerEvent]of this.__activePointers)e.pointerId===activePointerId?movedPointer={x:activePointerEvent.clientX,y:activePointerEvent.clientY}:staticPointer={x:activePointerEvent.clientX,y:activePointerEvent.clientY};if(movedPointer&&staticPointer){const oldDistance=Commons.Vector.getVectorLength(movedPointer,staticPointer),modification=Commons.Vector.getVectorLength({x:e.clientX,y:e.clientY},staticPointer)-oldDistance,zoomPos=Commons.Vector.getCenter({x:e.clientX,y:e.clientY},staticPointer);this.__applyZoom(zoomPos,modification/200)}else TcHmi.Log.error("Moved pointer or static pointer does not exist.")}}this.__activePointers.has(e.pointerId)&&this.__activePointers.set(e.pointerId,e)},this.__handlePointerUp=e=>{e.preventDefault(),setTimeout((()=>{this.__activePointers.delete(e.pointerId),0===this.__activePointers.size&&(this.__pointerPos.down=null,this.__pointerPos.move=null,this.style.cursor="default",e.isPrimary&&this.__obeyClick&&0===e.button&&this.__handleClick(e))}),0)},this.__handlePointerUpMove=e=>{e.preventDefault(),this.__handleHover(e)},this.__handlePan=e=>{if(!this.__zoomAndPan)return;if(!this.__pointerPos.down||!this.__pointerPos.move)return;this.__userInteracted=!0;const currentPos_x=e.clientX,currentPos_y=e.clientY,movement={x:(currentPos_x-this.__pointerPos.move.x)*window.devicePixelRatio,y:(currentPos_y-this.__pointerPos.move.y)*window.devicePixelRatio};this.style.cursor="move",this.shiftCanvasRel({x:movement.x,y:movement.y}),this.__redrawFn&&this.__redrawFn(),this.__showUpdatedViewInfo();const movementSinceMouseDown_x=Math.abs(currentPos_x-this.__pointerPos.down.x)*window.devicePixelRatio,movementSinceMouseDown_y=Math.abs(currentPos_y-this.__pointerPos.down.y)*window.devicePixelRatio;(movementSinceMouseDown_x>10||movementSinceMouseDown_y>10)&&(this.__obeyClick=!1)},this.__handleWheel=mouseWheelEvent=>{this.__preventEvents(mouseWheelEvent),this.__userInteracted=!0;let zoomModification=-mouseWheelEvent.deltaY/2e3;mouseWheelEvent.deltaMode===WheelDeltaMode.DOM_DELTA_LINE&&(zoomModification=-mouseWheelEvent.deltaY/2e3*33);const zoomPos={x:mouseWheelEvent.pageX*window.devicePixelRatio,y:mouseWheelEvent.pageY*window.devicePixelRatio};this.__applyZoom(zoomPos,zoomModification)},this.__redrawFn=redrawFn,this.addEventListener("dragstart",(()=>!1)),this.addEventListener("pointerup",this.__handlePointerUp),this.addEventListener("pointerdown",this.__handlePointerDown),this.addEventListener("pointermove",this.__handlePointerMove),this.addEventListener("pointercancel",this.__handlePointerUp),this.addEventListener("pointerleave",this.__handlePointerUp),this.addEventListener("contextmenu",this.__handleContextMenu.bind(this)),this.addEventListener("pointerover",this.__handlePointerOver.bind(this)),this.addEventListener("pointerout",this.__handlePointerUp)}destroy(){this.removeEventListener("pointerup",this.__handlePointerUp),this.removeEventListener("pointerdown",this.__handlePointerDown),this.removeEventListener("pointermove",this.__handlePointerMove),this.removeEventListener("pointercancel",this.__handlePointerUp),this.removeEventListener("pointerleave",this.__handlePointerUp),this.removeEventListener("contextmenu",this.__handleContextMenu.bind(this)),this.removeEventListener("pointerover",this.__handlePointerOver.bind(this)),this.removeEventListener("pointerout",this.__handlePointerUp),this.removeEventListener("wheel",this.__handleWheel),this.remove(),super.destroy()}reload(){this.__redrawFn&&this.__redrawFn()}resetView(initTopologyViewPosX,initTopologyViewPosY,initTopologyViewZoom){this.setZoomLevel(initTopologyViewZoom,!1),this.__shiftCanvas({x:initTopologyViewPosX,y:initTopologyViewPosY}),this.__focusedLayers.setFocusedZoom(this.__zoomLevel),this.__focusedLayers.erase(),this.reload(),this.__userInteracted=!1,this.__showUpdatedViewInfo()}resizeEvent(callback){this.__focusedLayers.resizeEvent(),callback()}updateHover(e){this.__handleHover(e??null)}__handleHover(e){if(!this.__focused)return;if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const tooltip=this.__tooltip,ctx=this.__focusedLayers.getContext(Commons.LayerName.hover);if(this.__focusedLayers.erase(Commons.LayerName.hover),tooltip.hide(),e){e.preventDefault();const target={x:e.clientX,y:e.clientY};this.__pointerPos.hover={x:target.x,y:target.y}}else if(!this.__pointerPos.hover)return;if(!this.__pointerPos.down){const eventTarget=this.__findTargetByPosition(this.__pointerPos.hover);if(eventTarget){ctx.strokeStyle=Commons.appearance.hover.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.hover.border.width,ctx.strokeRect(eventTarget.x,eventTarget.y,eventTarget.w,eventTarget.h);const localization=this.__master.main.getLocalization();if(eventTarget.hoverText){const localizedHoverTextElement=localization.createLocalizedElement(eventTarget.hoverText,"span");tooltip.show(localizedHoverTextElement,this.__pointerPos.hover.x,this.__pointerPos.hover.y)}this.__pointerPos.move||(void 0===eventTarget.primaryPointerFn?this.style.cursor="default":this.style.cursor="pointer")}else this.__pointerPos.move||(this.style.cursor="default")}}shiftCanvasRelByZoomLevel(modification){const unzoomedModification_x=modification.x*this.__zoomLevel,unzoomedModification_y=modification.y*this.__zoomLevel;this.__shiftCanvas({x:this.__shift.x+unzoomedModification_x,y:this.__shift.y+unzoomedModification_y})}shiftCanvasRel(modification){this.__shiftCanvas({x:this.__shift.x+modification.x,y:this.__shift.y+modification.y})}__shiftCanvas(newShift){this.__shift=newShift,this.__focusedLayers.setFocusedShift(this.__shift)}addZoomAndPan(){this.__zoomAndPan=!0,!1!==this.__master.target.main.config.allowZoomAndPan&&this.__redrawFn&&this.addEventListener("wheel",this.__handleWheel)}preDrawingEvent(){if(!this.__userInteracted){this.calcZoomLevelLimits();const config=this.__master.main.config;this.__shiftCanvas({x:config.initTopologyViewPosX,y:config.initTopologyViewPosY}),config.initTopologyViewZoom?this.setZoomLevel(config.initTopologyViewZoom,!1):this.setZoomLevel(null)}}__calcZoomPositionCorrection(zoomPos,relativeZoomLevel){this.__userInteracted=!0;const frameOffset=Commons.getGlobalOffset(this),spacings_x=zoomPos.x-frameOffset.left-this.__shift.x,spacings_y=zoomPos.y-frameOffset.top-this.__shift.y;return{x:-spacings_x*((relativeZoomLevel=this.__zoomLevel/(this.__zoomLevel-relativeZoomLevel))-1),y:-spacings_y*(relativeZoomLevel-1)}}__applyZoom(position,modification){const appliedZoomModification=this.addZoomLevel(modification),relShift=this.__calcZoomPositionCorrection(position,appliedZoomModification);this.shiftCanvasRel(relShift),this.__focusedLayers.setFocusedZoom(this.__zoomLevel),this.__focusedLayers.erase(),this.__redrawFn&&this.__redrawFn()}calcZoomLevelLimits(){const parentElement=this.parentElement;if(!parentElement)return;const minWidthZoomLevel=parentElement.offsetWidth/this.__dimension.initial.width,minHeightZoomLevel=parentElement.offsetHeight/this.__dimension.initial.height;this.__zoomLevelLimits.min=minWidthZoomLevel<minHeightZoomLevel?minWidthZoomLevel:minHeightZoomLevel;const maxWidthZoomLevel=parentElement.offsetWidth/100,maxHeightZoomLevel=parentElement.offsetHeight/400;this.__zoomLevelLimits.max=maxWidthZoomLevel<maxHeightZoomLevel?maxWidthZoomLevel:maxHeightZoomLevel}}Commons.DrawingInteraction=DrawingInteraction}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.createElementAndAddText=function(elementType,content){const element=document.createElement(elementType);return element.textContent=content,element};class DrawingNetwork extends Commons.DrawingInteraction{constructor(network,redrawFn){super(network.master,Commons.TopologyView.Network,void 0,redrawFn),this.__network=network,super.addZoomAndPan(),this.classList.add("network-view");const toolbox=document.createElement("div");if(toolbox.classList.add("toolbox"),this.__master.target.main.config.allowZoomAndPan&&this.__master.target.main.config.toolboxResetView){const toolbox_centerBtn=document.createElement("button");toolbox_centerBtn.classList.add("toolbox-reset-view"),toolbox_centerBtn.addEventListener("click",(()=>{this.resetView()})),toolbox.append(toolbox_centerBtn)}this.__drawingInfo.classList.add("drawing-info"),this.prepend(toolbox,this.__drawingInfo)}disconnectedCallback(){this.__tooltip.remove()}get network(){return this.__network}initDrawing(){super.initDrawing(),this.preDrawingEvent()}resetView(){const config=this.__master.main.config;super.resetView(config.initTopologyViewPosX,config.initTopologyViewPosY,config.initTopologyViewZoom)}drawCableLinkConnectionOrientation(outputPort,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");layers.saveContext();const ctx=layers.getContext(Commons.LayerName.processData);ctx.lineWidth=15;const pos=outputPort.pos.rel,componentDimension=outputPort.component.design.dimension;if(ctx.beginPath(),!outputPort.connection?.inPort)return void TcHmi.Log.error("input port unknown");const ports={input:outputPort.connection.inPort,output:outputPort};ports.input.hotConnectGroupStart&&ctx.setLineDash([50,10]),ctx.moveTo(pos.x,pos.y);let posEnd={x:0,y:0};switch(outputPort.orientation){case Commons.PortOrientation.right:posEnd={x:-pos.x+componentDimension.width+100+50,y:pos.y};break;case Commons.PortOrientation.up:posEnd={x:pos.x,y:-pos.y-100};break;case Commons.PortOrientation.down:posEnd={x:pos.x,y:-pos.y+componentDimension.height+100};break;default:return void TcHmi.Log.error(`Invalid ouput-port orientation '${outputPort.orientation}' while drawing cableLinkConnectionOrientation.`)}const connectionState=Math.max(ports.input.state,ports.output.state);if(ctx.strokeStyle=this.__getConnectionOrientationGradient(ctx,pos,posEnd,connectionState),ctx.lineTo(posEnd.x,posEnd.y),ctx.stroke(),ports.output.redundancyPath){const gradRedundancy=ctx.createLinearGradient(pos.x,pos.y,posEnd.x,posEnd.y);gradRedundancy.addColorStop(0,Commons.ColorRGBA_White.getRGBAString(.7)),gradRedundancy.addColorStop(1,Commons.ColorRGBA_White.getRGBAString(.1)),ctx.strokeStyle=gradRedundancy,ctx.lineWidth=6,ctx.stroke()}layers.restoreContext()}drawCableLinkConnectionRedundancyOrientation(inputPort,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.processData);layers.saveContext(),ctx.lineWidth=15;const pos=inputPort.pos.network,component=inputPort.component,componentDimension=component.design.dimension;if(ctx.beginPath(),!inputPort.connection?.inPort)return void TcHmi.Log.error("input port unknown");const ports={input:inputPort,output:inputPort.connection.outPort};ports.input.hotConnectGroupStart&&ctx.setLineDash([50,10]),ctx.moveTo(pos.x,pos.y),ctx.lineTo(pos.x-50,pos.y);const posEnd={x:pos.x-50,y:0};switch(ports.output.orientation){case Commons.PortOrientation.right:posEnd.y=component.networkPos.y+componentDimension.height+100;break;case Commons.PortOrientation.up:posEnd.y=component.networkPos.y-100;break;case Commons.PortOrientation.down:posEnd.y=component.networkPos.y+componentDimension.height+100;break;default:TcHmi.Log.error(`Unknown output-port orientation '${ports.output.orientation}' while drawing CableLinkConnectionRedundancyOrientation.`)}const connectionState=Math.max(ports.input.state,ports.output.state);if(ctx.strokeStyle=this.__getConnectionOrientationGradient(ctx,pos,posEnd,connectionState),ctx.lineTo(posEnd.x,posEnd.y),ctx.stroke(),ports.output.redundancyPath){const gradRedundancy=ctx.createLinearGradient(pos.x,pos.y,posEnd.x,posEnd.y);gradRedundancy.addColorStop(0,"rgba(255, 255, 255, 0.7)"),gradRedundancy.addColorStop(1,"rgba(255, 255, 255, 0.1)"),ctx.strokeStyle=gradRedundancy,ctx.lineWidth=6,ctx.stroke()}layers.restoreContext()}__getConnectionOrientationGradient(ctx,posStart,posEnd,connectionState){const grad=ctx.createLinearGradient(posStart.x,posStart.y,posEnd.x,posEnd.y);if(!Commons.appearance)return TcHmi.Log.error("Appearance is null."),grad;switch(connectionState){case Commons.PortStates.notInitialized:case Commons.PortStates.notPresent:grad.addColorStop(0,Commons.appearance.cable.notPresent.strokeColor.getRGBAString(.5)),grad.addColorStop(1,Commons.appearance.cable.notPresent.strokeColor.getRGBAString(0));break;case Commons.PortStates.noError:grad.addColorStop(0,Commons.appearance.cable.noError.strokeColor.getRGBAString()),grad.addColorStop(1,Commons.appearance.cable.noError.strokeColor.getRGBAString(0));break;case Commons.PortStates.error:grad.addColorStop(0,Commons.appearance.cable.error.strokeColor.getRGBAString()),grad.addColorStop(1,Commons.appearance.cable.error.strokeColor.getRGBAString(0));break;default:TcHmi.Log.error(`Unknown connection state '${connectionState}'`)}return grad}drawCableLinkConnection(inputPort,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.processData);if(layers.saveContext(),inputPort&&inputPort.connection){inputPort.hotConnectGroupStart&&ctx.setLineDash([50,10]);const ports={input:inputPort,output:inputPort.connection.outPort},inputComponentPos=ports.input.component.networkPos,outputComponentPos=ports.output.component.networkPos,outputPortPos={x:outputComponentPos.x-inputComponentPos.x+ports.output.pos.rel.x,y:outputComponentPos.y-inputComponentPos.y+ports.output.pos.rel.y};ctx.lineWidth=15;const pos={input:ports.input.pos.rel,output:outputPortPos};ctx.beginPath(),ctx.moveTo(pos.output.x,pos.output.y),ports.output.orientation===Commons.PortOrientation.right?(ctx.lineTo(pos.output.x+100,pos.output.y),ctx.lineTo(pos.output.x+100,pos.input.y)):ctx.lineTo(pos.output.x,pos.input.y),ctx.lineTo(pos.input.x,pos.input.y);const connectionState=Math.max(ports.input.state,ports.output.state);switch(connectionState){case Commons.PortStates.notInitialized:case Commons.PortStates.notPresent:ctx.strokeStyle=Commons.appearance.cable.notPresent.strokeColor.getRGBAString();break;case Commons.PortStates.noError:ctx.strokeStyle=Commons.appearance.cable.noError.strokeColor.getRGBAString();break;case Commons.PortStates.error:const grad=ctx.createLinearGradient(pos.output.x,pos.output.y,pos.input.x,pos.input.y);grad.addColorStop(0,Commons.appearance.cable.error.strokeColor.getRGBAString()),grad.addColorStop(1,Commons.appearance.cable.error.strokeColor.getRGBAString(.1)),ctx.strokeStyle=grad;break;default:TcHmi.Log.error(`Invalid connection state ${connectionState}`)}ctx.stroke(),ports.output.redundancyPath&&(ctx.strokeStyle="rgba(255, 255, 255, 0.7)",ctx.lineWidth=6,ctx.stroke())}layers.restoreContext()}drawCableLinkConnectionRedundancy(inputPort,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");layers.saveContext();const ctx=layers.getContext(Commons.LayerName.processData);if(inputPort&&inputPort.connection){const ports={input:inputPort,output:inputPort.connection.outPort};if(!ports.input)return;if(ctx.lineWidth=15,ports.output.component instanceof Commons.Slave){const outputSlave=ports.output.component;if(outputSlave.visibility){const pos={input:ports.input.pos.network,output:ports.output.pos.network},rowHeight=outputSlave.trace?.pos?.row.height;if(!rowHeight)return void TcHmi.Log.error("unable to get row height");ctx.beginPath(),ctx.moveTo(pos.output.x,pos.output.y);let rowLineY=pos.output.y;switch(ports.output.orientation){case Commons.PortOrientation.right:const behindComponentX=outputSlave.networkPos.x+outputSlave.design.dimension.width+50;ctx.lineTo(behindComponentX,pos.output.y),rowLineY=ports.output.component.networkPos.y+rowHeight+100,ctx.lineTo(behindComponentX,rowLineY),ctx.lineTo(pos.input.x-50,rowLineY),ctx.lineTo(pos.input.x-50,pos.input.y);break;case Commons.PortOrientation.up:rowLineY=ports.output.component.networkPos.y-150,ctx.lineTo(pos.output.x,rowLineY),ctx.lineTo(pos.input.x-50,rowLineY),ctx.lineTo(pos.input.x-50,pos.input.y);break;case Commons.PortOrientation.down:rowLineY=ports.output.component.networkPos.y+rowHeight+100,ctx.lineTo(pos.output.x,rowLineY),ctx.lineTo(pos.input.x-50,rowLineY),ctx.lineTo(pos.input.x-50,pos.input.y);break;default:TcHmi.Log.error(`Invalid output-port-orientation '${ports.output.orientation}' while drawing CableLinkConnectionRedundancy.`)}ctx.lineTo(pos.input.x,pos.input.y);const connectionState=Math.max(ports.input.state,ports.output.state);switch(connectionState){case Commons.PortStates.notInitialized:case Commons.PortStates.notPresent:ctx.strokeStyle=Commons.appearance.cable.notPresent.strokeColor.getRGBAString();break;case Commons.PortStates.noError:ctx.strokeStyle=Commons.appearance.cable.noError.strokeColor.getRGBAString();break;case Commons.PortStates.error:const grad=ctx.createLinearGradient(pos.output.x,pos.output.y,pos.input.x,pos.input.y);grad.addColorStop(0,Commons.appearance.cable.error.strokeColor.getRGBAString()),grad.addColorStop(1,Commons.appearance.cable.error.strokeColor.getRGBAString(.1)),ctx.strokeStyle="#FF0000",ctx.strokeStyle=grad;break;default:TcHmi.Log.error(`Invalid connection state '${connectionState}'.`)}ctx.stroke(),ctx.strokeStyle="rgba(255, 255, 255, 0.7)",ctx.lineWidth=6,ctx.stroke()}else this.drawCableLinkConnectionRedundancyOrientation(inputPort,layers)}}layers.restoreContext()}drawComponent(component,layers){component instanceof Commons.Slave?this.drawSlave(component,layers):component instanceof Commons.Master?this.drawMaster(component,layers):component instanceof Commons.SlaveTerminalGroup&&this.drawSlaveTerminalGroup(component,layers)}drawSlave(slave,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");layers.saveContext(),this.__translateOrigin(layers,slave.networkPos);const dimension=slave.design.dimension;let drawingDimension;(slave.numOfOutgoingConfiguredCableLinkPorts>0||slave.hasOutgoingConfiguredEBusPort)&&!slave.expansion&&(drawingDimension={width:dimension.width+100,height:dimension.height}),super.drawSlave(slave,layers,drawingDimension);let contextMenuFn,hoverText=slave.name;if(slave.numOfCableLinkPorts>0)(slave.numOfOutgoingConfiguredCableLinkPorts>0||slave.hasOutgoingConfiguredEBusPort)&&(contextMenuFn=()=>{this.__userInteracted=!0,slave.toggleExpansion(),slave.network.recalcNetwork(slave)},slave.numOfSubSlaves>0&&(slave.expansion?hoverText+="{{Tooltip_Slave_Pointer_Secondary_Interaction_Collapse_Ports_Of_Coupler.margin-top-20}}":hoverText+="{{Tooltip_Slave_Pointer_Secondary_Interaction_Expand_Ports_Of_Coupler.margin-top-20}}"));else{const slaveTerminalGroup=slave.slaveTerminalGroup;if(!slaveTerminalGroup)return;contextMenuFn=()=>{this.__userInteracted=!0,slaveTerminalGroup.group(),slave.network.recalcNetwork(slave)},hoverText+="{{Tooltip_Slave_Pointer_Secondary_Interaction_Collapse_EBus_Group.margin-top-20}}"}this.__addEventTarget({dimension:dimension,target:slave,hoverText:hoverText,primaryPointerFn:function(){slave.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(slave))},secondaryPointerFn:contextMenuFn}),0===slave.pos.networkTraceXOffset&&this.__drawTraceFlag(slave,{x:-5,y:-120},layers);const inputPort=slave.ports[0];if(inputPort.isCableLink&&this.drawCableLinkConnection(inputPort,layers),!slave.expansion){for(const port of slave.outgoingConfiguredCableLinkPorts)port.redundancy||this.drawCableLinkConnectionOrientation(port,layers);this.drawSlaveCouplerGroup(slave,layers)}const selectedSyncUnitId=this.__master.selectedSyncUnit,slaveSyncUnits=slave.syncUnitIds;if(null!=selectedSyncUnitId&&slaveSyncUnits&&slaveSyncUnits.includes(selectedSyncUnitId)){const ctx=layers.getContext(Commons.LayerName.syncUnit),syncUnitOnline=slave.data.online.syncUnits.get(selectedSyncUnitId);syncUnitOnline?syncUnitOnline.error.value?(ctx.strokeStyle=Commons.appearance.slave.syncUnitHighlight.error.frame.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.slave.syncUnitHighlight.error.frame.border.width):syncUnitOnline.faultCounter&&syncUnitOnline.faultCounter.value&&syncUnitOnline.faultCounter.value>0?(ctx.strokeStyle=Commons.appearance.slave.syncUnitHighlight.warning.frame.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.slave.syncUnitHighlight.warning.frame.border.width):(ctx.strokeStyle=Commons.appearance.slave.syncUnitHighlight.noError.frame.border.color.getRGBAString(),ctx.lineWidth=Commons.appearance.slave.syncUnitHighlight.noError.frame.border.width):ctx.strokeStyle="black",ctx.strokeRect(0,0,dimension.width,dimension.height)}this.__revertOriginTranslation(layers),layers.restoreContext()}__drawTraceFlag(slave,traceLabelPos,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const trace=slave.trace,ctxText=layers.getContext(Commons.LayerName.text);ctxText.font=`40px ${Commons.appearance.fontFamily}`;let text=slave.name,hoverText="";const hasGroupedSlaves=trace.hasGroupedSlaves();slave.expansion&&trace.hasSlaveTerminalGroups()&&(!0===hasGroupedSlaves?(text=" + "+text,hoverText=`{{Tooltip_Trace_Pointer_Primary_Interaction_Expand_EBus_Groups$${slave.name}}}`):!1===hasGroupedSlaves&&(text=" - "+text,hoverText=`{{Tooltip_Trace_Pointer_Primary_Interaction_Collapse_EBus_Groups$${slave.name}}}`));const labelDimension={width:ctxText.measureText(text).width+40,height:58},traceLabelBgPos={x:traceLabelPos.x,y:traceLabelPos.y-10},slaveHeight=slave.design.dimension.height,ctxTraceLabelBg=layers.getContext(Commons.LayerName.text);if(ctxTraceLabelBg.beginPath(),ctxTraceLabelBg.fillStyle=Commons.appearance.trace.label.bgColor.getRGBAString(),ctxTraceLabelBg.clearRect(traceLabelBgPos.x-50,traceLabelBgPos.y,500,labelDimension.height+2),ctxText.clearRect(traceLabelBgPos.x-50,traceLabelBgPos.y,500,labelDimension.height+2),ctxTraceLabelBg.lineWidth=4,ctxTraceLabelBg.rect(traceLabelBgPos.x,traceLabelBgPos.y,labelDimension.width,labelDimension.height),ctxTraceLabelBg.fill(),ctxTraceLabelBg.beginPath(),ctxTraceLabelBg.moveTo(traceLabelBgPos.x+ctxTraceLabelBg.lineWidth/2,traceLabelBgPos.y),ctxTraceLabelBg.lineTo(traceLabelBgPos.x+ctxTraceLabelBg.lineWidth/2,slaveHeight),ctxTraceLabelBg.stroke(),null!==hasGroupedSlaves){const clkfn=()=>{this.__userInteracted=!0;const trace=slave.trace;trace.toggleSlaveTerminalGroups(),trace.network.recalcNetwork()};this.__addEventTarget({relativePos:traceLabelBgPos,dimension:labelDimension,target:slave,hoverText:hoverText,primaryPointerFn:clkfn})}if(ctxText.textBaseline="top",ctxText.fillStyle=Commons.appearance.trace.label.textColor.getRGBAString(),ctxText.fillText(text,traceLabelPos.x+20,traceLabelPos.y),slave.data.EtherCAT.hotConnect.isHotConnectHead){ctxTraceLabelBg.beginPath(),ctxTraceLabelBg.fillStyle=Commons.appearance.trace.label.bgColor.getRGBAString();const pos={x:-78,y:slaveHeight-70},dimension={width:73,height:70};ctxTraceLabelBg.rect(pos.x,pos.y,dimension.width,dimension.height),ctxTraceLabelBg.fill(),ctxText.fillStyle=Commons.appearance.trace.label.textColor.getRGBAString(),ctxText.fillText("HC",-70,slaveHeight-52),this.__addEventTarget({relativePos:pos,dimension:dimension,hoverText:"{{Tooltip_Start_Of_Hot_Connect_Group}}"})}}drawSlaveCouplerGroup(coupler,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const dimension=Commons.appearance.slaveCouplerGroup.dimension;this.__translateOrigin(layers,{x:coupler.design.dimension.width,y:0}),this.__addEventTarget({dimension:dimension,target:coupler,hoverText:`{{Tooltip_Coupler_Group_Primary_Interaction_Expand$${coupler.name}}}`,primaryPointerFn:()=>{this.__userInteracted=!0,coupler.toggleExpansion(),coupler.network.recalcNetwork(coupler)}});const ctxText=layers.getContext(Commons.LayerName.text),textPos={x:dimension.width/2,y:dimension.height/3};ctxText.fillStyle=Commons.appearance.slaveCouplerGroup.label.textColor.getRGBAString(),layers.saveContext(),ctxText.textAlign="center",ctxText.font=`60px ${Commons.appearance.fontFamily}`,ctxText.fillText(`${coupler.numOfSubSlaves}`,textPos.x,textPos.y),textPos.y+=70;const textMoreSlaves=this.__master.main.getLocalization().getLocalizedText("Slave_Group_More_Slaves");this.__multilineText(ctxText,textPos,textMoreSlaves,22,{width:dimension.width,height:200}),layers.restoreContext();let state=9;for(const subSlave of coupler.subSlaves){const stateValue=subSlave.onlineData.current.stateMachine.code.value;null!==stateValue&&(state=Math.min(state,stateValue))}9!==state&&this.__drawCurrentState(coupler,layers,state),this.__drawForcedState(coupler,layers,!0),this.__revertOriginTranslation(layers)}drawSlaveTerminalGroup(slaveTerminalGroup,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const pos=slaveTerminalGroup.networkPos;this.__translateOrigin(layers,pos);const ctxText=layers.getContext(Commons.LayerName.text),traceXOffset=slaveTerminalGroup.pos.networkTraceXOffset,dimension=Commons.appearance.slaveTerminalGroup.dimension;this.__addEventTarget({dimension:dimension,target:slaveTerminalGroup,hoverText:"{{Tooltip_EBus_Group_Primary_Interaction_Expand}}",primaryPointerFn:()=>{this.__userInteracted=!0,slaveTerminalGroup.ungroup(),slaveTerminalGroup.network.recalcNetwork()}}),this.drawFrame(dimension,layers,!0);const textPos={x:dimension.width/2,y:dimension.height/3};ctxText.fillStyle=Commons.appearance.slaveTerminalGroup.label.textColor.getRGBAString(),layers.saveContext(),ctxText.textBaseline="top",ctxText.textAlign="center",ctxText.font=`60px ${Commons.appearance.fontFamily}`,ctxText.fillText(`${slaveTerminalGroup.numOfSubSlaves}`,textPos.x,textPos.y),textPos.y+=70;const textMoreSlaves=this.__master.main.getLocalization().getLocalizedText("Slave_Group_More_Slaves");if(this.__multilineText(ctxText,textPos,textMoreSlaves,22,{width:dimension.width,height:200}),layers.restoreContext(),0===traceXOffset){const traceLabelPos={x:-5,y:-120},slave=slaveTerminalGroup.firstSubSlave;this.__drawTraceFlag(slave,traceLabelPos,layers)}let state=9,isSlaveNotPresent=!1,crcSumOfSubSlaves=0,crcHighestWarningLevel=0;for(const subSlave of slaveTerminalGroup.subSlaves){const stateValue=subSlave.onlineData.current.stateMachine.code.value;if(null===stateValue)continue;state=Math.min(state,stateValue),!isSlaveNotPresent&&subSlave.isNotPresent&&(isSlaveNotPresent=!0);const subSlaveCrcSum=subSlave.crcSum;subSlaveCrcSum&&(crcSumOfSubSlaves+=subSlaveCrcSum,subSlave.crcHighestWarningLevel&&(crcHighestWarningLevel=Math.max(subSlave.crcHighestWarningLevel,crcHighestWarningLevel)))}if(crcSumOfSubSlaves>0){const label={text:crcSumOfSubSlaves.toString(),warningLevel:crcHighestWarningLevel},labelPosition={x:0,y:dimension.height};this.drawErrorLabel(label,labelPosition,dimension.width,layers)}9!==state&&this.__drawCurrentState(slaveTerminalGroup,layers,state),this.__drawForcedState(slaveTerminalGroup,layers),this.__revertOriginTranslation(layers)}drawMaster(master,layers){this.__translateOrigin(layers,master.networkPos),super.drawMaster(master,layers),this.__addMasterEventTarget(master,layers),this.drawMasterFlag(master,layers),this.drawMasterPort(master,layers),this.__revertOriginTranslation(layers),this.drawMasterRedundancyPort(master,layers)}__addMasterEventTarget(master,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=layers.getContext(Commons.LayerName.text);ctx.font=`40px ${Commons.appearance.fontFamily}`,ctx.textBaseline="top";let hoverText=`{{Target}}: ${master.target.name}<br />\n                            {{Master}}: ${master.name}`;this.network.isExpand?hoverText+="{{Tooltip_Master_Pointer_Secondary_Interaction_Collapse_Ports_Of_All.margin-top-20}}":hoverText+="{{Tooltip_Master_Pointer_Secondary_Interaction_Expand_Ports_Of_All.margin-top-20}}";const dimension=master.design.dimension;this.__addEventTarget({dimension:dimension,target:master,hoverText:hoverText,primaryPointerFn:()=>{master.setExtendedInfoOfMaster(new Commons.ExtendedInfoOfMaster(master))},secondaryPointerFn:()=>{this.__userInteracted=!0,master.network.toggleExpansion()}})}drawMasterPort(master,layers){const firstPort=master.ports[1];firstPort&&firstPort.isCableLink&&this.drawPort(firstPort.pos.rel,!1,0,layers)}drawMasterRedundancyPort(master,layers){const redundancyPort=master.ports[0];redundancyPort&&redundancyPort.isCableLink&&(this.drawPort(redundancyPort.pos.network,!1,0,layers),this.drawCableLinkConnectionRedundancy(redundancyPort,layers))}drawMasterFlag(master,layers){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const traceLabelPos_x=0,traceLabelPos_y=-120;let labelName=master.name,masterHasGroupedSlaves=null;if(this.__master.topology?.traces){masterHasGroupedSlaves=this.__master.topology.hasGroupedSlaves();labelName=`${masterHasGroupedSlaves?"+":"-"} ${labelName}`}else labelName=`${labelName}`;const ctx=layers.getContext(Commons.LayerName.text),dimension=master.design.dimension,labelDimension={width:ctx.measureText(labelName).width+40,height:58};if(ctx.font=`40px ${Commons.appearance.fontFamily}`,ctx.textBaseline="top",ctx.beginPath(),ctx.textAlign="left",ctx.fillStyle=Commons.appearance.trace.label.bgColor.getRGBAString(),ctx.rect(traceLabelPos_x,traceLabelPos_y-10,5,labelDimension.height+70+dimension.height),ctx.rect(traceLabelPos_x,traceLabelPos_y-10,labelDimension.width,labelDimension.height),this.__master.topology?.traces){let hoverText="{{Tooltip_Master_Pointer_Primary_Interaction_Collapse_EBus_Groups_Of_All_Traces}}",primaryPointerFn=()=>{this.__master.topology?.groupAllTerminalGroups(),this.__network.recalcNetwork()};masterHasGroupedSlaves&&(hoverText="{{Tooltip_Master_Pointer_Primary_Interaction_Expand_EBus_Groups_Of_All_Traces}}",primaryPointerFn=()=>{this.__master.topology?.ungroupAllTerminalGroups(),this.__network.recalcNetwork()}),this.__addEventTarget({relativePos:{x:traceLabelPos_x,y:traceLabelPos_y-10},dimension:labelDimension,target:master,hoverText:hoverText,primaryPointerFn:primaryPointerFn})}ctx.fill(),ctx.fillStyle=Commons.appearance.trace.label.textColor.getRGBAString(),ctx.fillText(labelName,traceLabelPos_x+20,traceLabelPos_y)}}Commons.DrawingNetwork=DrawingNetwork,customElements.define(Commons.customElementsPrefix+"drawing-network",DrawingNetwork)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class DrawingTrace extends Commons.DrawingInteraction{constructor(trace){super(trace.master,Commons.TopologyView.Trace),this.__trace=trace}disconnectedCallback(){this.__tooltip.remove()}drawSlave(slave,layers){const pos={x:slave.pos.traceXOffset,y:100};this.__translateOrigin(layers,pos),super.drawSlave(slave,layers);const dimension=slave.design.dimension;this.__addEventTarget({dimension:dimension,target:slave,primaryPointerFn:()=>{slave.master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(slave))}}),this.__revertOriginTranslation(layers)}update(){super.update();for(const traceSlave of this.__trace.slaves)this.drawSlave(traceSlave,this.__focusedLayers)}}Commons.DrawingTrace=DrawingTrace,customElements.define(Commons.customElementsPrefix+"drawing-trace",DrawingTrace)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.DrawingSlaveSettings={scale:.6,padding:{x:100,y:70}};class DrawingSlave extends Commons.DrawingInteraction{constructor(slave){const drawingDimension={width:(2*Commons.DrawingSlaveSettings.padding.x+slave.design.dimension.width)*Commons.DrawingSlaveSettings.scale,height:(2*Commons.DrawingSlaveSettings.padding.y+slave.design.dimension.height)*Commons.DrawingSlaveSettings.scale};super(slave.master,Commons.TopologyView.Slave,drawingDimension),this.__initSetTimeout=0,this.__zoomLevel=Commons.DrawingSlaveSettings.scale,this.__slave=slave}connectedCallback(){this.initDrawing(),this.__initSetTimeout=setTimeout((()=>{const drawingDimension={width:2*Commons.DrawingSlaveSettings.padding.x+this.__slave.design.dimension.width,height:2*Commons.DrawingSlaveSettings.padding.y+this.__slave.design.dimension.height};this.setInitialDimension(drawingDimension),this.drawSlave()}),0)}disconnectedCallback(){this.__tooltip.remove(),clearTimeout(this.__initSetTimeout),this.__initSetTimeout=0}setInitialDimension(dimension){super.setInitialDimension(dimension)}drawSlave(){const layers=this.__focusedLayers;this.__translateOrigin(layers,Commons.DrawingSlaveSettings.padding),super.drawSlave(this.__slave,layers),this.__drawPortLabels(),this.__revertOriginTranslation(layers)}update(){super.update(),this.drawSlave()}__drawPortLabels(){if(!Commons.appearance)return void TcHmi.Log.error("Appearance is null.");const ctx=this.__focusedLayers.getContext(Commons.LayerName.processData),ports=this.__slave.ports,slaveWidth=this.__slave.design.dimension.width;for(const port of ports)if(port.exists){const labelSize=50;let crcLabelColor=Commons.appearance.port.label.warning.bgColor;const crc=port.online.counter.crc,portPosAbs={x:port.pos.rel.x,y:port.pos.rel.y};let labelPosAbs={x:0,y:0};labelPosAbs=port.index===Commons.PortName.A?{x:-50,y:portPosAbs.y}:{x:slaveWidth+50,y:portPosAbs.y};let labelColor=Commons.appearance.msgLevel.disabled;port.configured&&port.state!==Commons.PortStates.notPresent&&(labelColor=Commons.appearance.port.label.success.bgColor),crc.total.value&&(ctx.beginPath(),crcLabelColor=Commons.appearance.port.label.error.bgColor,labelColor=Commons.appearance.port.label.error.bgColor,crc.errorOnPrevPort.value&&(crcLabelColor=Commons.appearance.port.label.warning.bgColor,labelColor=Commons.appearance.port.label.warning.bgColor)),port.state===Commons.PortStates.error&&(labelColor=Commons.appearance.port.label.error.bgColor),ctx.strokeStyle=ctx.fillStyle=labelColor.getRGBAString();let clkFn,strokeOffset=labelSize/2;port.index===Commons.PortName.A&&(strokeOffset=-strokeOffset),ctx.lineWidth=2,ctx.moveTo(portPosAbs.x,portPosAbs.y),ctx.lineTo(labelPosAbs.x-strokeOffset,labelPosAbs.y),ctx.stroke(),ctx.beginPath(),ctx.fillRect(labelPosAbs.x-labelSize/2,labelPosAbs.y-labelSize/2,labelSize,labelSize);let hoverText=`{{Port_Name$${Commons.PortName[port.index]}}}`,configuredComponent=port.configuredComponent;if(port.redundancy&&(configuredComponent=this.__master,hoverText+=" ({{Redundancy}})"),configuredComponent){if(configuredComponent instanceof Commons.Master){const configuredMaster=configuredComponent;hoverText+=`<br /> <br />{{Tooltip_Port_Label_Pointer_Primary_Interaction_To_Connected_Master$${configuredMaster.name}}}`,clkFn=()=>{this.__master.setExtendedInfoOfMaster(new Commons.ExtendedInfoOfMaster(configuredMaster))}}else if(configuredComponent instanceof Commons.Slave){const configuredSlave=configuredComponent;hoverText+=`<br /><br />{{Tooltip_Port_Label_Pointer_Primary_Interaction_To_Connected_Slave$${configuredSlave.name}}}`,clkFn=()=>{this.__master.setExtendedInfoOfSlave(new Commons.ExtendedInfoOfSlave(configuredSlave))}}}else hoverText+=" ({{Port_Not_Connected}})";this.__addEventTarget({relativePos:{x:labelPosAbs.x-labelSize/2,y:labelPosAbs.y-labelSize/2},dimension:{width:labelSize,height:labelSize},hoverText:hoverText,primaryPointerFn:clkFn});const labelLeftBottomPos={x:labelPosAbs.x-labelSize/2,y:labelPosAbs.y+labelSize/2-10};if(crc.total.value&&(ctx.fillStyle=crcLabelColor.getRGBAString(),ctx.fillRect(labelLeftBottomPos.x,labelLeftBottomPos.y,labelSize,25)),ctx.fillStyle="white",ctx.textAlign="center",ctx.textBaseline="middle",ctx.font=`20px ${Commons.appearance.fontFamily}`,ctx.fillText(Commons.PortName[port.index],labelPosAbs.x,labelPosAbs.y),crc.total.value){const subLabelCenterPos={x:labelPosAbs.x,y:labelLeftBottomPos.y+12};ctx.fillStyle="white",ctx.textAlign="center",ctx.textBaseline="middle";let fontSize=16,textFitIn=!1;for(;!textFitIn;)ctx.font=`${fontSize}px ${Commons.appearance.fontFamily}`,textFitIn=ctx.measureText(crc.total.value.toString()).width<labelSize-5,fontSize-=2;ctx.fillText(crc.total.value.toString(),subLabelCenterPos.x,subLabelCenterPos.y)}}}}Commons.DrawingSlave=DrawingSlave,customElements.define(Commons.customElementsPrefix+"drawing-slave",DrawingSlave)}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class ExtendedInfo{constructor(master,component){this.__popUp=null,this.__popup=null,this.__master=master,this.__component=component,this.__tabName=this.__master.getExtendedInfoTabName(this.__component)}__open(popUp){this.__popUp=popUp,this.__master.main.addPopUp(popUp)}destroy(){this.__popUp?.remove(),this.__popUp?.close(),this.__popUp=null,this.__popup?.content?.remove(),this.__popup=null,this.__master.target.main.getLocalization().cleanUp()}close(){this.destroy()}get popup(){return this.__popup}}Commons.ExtendedInfo=ExtendedInfo;class ExtendedInfoOfMaster extends ExtendedInfo{constructor(master){super(master,"Master"),this.__masterContentTabs=null,this.__open(),this.createSlaveList(),this.__master.updateMasterOnlineInfo(null),this.__master.updateSlavesOnlineInfo(null)}destroy(){super.destroy(),this.__masterContentTabs?.remove(),this.__masterContentTabs=null,this.__master.removeExtendedInfoOfMaster(this),Commons.removeGarbageElements("ExtendedInfoOfMaster")}__open(){const content=this.__master.main.getTemplate("popup-master"),localization=this.__master.target.main.getLocalization();if(!content)return void TcHmi.Log.error("Content is not defined");if(this.__masterContentTabs=content.querySelector("tchmi-content-tabs"),!this.__masterContentTabs)return void TcHmi.Log.warn("Element 'tchmi-content-tabs' not found");this.__masterContentTabs.addTabChangeCallback((tabName=>{this.__master.setExtendedInfoTabName("Master",tabName)})),this.__tabName&&this.__masterContentTabs.openTab(this.__tabName);const target=this.__master.target;content.querySelector(".target-name").textContent=target.name,content.querySelector(".target-netId").textContent=target.netId,content.querySelector(".master-name").textContent=this.__master.name,content.querySelector(".master-netId").textContent=this.__master.netId;const firstComponent=this.__master.ports[1]?.configuredComponent;if(firstComponent instanceof Commons.Slave){const btn=document.createElement("span");btn.classList.add("navigation-link"),firstComponent.name&&(btn.innerHTML=firstComponent.name),btn.addEventListener("click",(()=>{this.__master.setExtendedInfoOfSlave(new ExtendedInfoOfSlave(firstComponent))})),content.querySelector(".master-first-port").append(btn)}const redundancyComponent=this.__master.ports[0]?.configuredComponent;if(redundancyComponent instanceof Commons.Slave){const btn=document.createElement("span");btn.classList.add("navigation-link"),redundancyComponent.name&&(btn.innerHTML=redundancyComponent.name),btn.addEventListener("click",(()=>{this.__master.setExtendedInfoOfSlave(new ExtendedInfoOfSlave(redundancyComponent))})),content.querySelector(".master-redundancy-port").append(btn)}else content.querySelector(".master-redundancy-port").innerHTML="No redundancy slave configured";const masterSetStateValue=content.querySelector('[name="master-setState-value"]'),masterSetStateBtn=content.querySelector('[name="master-setState-btn"]');masterSetStateValue&&masterSetStateBtn&&masterSetStateBtn.addEventListener("click",(()=>{parseInt(masterSetStateValue.value,10)&&this.__master.target.main.comObj?.writeSymbol(`${Commons.extensionName}.SetMasterStateMachine`,{device:this.__master.main.config.device,state:parseInt(masterSetStateValue.value,10)},(()=>{masterSetStateValue.value="0"}))}));const onlineData=this.__master.data.online;Commons.addDomElement("ExtendedInfoOfMaster",onlineData.stateMachine.name,content.querySelector(".master-currentState-name")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.stateMachineRequested.name,content.querySelector(".master-requestedState-name")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.total.cyclic,content.querySelector(".sendFrames-cyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.total.acyclic,content.querySelector(".sendFrames-acyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.perSec.cyclic,content.querySelector(".framesPerSec-cyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.perSec.acyclic,content.querySelector(".framesPerSec-acyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.missed.cyclic,content.querySelector(".lostFrames-cyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.missed.acyclic,content.querySelector(".lostFrames-acyclic")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.damaged.sent,content.querySelector(".damagedFrames-sent")),Commons.addDomElement("ExtendedInfoOfMaster",onlineData.frames.damaged.received,content.querySelector(".damagedFrames-received"));const content_slaveList=content.querySelector('[name="slave-list"]');if(!content_slaveList)return void TcHmi.Log.warn('Element [tab="slave-list"] not found.');const slaveListView=new Commons.SlaveListView(this.__master,localization);content_slaveList.append(slaveListView);const content_syncunit=content.querySelector('[name="syncunits"]');if(!content_syncunit)return void TcHmi.Log.warnEx('Element [tab="syncunits"] not found.');const content_syncunit_list=content_syncunit.querySelector("tbody.syncunit-list");if(!content_syncunit_list)return void TcHmi.Log.warnEx("Element tbody.syncunit-list not found.");const syncUnits=this.__master.syncUnits.getAll(),selectedSyncUnit=this.__master.selectedSyncUnit,noSyncUnit=content_syncunit_list.querySelector("input.no-sync-unit");if(!noSyncUnit)return void TcHmi.Log.warnEx("Element input.no-sync-unit not found.");noSyncUnit.addEventListener("change",(()=>{this.__master.selectedSyncUnit=null,this.__master.network.drawMatrix()})),null===selectedSyncUnit&&(noSyncUnit.checked=!0);let syncUnitIndex=0;for(const[syncUnitId,syncUnit]of syncUnits.entries()){{const row_syncUnit=document.createElement("tr"),radioButton=document.createElement("input");radioButton.setAttribute("type","radio"),radioButton.setAttribute("name","selectSyncUnit"),radioButton.setAttribute("id",`syncunitname${syncUnitIndex}`),null!=selectedSyncUnit&&selectedSyncUnit===syncUnitId&&radioButton.setAttribute("checked","checked");const selectSyncUnitFn=()=>{this.__master.selectedSyncUnit=syncUnitId,this.__master.network.drawMatrix()},col_radioButton=document.createElement("td");col_radioButton.appendChild(radioButton),radioButton.addEventListener("change",selectSyncUnitFn);const col_name=document.createElement("label");col_name.style.display="table-cell";const syncUnitName=document.createElement("span");syncUnitName.classList.add("bold"),col_name.setAttribute("for",`syncunitname${syncUnitIndex}`),localization.addElement(syncUnitName,"Sync_Unit_Name",[syncUnitIndex]);const syncUnitSlavesCount=document.createElement("span");syncUnitSlavesCount.classList.add("round-brackets"),localization.addElement(syncUnitSlavesCount,"Sync_Unit_Slaves_Count",[syncUnit.slaves.length]),col_name.append(syncUnitName,syncUnitSlavesCount);const col_wcFaultCounter=document.createElement("td"),col_framesMissedCount=document.createElement("td");row_syncUnit.append(col_radioButton,col_name,col_wcFaultCounter,col_framesMissedCount),content_syncunit_list.appendChild(row_syncUnit)}for(const slave of syncUnit.slaves){const row_slave=document.createElement("tr"),col_radioButton=document.createElement("td"),col_name=document.createElement("td"),col_wcFaultCounter=document.createElement("td");col_wcFaultCounter.classList.add("error-value","text-align-right");const col_framesMissedCount=document.createElement("td");col_framesMissedCount.classList.add("error-value","text-align-right"),col_name.textContent=slave.name,col_wcFaultCounter.textContent="0",row_slave.appendChild(col_radioButton),row_slave.appendChild(col_name),row_slave.appendChild(col_wcFaultCounter),row_slave.appendChild(col_framesMissedCount),content_syncunit_list.appendChild(row_slave),Commons.addDomElement("ExtendedInfoOfMaster",slave.onlineData.syncUnits.get(syncUnitId)?.faultCounter,col_wcFaultCounter),Commons.addDomElement("ExtendedInfoOfMaster",slave.onlineData.syncUnits.get(syncUnitId)?.framesMissedCount,col_framesMissedCount)}syncUnitIndex++}content.querySelector(".master-netId").textContent=this.__master.netId,content.setTitle(localization,"Master_View_Title"),super.__open(content)}updateDrawings(){return!0}createSlaveList(){const firstSlave=this.__master.ports[1].nextSlave;if(!firstSlave)return;const container=document.querySelector(".slave-list");if(!container)return;if(!this.__popUp)return;const slavesContent=this.__popUp.querySelector('.tab-content[name="slaves"]');slavesContent&&(slavesContent.appendChild(container),firstSlave instanceof Commons.Slave&&this.__slaveListRecursive(firstSlave,0,container))}__slaveListRecursive(slave,treeDepth,container){const row=document.createElement("tr");row.setAttribute("tree-depth",`${treeDepth}`);const nameEl=document.createElement("td");nameEl.textContent=slave.name,nameEl.style.marginLeft=20*treeDepth+"px";const typeEl=document.createElement("td");typeEl.textContent=`${slave.staticInfo.identity.type.value}`,row.append(nameEl,typeEl),container.append(row);let hasSubTree=!1;const ebusPort=slave.outgoingConfiguredEBusPort;for(const port of slave.cableLinkPorts){const nextSlave=port.nextSlave;nextSlave&&(ebusPort?(hasSubTree=!0,this.__slaveListRecursive(nextSlave,treeDepth+1,container)):this.__slaveListRecursive(nextSlave,treeDepth,container))}if(ebusPort){const nextSlave=ebusPort.nextSlave;nextSlave&&(slave.hasIncomingCableLinkPort?(hasSubTree=!0,this.__slaveListRecursive(nextSlave,treeDepth+1,container)):this.__slaveListRecursive(nextSlave,treeDepth,container))}hasSubTree?(nameEl.addEventListener("click",(()=>{nameEl.classList.toggle("arrow-3");let nextSibling=row.nextElementSibling;for(;nextSibling;){const currentSibling=nextSibling,currentSibling_treeDepth=parseInt(currentSibling.getAttribute("tree-depth"),10);if(treeDepth>=currentSibling_treeDepth)break;if(currentSibling.classList.toggle("hide"),nextSibling=currentSibling.nextElementSibling,!nextSibling)break}})),nameEl.classList.add("arrow")):nameEl.classList.add("arrow-placeholder")}}Commons.ExtendedInfoOfMaster=ExtendedInfoOfMaster;class ExtendedInfoOfSlave extends ExtendedInfo{constructor(slave){super(slave.master,"Slave"),this.__slaveDrawing=null,this.__traceDrawing=null,this.__slaveContentTabs=null,this.__slave=slave,this.__open()}destroy(){super.destroy(),this.__master.removeExtendedInfoOfSlave(this),this.__slaveContentTabs?.remove(),this.__slaveContentTabs=null,this.__popup?.content?.remove(),this.__popup=null,this.__slaveDrawing?.destroy(),this.__slaveDrawing=null,this.__traceDrawing?.destroy(),this.__traceDrawing=null,Commons.removeGarbageElements("ExtendedInfoOfSlave"),this.__master.target.main.getLocalization().cleanUp()}__open(){const content=this.__slave.main.getTemplate("popup-slave"),localization=this.__master.target.main.getLocalization();if(this.__slaveContentTabs=content.querySelector("tchmi-content-tabs"),!this.__slaveContentTabs)return void TcHmi.Log.warn("Element 'tchmi-content-tabs' not found");if(this.__slaveContentTabs.addTabChangeCallback((tabName=>{this.__master.setExtendedInfoTabName("Slave",tabName)})),this.__tabName&&this.__slaveContentTabs.openTab(this.__tabName),!content)return void TcHmi.Log.warn("Template 'popup-slave' was not found.");content.setTitle(localization,"Slave_View_Title"),this.__popup={content:content},super.__open(content);const traceTable=content.querySelector(".trace-table");if(!traceTable)return void TcHmi.Log.warn("Element with class .trace-table does not exist.");const traceTable_head=traceTable.querySelector(".head");if(!traceTable_head)return void TcHmi.Log.warn("Element with class .head does not exist.");const traceTable_content=traceTable.querySelector(".content");if(!traceTable_content)return void TcHmi.Log.warn("Element with class .content does not exist.");const traceDrawingWrapper=content.querySelector(".trace-drawing-wrap");if(!traceDrawingWrapper)return void TcHmi.Log.warn("Element with class .trace-drawing-wrap does not exist.");const traceTableRows=[{name:"slaveName",contentKey:"Slave_View_EtherCAT_General_Name",static:!0},{name:"abnormalChanges",contentKey:"Slave_Abnormal_State_Changes",static:!1},{name:"connectionLosses",contentKey:"Slave_Connection_Losses",static:!1},{name:"crc",contentKey:"Slave_CRC_Error",sub:["A","D","B","C"],static:!1}];for(const row of traceTableRows){const headCell=document.createElement("div");headCell.setAttribute("row",row.name);const headCellContent=document.createElement("span");if(localization.addElement(headCellContent,row.contentKey),headCell.append(headCellContent),traceTable_head.append(headCell),row.sub)for(let subRowIndex=0;subRowIndex<row.sub.length;subRowIndex++){const subRow=row.sub[subRowIndex],headCell_sub=document.createElement("div");headCell_sub.textContent=subRow,0===subRowIndex?(headCell_sub.style.float="right",headCell.prepend(headCell_sub)):(headCell_sub.style.textAlign="right",traceTable_head.append(headCell_sub))}}const trace=this.__slave.trace;if(trace){const traceScale=.5,traceDimension={width:trace.dimension.width,height:trace.dimension.height};traceDimension.height+=200,traceDrawingWrapper.style.width=traceDimension.width*traceScale+"px",traceDrawingWrapper.style.height=traceDimension.height*traceScale+"px",traceDrawingWrapper.style.position="absolute",this.__traceDrawing=new Commons.DrawingTrace(trace),traceDrawingWrapper.append(this.__traceDrawing),this.__traceDrawing.setInitialDimension(traceDimension),this.__traceDrawing.setZoomLevel(traceScale),this.__traceDrawing.initDrawing(),traceTable_head.style.paddingTop=traceDimension.height*traceScale+"px",this.__traceDrawing.update();for(const traceSlave of trace.slaves){const cellWidth=traceSlave.design.dimension.width*traceScale,col=document.createElement("div");col.classList.add("col"),col.style.minWidth=`${cellWidth}px`,col.style.maxWidth=`${cellWidth}px`,col.style.paddingTop=traceDimension.height*traceScale+"px",col.addEventListener("click",(()=>{this.close(),traceSlave.master.setExtendedInfoOfSlave(new ExtendedInfoOfSlave(traceSlave))}));const index=this.__slave.index;traceSlave.index===index&&col.classList.add("trace-slave-highlight");for(const row of traceTableRows)if(row.sub)for(let subRowIndex=0;subRowIndex<row.sub.length;subRowIndex++){const port=traceSlave.getPortByIndex(subRowIndex),cell=document.createElement("div");cell.setAttribute("row",row.name),cell.textContent="-",cell.classList.add("error-value","no-value"),col.appendChild(cell),!1===row.static&&Commons.addDomElement("ExtendedInfoOfSlave",port.online.counter[row.name]?.total,cell)}else{const cell=document.createElement("div");if(cell.setAttribute("row",row.name),cell.textContent="-","remainingCurrent"===row.name){const remainingCurrent=traceSlave.remainingCurrent;remainingCurrent&&(cell.textContent=remainingCurrent.toString(),remainingCurrent<0&&cell.classList.add("error"))}else if("slaveName"===row.name){cell.classList.add("justify-content-center"),cell.textContent="";const label=document.createElement("div");label.classList.add("trace-table-slave-name"),label.textContent=traceSlave.name,cell.appendChild(label)}else cell.classList.add("error-value","no-value");col.appendChild(cell),!1===row.static&&Commons.addDomElement("ExtendedInfoOfSlave",traceSlave.onlineData.counter[row.name],cell)}traceTable_content.appendChild(col)}const slaveNameElements=document.querySelectorAll('[row="slaveName"]');let reqHeight=0;for(const el of slaveNameElements)el.offsetHeight>reqHeight&&(reqHeight=el.offsetHeight);for(const el of slaveNameElements)el.style.height=`${reqHeight}px`}const slaveEtherCAT=this.__slave.data.EtherCAT,slaveView=content.querySelector(".slave-view");if(!slaveView)return void TcHmi.Log.warn("Element '.slave-view' not found.");const slaveName=slaveView.querySelector(".name");if(!slaveName)return void TcHmi.Log.warn("Element '.name' not found.");const slaveViewContent=slaveView.querySelector("tchmi-tab-contents");if(!slaveViewContent)return void TcHmi.Log.warn("slaveViewContent: Element 'tchmi-tab-contents' not found.");if(!slaveViewContent)return;Commons.addDomElement("ExtendedInfoOfSlave",this.__slave.onlineData.messages,slaveView.querySelector(".text-msg"));const contentEtherCAT_table=slaveViewContent.querySelector('[name="EtherCAT"]')?.querySelector("table");contentEtherCAT_table&&(Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.name,contentEtherCAT_table.querySelector(".name")),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.type,contentEtherCAT_table.querySelector(".type")),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.vendor.memberNameLong,contentEtherCAT_table.querySelector(".memberName")),contentEtherCAT_table.querySelector(".EtherCAT-addr").innerHTML=slaveEtherCAT.identity.addrs.phys.toString(),contentEtherCAT_table.querySelector(".auto-inc-addr").innerHTML=slaveEtherCAT.identity.addrs.autoInc.toString(),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.vendor.id,contentEtherCAT_table.querySelector(".vendor")),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.product,contentEtherCAT_table.querySelector(".product")),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.revision,contentEtherCAT_table.querySelector(".revision")),Commons.addDomElement("ExtendedInfoOfSlave",slaveEtherCAT.identity.serial,contentEtherCAT_table.querySelector(".serial")));const onlineData=this.__slave.onlineData,contentOnline=slaveViewContent.querySelector('[name="online"]');if(!contentOnline)return void TcHmi.Log.warn('Element [tab="online"] not found.');Commons.addDomElement("ExtendedInfoOfSlave",onlineData.current.stateMachine.name,contentOnline.querySelector(".currentState")),Commons.addDomElement("ExtendedInfoOfSlave",onlineData.counter.abnormalChanges,contentOnline.querySelector(".abnormalChanges")),Commons.addDomElement("ExtendedInfoOfSlave",onlineData.counter.connectionLosses,contentOnline.querySelector(".connectionLosses"));const elPorts=slaveViewContent.querySelector('[name="ports"]');if(!elPorts)return void TcHmi.Log.warn("Element '.ports' not found.");elPorts.classList.add("online-values");for(const port of this.__slave.ports)if(port.physic!==Commons.PortPhysic.NONE){let configuredComponent=port.configuredComponent;const elPort=document.createElement("div");elPort.classList.add("port");{const portTitle=document.createElement("div");portTitle.classList.add("port-title"),portTitle.setAttribute("colspan","2");const portName=document.createElement("span");if(portName.classList.add("port-name"),portTitle.append(portName),localization.addElement(portName,"Port_Name",[Commons.PortName[port.index]]),port.redundancy){const labelRedundancyPort=document.createElement("span");labelRedundancyPort.classList.add("round-brackets"),portTitle.append(labelRedundancyPort),localization.addElement(labelRedundancyPort,"Port_Redundancy"),configuredComponent=port?.connection?.inPort?.component??null}else if(port.configured){const labelPortConfigured=document.createElement("span");labelPortConfigured.classList.add("round-brackets"),portTitle.append(labelPortConfigured),localization.addElement(labelPortConfigured,"Port_Configured")}else if(configuredComponent instanceof Commons.Master){const labelPortFirstInNetwork=document.createElement("span");labelPortFirstInNetwork.classList.add("round-brackets"),portTitle.append(labelPortFirstInNetwork),localization.addElement(labelPortFirstInNetwork,"Port_First_In_Network")}else{const labelPortNotConfigured=document.createElement("span");labelPortNotConfigured.classList.add("round-brackets"),portTitle.append(labelPortNotConfigured),localization.addElement(labelPortNotConfigured,"Port_Not_Configured"),elPort.classList.add("not-connected")}elPort.append(portTitle)}{const row=document.createElement("div");row.classList.add("row"),row.classList.add("errorMessage"),Commons.addDomElement("ExtendedInfoOfSlave",port.online.messages,row),elPort.appendChild(row)}{const row=document.createElement("div");row.classList.add("row");const portTypeLabel=document.createElement("div");localization.addElement(portTypeLabel,"Port_Type");const portType=document.createElement("div");portType.textContent=port.typeName,row.append(portTypeLabel,portType),elPort.appendChild(row)}if(configuredComponent){const row=document.createElement("div");row.classList.add("row");const configuredComponentLabel=document.createElement("div"),cell=document.createElement("div");if(cell.classList.add("navigation-link"),cell.innerHTML=configuredComponent.name,configuredComponent instanceof Commons.Slave){const configuredSlave=configuredComponent;localization.addElement(configuredComponentLabel,"Port_Configured_Slave"),cell.addEventListener("click",(()=>{this.__master.setExtendedInfoOfSlave(new ExtendedInfoOfSlave(configuredSlave))}))}else if(configuredComponent instanceof Commons.Master){const configuredMaster=configuredComponent;localization.addElement(configuredComponentLabel,"Port_Configured_Master"),cell.addEventListener("click",(()=>{this.__master.setExtendedInfoOfMaster(new ExtendedInfoOfMaster(configuredMaster))}))}row.append(configuredComponentLabel,cell),elPort.append(row)}{const row=document.createElement("div");row.classList.add("row");const crcErrorLabel=document.createElement("div");localization.addElement(crcErrorLabel,"Slave_CRC_Error");const elCrcValue=document.createElement("div");Commons.addDomElement("ExtendedInfoOfSlave",port.online.counter.crc.total,elCrcValue),elCrcValue.classList.add("error-value","no-value"),elCrcValue.textContent="-",row.append(crcErrorLabel,elCrcValue),elPort.append(row)}document.createElement("td").textContent=port.typeName,elPorts.append(elPort)}const processDataView=new Commons.ProcessDataView(this.__slave,localization);slaveView.append(processDataView);const slaveDrawingWrapper=slaveView.querySelector(".slave-drawing-wrapper");slaveDrawingWrapper&&(this.__slaveDrawing=new Commons.DrawingSlave(this.__slave),slaveDrawingWrapper.append(this.__slaveDrawing)),slaveName.textContent=slaveEtherCAT.identity.name.value,this.__master.updateMasterOnlineInfo(null),this.__master.updateSlavesOnlineInfo(null)}updateDrawings(){return!(!this.__traceDrawing||!this.__slaveDrawing)&&(this.__traceDrawing.update(),this.__slaveDrawing.update(),!0)}}Commons.ExtendedInfoOfSlave=ExtendedInfoOfSlave}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){class Utility{static getRandomInt(max){return Math.floor(Math.random()*Math.floor(max))}static selectContainsOptionValue(select,value){const options=select.options,length=options.length;for(let i=0;i<length;i++)if(options[i].value===value)return!0;return!1}static isDataComplex(val){return(Array.isArray(val)||"object"==typeof val)&&null!==val}static compareObjectsRecursion(oldObj,newObj,changes){for(const key in newObj){const n=newObj[key],ncomplex="object"==typeof n&&null!==n;if(void 0===oldObj||!ncomplex&&oldObj[key]!==n)changes[key]=ncomplex?JSON.parse(JSON.stringify(n)):n;else if(ncomplex){let tmp;tmp=Array.isArray(n)?[]:{},Utility.compareObjectsRecursion(oldObj[key],n,tmp)&&(changes[key]=tmp)}}for(const k in changes)if(changes.hasOwnProperty(k))return changes;return!1}static compareObjects(oldObj,newObj){const changes={};return Utility.compareObjectsRecursion(oldObj,newObj,changes),changes}static baseConverter(num,baseFrom,baseTo){return parseInt(num,baseFrom).toString(baseTo)}static fillStringToLength(character,numOfCharacters,stringToFillUp){return(character.repeat(numOfCharacters)+stringToFillUp).substr(-numOfCharacters)}static removeNotConnectedDomElements(domElements){for(const domElement of domElements.keys())domElement.isConnected||domElements.delete(domElement)}static toHexString(dec){return(dec<0?"-":"")+"0x"+Math.abs(dec).toString(16)}}Commons.Utility=Utility;class Vector{static getDirectionalVector(p1,p2){return{x:p2.x-p1.x,y:p2.y-p1.y}}static getVectorLength(p1,p2){return p2&&(p1=Vector.getDirectionalVector(p1,p2)),Math.sqrt(Math.pow(p1.x,2)+Math.pow(p1.y,2))}static getCenter(p1,p2){return Vector.sumVector(p1,Vector.scalarProduct(.5,Vector.getDirectionalVector(p1,p2)))}static scalarProduct(scalar,p){return{x:scalar*p.x,y:scalar*p.y}}static sumVector(p1,p2){return{x:p1.x+p2.x,y:p1.y+p2.y}}}Commons.Vector=Vector}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.DrawUtility=class{static createCanvasLayers(parentEl,numberOfLayers){const layers=[];for(let layerIndex=0;layerIndex<numberOfLayers;layerIndex++){const canvas=document.createElement("canvas");canvas.setAttribute("width","800px"),canvas.setAttribute("height","1000px"),canvas.classList.add("layer");const ctx=canvas.getContext("2d");null!==ctx?(layers.push({canvas:canvas,ctx:ctx}),parentEl.appendChild(canvas)):TcHmi.Log.error("canvas.getContext('2d') returned null")}return layers}static drawGrid(ctx,numberOfRows,numberOfCols,gridSpacing){ctx.beginPath(),ctx.strokeStyle="#ddd";for(let rowIndex=0;rowIndex<numberOfRows+1;rowIndex++)ctx.moveTo(rowIndex*gridSpacing,0),ctx.lineTo(rowIndex*gridSpacing,numberOfCols*gridSpacing);for(let colIndex=0;colIndex<numberOfCols+1;colIndex++)ctx.moveTo(0,colIndex*gridSpacing),ctx.lineTo(numberOfRows*gridSpacing,colIndex*gridSpacing);ctx.stroke()}static drawComponent(ctx,colIndex,rowIndex,width,height,size){ctx.beginPath(),ctx.fillStyle="#fff",ctx.strokeStyle="#ccc",ctx.lineWidth=.5,ctx.fillRect(colIndex*size,rowIndex*size,width*size,height*size),ctx.strokeRect(colIndex*size,rowIndex*size,width*size,height*size)}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(EcDiagnostics){!function(Commons){Commons.Notifications=class{constructor(destinationElement){this.__notifications=new Map,this.__wrapper=document.createElement("div"),this.__wrapper.classList.add("notifications-wrapper"),destinationElement.appendChild(this.__wrapper)}resetNotification(key){}clearAllNotifications(){for(const note of this.__notifications.values())this.__removeNotification(note)}clearNotifications(category,level){if(void 0===category)this.clearAllNotifications();else{const notification=this.__notifications.get(category);notification&&this.__removeNotification(notification)}}__removeNotification(notification){clearInterval(notification.timeout),notification.element.remove(),this.__checkForDuplicatedNotifications()}setNotificationElement(el,level,category,displayTime){}setNotification(content,level,category,displayTime){let element,notification=this.__notifications.get(category);notification&&this.__removeNotification(notification),content instanceof HTMLElement?element=content:(element=document.createElement("div"),element.innerHTML=`${content}`),element.classList.add("notifications-wrapper-category"),element.classList.add("notifications-wrapper-"+Commons.NotificationLevel[level]),notification={element:element,timeout:void 0},notification.element.classList.add("notifications-wrapper-category"),notification.element.classList.add("notifications-wrapper-"+Commons.NotificationLevel[level]),this.__wrapper.appendChild(notification.element),displayTime&&(notification.timeout=setTimeout((()=>{notification&&(notification.element.remove(),this.__checkForDuplicatedNotifications())}),displayTime)),this.__notifications.set(category,notification),this.__checkForDuplicatedNotifications()}__checkForDuplicatedNotifications(){const compareNotes=[];for(const note of this.__notifications.values()){let hide=!1;for(const compareNote of compareNotes)if(compareNote===note.element.innerHTML){hide=!0;break}hide?note.element.style.display="none":note.element.style.removeProperty("display"),compareNotes.push(note.element.innerHTML)}}create(key,localization,params={}){const msg=document.createElement("span");switch(key){case"target-available-now":localization.addElement(msg,"Msg_Target_Available_Now",[`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.info,Commons.NotificationCategory.task);break;case"target-not-available":localization.addElement(msg,"Msg_Target_Not_Available",[`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.error,Commons.NotificationCategory.task);break;case"target-no-longer-available":localization.addElement(msg,"Msg_Target_No_Longer_Available",[`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.error,Commons.NotificationCategory.task);break;case"waiting-for-target-availability":localization.addElement(msg,"Msg_Target_Waiting_For_Availability",[`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.info,Commons.NotificationCategory.task);break;case"master-found":localization.addElement(msg,"Msg_Master_Found",[`<b>${params.master.name}</b> (${params.master.netId})`,`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.info,Commons.NotificationCategory.task);break;case"master-not-found":localization.addElement(msg,"Msg_Master_Not_Found",[`<b>${params.master.netId}</b>`,`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.error,Commons.NotificationCategory.task);break;case"init-network-view":localization.addElement(msg,"Msg_Network_View_Init",[`<b>${params.master.name}</b> (${params.master.netId})`,`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.info,Commons.NotificationCategory.task);break;case"sucessfully-display-network-view":localization.addElement(msg,"Msg_Network_View_Loaded",[`<b>${params.master.name}</b> (${params.master.netId})`,`<b>${params.target.name}</b> (${params.target.netId})`]),this.setNotification(msg,Commons.NotificationLevel.success,Commons.NotificationCategory.task,4e3);break;default:TcHmi.Log.error(`Unknown notification key '${key}'.`)}}}}(EcDiagnostics.Commons||(EcDiagnostics.Commons={}))}(EcDiagnostics||(EcDiagnostics={})),function(TcHmi){!function(Controls){!function(Beckhoff){!function(TcHmiEcDiagnosticsClasses){class ControlCommunication extends EcDiagnostics.Commons.Communication{constructor(ecDiagnostics){super(ecDiagnostics),this.__subscriptionIds=new Set}subscribe(commands,interval,tickCallback,initCallback){Array.isArray(commands)||(commands=[commands]);for(const command of commands)command.commandOptions=["SendErrorMessage","SendWriteValue"];const subscriptionCallback={cmdGroup:commands.length>1,tickCallback:tickCallback,initCallback:initCallback,errorEl:void 0},id=TcHmi.Server.subscribe(commands,interval,(resultObject=>{resultObject.response?super.processReadValues(subscriptionCallback,resultObject.response):TcHmi.Log.errorEx("ResultObject contains invalid response.")}));return null===id?(TcHmi.Log.errorEx("Subscription returned with invalid subscription id 'null'. Unable to subscribe to symbols:",commands),null):(this.__subscriptionIds.add(id),id)}unsubscribe(subscriptionId,callback){if(null!=subscriptionId){const unsubscribeId=TcHmi.Server.unsubscribe(subscriptionId,(data=>{callback&&callback(data)}));return this.__subscriptionIds.delete(subscriptionId),unsubscribeId}return null}unsubscribeAll(){for(const subscriptionId of this.__subscriptionIds.values())this.unsubscribe(subscriptionId)}writeSymbol(symbol,writeValue,callback,cbErrorEl){TcHmi.Server.writeSymbol(symbol,writeValue,(data=>{const cmd=data.response?.commands?.[0];cmd&&(cmd.error&&cmd.error.code!==TcHmi.Errors.NONE?TcHmi.Log.error(`Unable to write to symbol '${symbol}'. Errordetail: ${TcHmi.Log.buildMessage(cmd.error)}`):callback&&callback(cmd.readValue))}))}}TcHmiEcDiagnosticsClasses.ControlCommunication=ControlCommunication}(Beckhoff.TcHmiEcDiagnosticsClasses||(Beckhoff.TcHmiEcDiagnosticsClasses={}))}(Controls.Beckhoff||(Controls.Beckhoff={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),function(TcHmi){!function(Controls){!function(Beckhoff){!function(TcHmiEcDiagnosticsClasses){class ControlLocalization extends EcDiagnostics.Commons.Localization{constructor(tchmiControlLocalization){super(),this.__localizationReader=null,this.__destroyLocalizationWatch=null,this.__destroyLocalizationWatch=tchmiControlLocalization.watchEx({level:TCHMI_DESIGNER?TcHmi.Locale.Level.Engineering:TcHmi.Locale.Level.Application},(data=>{data.error===TcHmi.Errors.NONE&&data.reader&&(this.__localizationReader=data.reader,this.updateAllElements())}))}getLocalizedText(contentKey){return this.__localizationReader?tchmi_decode_control_characters(this.__localizationReader.get(contentKey)):contentKey}destroy(){super.destroy(),this.__destroyLocalizationWatch?.(),this.__destroyLocalizationWatch=null}}TcHmiEcDiagnosticsClasses.ControlLocalization=ControlLocalization}(Beckhoff.TcHmiEcDiagnosticsClasses||(Beckhoff.TcHmiEcDiagnosticsClasses={}))}(Controls.Beckhoff||(Controls.Beckhoff={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={}));var TcHmi,__classPrivateFieldGet=this&&this.__classPrivateFieldGet||function(receiver,state,kind,f){if("a"===kind&&!f)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof state?receiver!==state||!f:!state.has(receiver))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===kind?f:"a"===kind?f.call(receiver):f?f.value:state.get(receiver)};!function(TcHmi){!function(Controls){!function(Beckhoff){var _a,_TcHmiEcDiagnostics_tchmiFQN;class TcHmiEcDiagnostics extends TcHmi.Controls.System.TcHmiControl{constructor(element,pcElement,attrs){super(element,pcElement,attrs),this.__loadTemplatePromise=null,this.__allowZoomAndPan=!0,this.__toolboxResetView=!0,this.__initTopologyView=void 0,this.__onResolverForInitTopologyViewCallback=data=>{if(!1===this.__isAttached&&this.__suspendObjectResolver("initTopologyView"),data.error!==TcHmi.Errors.NONE)return void(TCHMI_CONSOLE_LOG_LEVEL>=1&&TcHmi.Log.errorEx("[Source=Control, Module="+this.__type+(__classPrivateFieldGet(TcHmiEcDiagnostics,_a,"f",_TcHmiEcDiagnostics_tchmiFQN)!==this.__type?", Origin="+__classPrivateFieldGet(TcHmiEcDiagnostics,_a,"f",_TcHmiEcDiagnostics_tchmiFQN):"")+", Id="+this.getId()+", Attribute=InitTopologyView] Resolving symbols from object failed with error: "+TcHmi.Log.buildMessage(data.details)));if(tchmi_equal(data.value,this.__initTopologyView))return;this.__initTopologyView=data.value;const value={pos:{x:data.value?.posX??0,y:data.value?.posY??0},zoom:data.value?.zoom?data.value.zoom/100:null};TcHmi.EventProvider.raise(this.__id+".onPropertyChanged",{propertyName:"InitTopologyView"}),this.__ecDiagnostics.updateConfigInitTopology(value,!TCHMI_DESIGNER)}}__previnit(){this.__elementTemplateRoot=this.__element.find(".TcHmi_Controls_Beckhoff_TcHmiEcDiagnostics");const commonPath=TcHmi.Environment.getControlBasePathEx(this)+"/",config={device:this.__device??"",allowZoomAndPan:this.__allowZoomAndPan,toolboxResetView:this.__toolboxResetView,initTopologyViewPosX:0,initTopologyViewPosY:0,initTopologyViewZoom:null},rootEl=this.__elementTemplateRoot.get(0);if(!rootEl)return void TcHmi.Log.error("Can not find root element this.__elementTemplateRoot.get(0)");const ecDiagnosticsMain=rootEl.querySelector("beckhoff-ec-diagnostics");if(!ecDiagnosticsMain)return void TcHmi.Log.error("Can not find element <beckhoff-ec-diagnostics></beckhoff-ec-diagnostics>");const localization=new Beckhoff.TcHmiEcDiagnosticsClasses.ControlLocalization(this.__localization);null!==commonPath?(this.__ecDiagnostics=new EcDiagnostics.Commons.EcDiagnostics(ecDiagnosticsMain,localization,commonPath,config),this.__updateTheme(),this.__ecDiagnostics.setCustomTopMostLayerFunction(this.addTopMostLayer.bind(this),this.removeTopMostLayer.bind(this)),TCHMI_UNITTEST_MODE||(this.__loadTemplatePromise=this.__ecDiagnostics.loadTemplates().then((()=>{const comObj=new Beckhoff.TcHmiEcDiagnosticsClasses.ControlCommunication(this.__ecDiagnostics);return this.__ecDiagnostics.comObj=comObj,Promise.resolve()}))),super.__previnit()):TcHmi.Log.error("BaseDir is not defined.")}__init(){super.__init()}__attach(){this.__loadTemplatePromise?.then((()=>{this.__themeDataChangedDestroyFn=TcHmi.EventProvider.register("onThemeDataChanged",(()=>{this.__updateTheme(),this.__ecDiagnostics.reload()})),this.__ecDiagnostics.preInit(!TCHMI_DESIGNER)})),super.__attach()}resetView(){this.__ecDiagnostics?.resetView()}addTopMostLayer(element){TcHmi.TopMostLayer.add(this,element,{dimBackground:!1,closeOnBackground:!1,modal:!1})}removeTopMostLayer(element){TcHmi.TopMostLayer.remove(this,element)}__updateTheme(){const description=TcHmi.System.Services.controlManager.getDescription(this.getType());if(!description)return void TcHmi.Log.error("Unable to read description.");const themedResources=description.themedResources,themeEntry={};for(const themedResource of themedResources){const themed=TcHmi.Theme.Resources.get(this,themedResource.name);let themeEntryChild=themeEntry;const[resourceName,...resourcePath]=themedResource.name.split("/").reverse();for(const path of resourcePath.reverse())themeEntryChild.hasOwnProperty(path)||(themeEntryChild[path]={}),themeEntryChild=themeEntryChild[path];let themedValue=themed.value;null!==themedValue?(themedValue.hasOwnProperty("color")&&(themedValue=EcDiagnostics.Commons.ColorRGBA.resolveSolidColorAsRGBA(themed.value)),themeEntryChild[resourceName]=themedValue,EcDiagnostics.Commons.processTheming(themeEntry)):TcHmi.Log.warn(`No themed value for ${themedResource.name}`)}}__detach(){this.__themeDataChangedDestroyFn?.(),this.__themeDataChangedDestroyFn=void 0,this.__ecDiagnostics.comObj?.unsubscribeAll(),super.__detach()}destroy(){this.__keepAlive||(this.__ecDiagnostics.destroy(),super.destroy())}setDevice(valueNew){let convertedValue=TcHmi.ValueConverter.toString(valueNew);null===convertedValue&&(convertedValue=this.getAttributeDefaultValueInternal("Device")),convertedValue!==this.__device&&(this.__device=convertedValue,TcHmi.EventProvider.raise(this.__id+".onPropertyChanged",{propertyName:"Device"}),this.__ecDiagnostics.updateConfigDevice(this.__device,!TCHMI_DESIGNER),this.__processEcDiagnosticsConfig())}getDevice(){return this.__device}setAllowZoomAndPan(valueNew){let convertedValue=TcHmi.ValueConverter.toBoolean(valueNew);null===convertedValue&&(convertedValue=this.getAttributeDefaultValueInternal("AllowZoomAndPan")),convertedValue!==this.__allowZoomAndPan&&(this.__allowZoomAndPan=convertedValue,TcHmi.EventProvider.raise(this.__id+".onPropertyChanged",{propertyName:"AllowZoomAndPan"}),this.__ecDiagnostics.updateConfigAllowZoomAndPan(this.__allowZoomAndPan,!TCHMI_DESIGNER))}getAllowZoomAndPan(){return this.__allowZoomAndPan}setToolboxResetView(valueNew){let convertedValue=TcHmi.ValueConverter.toBoolean(valueNew);null===convertedValue&&(convertedValue=this.getAttributeDefaultValueInternal("ToolboxResetView")),convertedValue!==this.__toolboxResetView&&(this.__toolboxResetView=convertedValue,TcHmi.EventProvider.raise(this.__id+".onPropertyChanged",{propertyName:"ToolboxResetView"}),this.__ecDiagnostics.updateConfigToolboxResetView(this.__toolboxResetView,!TCHMI_DESIGNER))}getToolboxResetView(){return this.__toolboxResetView}__processEcDiagnosticsConfig(){if(TCHMI_DESIGNER){const localization=this.__ecDiagnostics.getLocalization(),designerMessage=this.__element.find(".tchmi-designer-control-message")[0]??document.createElement("div");designerMessage.classList.add("tchmi-designer-control-message"),designerMessage.innerHTML="Engineering_Not_Configured",this.__element[0].appendChild(designerMessage),this.__device?localization.addElement(designerMessage,"Engineering_Device",[this.__device]):localization.addElement(designerMessage,"Engineering_Device_Not_Configured")}}setInitTopologyView(valueNew){let convertedValue=TcHmi.ValueConverter.toObject(valueNew);null===convertedValue&&(convertedValue=this.getAttributeDefaultValueInternal("InitTopologyView"));const resolverInfo=this.__objectResolvers.get("initTopologyView");resolverInfo&&(resolverInfo.watchDestroyer&&resolverInfo.watchDestroyer(),resolverInfo.resolver.destroy());const resolver=new TcHmi.Symbol.ObjectResolver(convertedValue,this);this.__objectResolvers.set("initTopologyView",{resolver:resolver,watchCallback:this.__onResolverForInitTopologyViewCallback,watchDestroyer:resolver.watch(this.__onResolverForInitTopologyViewCallback)})}getInitTopologyView(){return this.__initTopologyView}}_TcHmiEcDiagnostics_tchmiFQN={value:"TcHmi.Controls.Beckhoff."+(_a=TcHmiEcDiagnostics).name},Beckhoff.TcHmiEcDiagnostics=TcHmiEcDiagnostics}(Controls.Beckhoff||(Controls.Beckhoff={}))}(TcHmi.Controls||(TcHmi.Controls={}))}(TcHmi||(TcHmi={})),TcHmi.Controls.registerEx("TcHmiEcDiagnostics","TcHmi.Controls.Beckhoff",TcHmi.Controls.Beckhoff.TcHmiEcDiagnostics);