import unittest
import os
import sys
import io


class TestMiklavz(unittest.TestCase):
    cwd = os.getcwd()

    @classmethod
    def setUpClass(cls):
        cls.unmake_franc()

    @classmethod
    def make_franc(cls):
        open(os.path.join(cls.cwd, "pisma/franc.txt"), "wt")

    @classmethod
    def unmake_franc(cls):
        try:
            os.remove(os.path.join(cls.cwd, "pisma/franc.txt"))
        except:
            pass

    def test_preberi_datoteko(self):
        self.assertSetEqual(preberi_datoteko("ana"),
                            {'sanke', 'zvezek', 'pero'})
        try:
            self.make_franc()
            self.assertSetEqual(preberi_datoteko("franc"), set())
        finally:
            self.unmake_franc()

    def test_pisci(self):
        self.assertSetEqual(
            pisci(),
            {"ana", "berta", "cilka", "dani", "ema"})
        self.assertSetEqual(
            pisci(),
            {"ana", "berta", "cilka", "dani", "ema"})
        try:
            self.make_franc()
            self.assertSetEqual(
                pisci(),
                {"ana", "berta", "cilka", "dani", "ema", "franc"})
        finally:
            self.unmake_franc()
        self.assertSetEqual(
            pisci(),
            {"ana", "berta", "cilka", "dani", "ema"})

    def test_zelje(self):
        self.assertDictEqual(
            zelje(["ana"]),
            {"ana": {'sanke', 'pero', 'zvezek'}})
        self.assertDictEqual(
            zelje(["cilka", "ema"]),
            {'cilka': {'notni zvezek', 'lok za violino'},
             'ema': {'copati', 'glavnik'}}
        )
        self.assertDictEqual(
            zelje(["ana", "berta", "cilka", "dani", "ema"]),
            {'ana': {'sanke', 'pero', 'zvezek'},
             'berta': {'copati', 'zvezek'},
             'cilka': {'notni zvezek', 'lok za violino'},
             'dani': {'zvezek', 'orglice', 'glavnik'},
             'ema': {'copati', 'glavnik'}
             }
        )
        try:
            self.make_franc()
            self.assertDictEqual(zelje(["franc"]), {"franc": set()})
            self.assertDictEqual(
                zelje(["ana", "berta", "cilka", "dani", "ema"]),
                {'ana': {'sanke', 'pero', 'zvezek'},
                 'berta': {'copati', 'zvezek'},
                 'cilka': {'notni zvezek', 'lok za violino'},
                 'dani': {'zvezek', 'orglice', 'glavnik'},
                 'ema': {'copati', 'glavnik'}
                 }
            )
        finally:
            self.unmake_franc()

    def test_prestej_stvari(self):
        self.assertDictEqual(
            prestej_stvari({'ana': {'sanke', 'pero', 'zvezek'},
                            'berta': {'copati', 'zvezek'},
                            'cilka': {'notni zvezek', 'lok za violino'},
                            'dani': {'zvezek', 'orglice', 'glavnik'},
                            'ema': {'copati', 'glavnik'}
                            }),
            {'zvezek': 3, 'glavnik': 2, 'copati': 2, 'pero': 1,
             'notni zvezek': 1, 'sanke': 1, 'lok za violino': 1, 'orglice': 1}
        )
        self.assertDictEqual(
            prestej_stvari({'ana': {'sanke', 'pero', 'zvezek'},
                            'cilka': {'notni zvezek', 'lok za violino'},
                            'dani': {'zvezek', 'orglice', 'glavnik'}
                            }),
            {'zvezek': 2, 'glavnik': 1, 'pero': 1,
             'notni zvezek': 1, 'sanke': 1, 'lok za violino': 1, 'orglice': 1}
        )
        self.assertDictEqual(
            prestej_stvari({'ana': {'sanke', 'pero', 'zvezek'},
                            'cilka': {'notni zvezek', 'lok za violino'},
                            'dani': {'zvezek', 'orglice', 'glavnik'},
                            'franc': set()
                            }),
            {'zvezek': 2, 'glavnik': 1, 'pero': 1,
             'notni zvezek': 1, 'sanke': 1, 'lok za violino': 1, 'orglice': 1}
        )
        self.assertDictEqual(
            prestej_stvari({'ana': {'sanke', 'pero', 'zvezek'},
                            'franc': set()
                            }),
            {'pero': 1, 'sanke': 1, 'zvezek': 1}
        )
        self.assertDictEqual(
            prestej_stvari({'ana': {'sanke', 'pero', 'zvezek'},
                            }),
            {'pero': 1, 'sanke': 1, 'zvezek': 1}
        )
        self.assertDictEqual(
            prestej_stvari({'franc': set()}), {})
        self.assertDictEqual(
            prestej_stvari({}), {})

    def test_izpisi_stvari(self):
        try:
            stdout = sys.stdout

            sys.stdout = io.StringIO()
            izpisi_stvari({'zvezek': 3, 'glavnik': 2, 'pero': 1,
                           'notni zvezek': 1, 'sanke': 1, 'lok za violino': 1,
                           'orglice': 1, 'copati': 2})
            self.assertSetEqual(
                set(sys.stdout.getvalue().splitlines()),
                {"notni zvezek........1", "sanke...............1",
                 "orglice.............1", "glavnik.............2",
                 "lok za violino......1", "copati..............2",
                 "zvezek..............3", "pero................1"})

            sys.stdout = io.StringIO()
            izpisi_stvari({'zvezek': 3, 'glavnik': 2})
            self.assertSetEqual(
                set(sys.stdout.getvalue().splitlines()),
                {"glavnik.............2", "zvezek..............3"})

        finally:
            sys.stdout = stdout

    def test_podobnosti(self):
        try:
            stdout = sys.stdout

            sys.stdout = io.StringIO()
            podobnosti(["ana", "berta", "cilka", "dani", "ema"])
            self.assertSetEqual(
                set(sys.stdout.getvalue().splitlines()),
                {"     berta : ema       0.33",
                 "      dani : ema       0.25",
                 "     berta : dani      0.25",
                 "       ana : berta     0.25"})

            sys.stdout = io.StringIO()
            podobnosti(["ana", "berta", "dani", "ema"])
            self.assertSetEqual(
                set(sys.stdout.getvalue().splitlines()),
                {"     berta : ema       0.33",
                 "      dani : ema       0.25",
                 "     berta : dani      0.25",
                 "       ana : berta     0.25"})

            sys.stdout = io.StringIO()
            podobnosti(["berta", "dani", "ema"])
            self.assertSetEqual(
                set(sys.stdout.getvalue().splitlines()),
                {"     berta : ema       0.33",
                 "      dani : ema       0.25",
                 "     berta : dani      0.25"})

        finally:
            sys.stdout = stdout


if __name__ == "__main__":
    unittest.main()
