// prevajanje datoteke *.proto na Arnes HPC:
//   - namestitev modulov
//      module load protobuf
//      module load binutils/2.39-GCCcore-12.2.0
//      go install google.golang.org/protobuf/cmd/protoc-gen-go@latest (samo ob prvi uporabi)
//      go install google.golang.org/grpc/cmd/protoc-gen-go-grpc@latest (samo ob prvi uporabi)
//      export PATH="$PATH:$(go env GOPATH)/bin"
//   - prevajanje
//      srun protoc --go_out=. --go_opt=paths=source_relative --go-grpc_out=. --go-grpc_opt=paths=source_relative protobufStorage.proto

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             v6.33.1
// source: protobufStorage.proto

package protobufStorage

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	CRUD_Create_FullMethodName    = "/protobufStorage.CRUD/Create"
	CRUD_Read_FullMethodName      = "/protobufStorage.CRUD/Read"
	CRUD_Update_FullMethodName    = "/protobufStorage.CRUD/Update"
	CRUD_Delete_FullMethodName    = "/protobufStorage.CRUD/Delete"
	CRUD_ReadAll_FullMethodName   = "/protobufStorage.CRUD/ReadAll"
	CRUD_Subscribe_FullMethodName = "/protobufStorage.CRUD/Subscribe"
)

// CRUDClient is the client API for CRUD service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CRUDClient interface {
	Create(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Read(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*TodoStorage, error)
	Update(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Delete(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error)
	ReadAll(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Todo], error)
	Subscribe(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[TodoEvent], error)
}

type cRUDClient struct {
	cc grpc.ClientConnInterface
}

func NewCRUDClient(cc grpc.ClientConnInterface) CRUDClient {
	return &cRUDClient{cc}
}

func (c *cRUDClient) Create(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CRUD_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cRUDClient) Read(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*TodoStorage, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TodoStorage)
	err := c.cc.Invoke(ctx, CRUD_Read_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cRUDClient) Update(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CRUD_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cRUDClient) Delete(ctx context.Context, in *Todo, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CRUD_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cRUDClient) ReadAll(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Todo], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &CRUD_ServiceDesc.Streams[0], CRUD_ReadAll_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[emptypb.Empty, Todo]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CRUD_ReadAllClient = grpc.ServerStreamingClient[Todo]

func (c *cRUDClient) Subscribe(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (grpc.ServerStreamingClient[TodoEvent], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &CRUD_ServiceDesc.Streams[1], CRUD_Subscribe_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[emptypb.Empty, TodoEvent]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CRUD_SubscribeClient = grpc.ServerStreamingClient[TodoEvent]

// CRUDServer is the server API for CRUD service.
// All implementations must embed UnimplementedCRUDServer
// for forward compatibility.
type CRUDServer interface {
	Create(context.Context, *Todo) (*emptypb.Empty, error)
	Read(context.Context, *Todo) (*TodoStorage, error)
	Update(context.Context, *Todo) (*emptypb.Empty, error)
	Delete(context.Context, *Todo) (*emptypb.Empty, error)
	ReadAll(*emptypb.Empty, grpc.ServerStreamingServer[Todo]) error
	Subscribe(*emptypb.Empty, grpc.ServerStreamingServer[TodoEvent]) error
	mustEmbedUnimplementedCRUDServer()
}

// UnimplementedCRUDServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedCRUDServer struct{}

func (UnimplementedCRUDServer) Create(context.Context, *Todo) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedCRUDServer) Read(context.Context, *Todo) (*TodoStorage, error) {
	return nil, status.Error(codes.Unimplemented, "method Read not implemented")
}
func (UnimplementedCRUDServer) Update(context.Context, *Todo) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedCRUDServer) Delete(context.Context, *Todo) (*emptypb.Empty, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedCRUDServer) ReadAll(*emptypb.Empty, grpc.ServerStreamingServer[Todo]) error {
	return status.Error(codes.Unimplemented, "method ReadAll not implemented")
}
func (UnimplementedCRUDServer) Subscribe(*emptypb.Empty, grpc.ServerStreamingServer[TodoEvent]) error {
	return status.Error(codes.Unimplemented, "method Subscribe not implemented")
}
func (UnimplementedCRUDServer) mustEmbedUnimplementedCRUDServer() {}
func (UnimplementedCRUDServer) testEmbeddedByValue()              {}

// UnsafeCRUDServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CRUDServer will
// result in compilation errors.
type UnsafeCRUDServer interface {
	mustEmbedUnimplementedCRUDServer()
}

func RegisterCRUDServer(s grpc.ServiceRegistrar, srv CRUDServer) {
	// If the following call panics, it indicates UnimplementedCRUDServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&CRUD_ServiceDesc, srv)
}

func _CRUD_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Todo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CRUDServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CRUD_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CRUDServer).Create(ctx, req.(*Todo))
	}
	return interceptor(ctx, in, info, handler)
}

func _CRUD_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Todo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CRUDServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CRUD_Read_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CRUDServer).Read(ctx, req.(*Todo))
	}
	return interceptor(ctx, in, info, handler)
}

func _CRUD_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Todo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CRUDServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CRUD_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CRUDServer).Update(ctx, req.(*Todo))
	}
	return interceptor(ctx, in, info, handler)
}

func _CRUD_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Todo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CRUDServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CRUD_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CRUDServer).Delete(ctx, req.(*Todo))
	}
	return interceptor(ctx, in, info, handler)
}

func _CRUD_ReadAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CRUDServer).ReadAll(m, &grpc.GenericServerStream[emptypb.Empty, Todo]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CRUD_ReadAllServer = grpc.ServerStreamingServer[Todo]

func _CRUD_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CRUDServer).Subscribe(m, &grpc.GenericServerStream[emptypb.Empty, TodoEvent]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type CRUD_SubscribeServer = grpc.ServerStreamingServer[TodoEvent]

// CRUD_ServiceDesc is the grpc.ServiceDesc for CRUD service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CRUD_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "protobufStorage.CRUD",
	HandlerType: (*CRUDServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _CRUD_Create_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _CRUD_Read_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _CRUD_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _CRUD_Delete_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadAll",
			Handler:       _CRUD_ReadAll_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Subscribe",
			Handler:       _CRUD_Subscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "protobufStorage.proto",
}
